/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.BEASTVersion2;
import beast.app.beauti.BeautiAlignmentProvider;
import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiDocListener;
import beast.app.beauti.BeautiPanel;
import beast.app.beauti.BeautiPanelConfig;
import beast.app.beauti.JPackageDialog;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.HelpBrowser;
import beast.app.draw.ModelBuilder;
import beast.app.draw.MyAction;
import beast.app.tools.AppStore;
import beast.core.BEASTInterface;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.math.distributions.MRCAPrior;
import beast.util.AddOnManager;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.MultiDocApplication;
import jam.mac.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Beauti
extends JTabbedPane
implements BeautiDocListener {
    private static final long serialVersionUID = 1L;
    static final String BEAUTI_ICON = "beast/app/draw/icons/beauti.png";
    public static String g_sDir = System.getProperty("user.dir");
    public static final String FILE_EXT = ".xml";
    public static final String FILE_EXT2 = ".json";
    static final String fileSep = System.getProperty("file.separator");
    public BeautiDoc doc;
    public JFrame frame;
    public BeautiPanel currentTab;
    public boolean[] isPaneIsVisible;
    public BeautiPanel[] panels;
    JMenu fileMenu;
    JMenu templateMenu;
    JMenu viewMenu;
    JCheckBoxMenuItem autoSetClockRate;
    JCheckBoxMenuItem allowLinking;
    JCheckBoxMenuItem autoUpdateFixMeanSubstRate;
    public boolean isInitialising = true;
    Action a_new = new ActionNew();
    public Action a_load = new ActionLoad();
    Action a_template = new ActionTemplate();
    Action a_addOn = new ActionAddOn();
    Action a_appLauncher = new ActionAppLauncher();
    public Action a_save = new ActionSave();
    Action a_saveas = new ActionSaveAs();
    Action a_close = new ActionClose();
    Action a_quit = new ActionQuit();
    Action a_viewall = new ActionViewAllPanels();
    Action a_help = new ActionHelp();
    Action a_msgs = new ActionMsgs();
    Action a_citation = new ActionCitation();
    Action a_about = new ActionAbout();
    Action a_viewModel = new ActionViewModel();
    ViewPanelCheckBoxMenuItem[] m_viewPanelCheckBoxMenuItems;
    static int BEAUtiIntances = 0;

    public Beauti(BeautiDoc beautiDoc) {
        this.isPaneIsVisible = new boolean[beautiDoc.beautiConfig.panels.size()];
        Arrays.fill(this.isPaneIsVisible, true);
        this.doc = beautiDoc;
        this.doc.addBeautiDocListener(this);
        beautiDoc.setBeauti(this);
    }

    void setTitle() {
        this.frame.setTitle("BEAUti 2: " + this.doc.getTemplateName() + " " + this.doc.getFileName());
    }

    void toggleVisible(int n) {
        if (this.isPaneIsVisible[n]) {
            this.isPaneIsVisible[n] = false;
            int n2 = this.tabNrForPanel(n);
            this.removeTabAt(n2);
        } else {
            this.isPaneIsVisible[n] = true;
            int n3 = this.tabNrForPanel(n);
            BeautiPanelConfig beautiPanelConfig = this.doc.beautiConfig.panels.get(n);
            this.insertTab(this.doc.beautiConfig.getButtonLabel(this, beautiPanelConfig.nameInput.get()), null, this.panels[n], beautiPanelConfig.tipTextInput.get(), n3);
            this.setSelectedIndex(n3);
        }
    }

    int tabNrForPanel(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.isPaneIsVisible[i]) continue;
            ++n2;
        }
        return n2;
    }

    @Override
    public void docHasChanged() throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setUpPanels();
        this.setUpViewMenu();
        this.setTitle();
    }

    boolean saveAs() {
        String string;
        File file;
        if (this.doc.validateModel() == BeautiDoc.DOC_STATUS.NO_DOCUMENT) {
            JOptionPane.showMessageDialog(null, "There is no data to save to file");
            return false;
        }
        String string2 = System.getProperty("file.separator");
        if (string2.equals("\\")) {
            string2 = "\\\\";
        }
        if ((file = beast.app.util.Utils.getSaveFile("Save Model As", new File(string = g_sDir + (this.doc.getFileName().equals("") ? "" : string2 + new File(this.doc.getFileName()).getName())), null, FILE_EXT, FILE_EXT2)) != null) {
            if (file.exists() && !beast.app.util.Utils.isMac() && JOptionPane.showConfirmDialog(null, "File " + file.getName() + " already exists. Do you want to overwrite?", "Overwrite file?", 1) != 0) {
                return false;
            }
            this.doc.setFileName(file.getAbsolutePath());
            if (this.doc.getFileName().lastIndexOf(string2) > 0) {
                g_sDir = this.doc.getFileName().substring(0, this.doc.getFileName().lastIndexOf(string2));
            }
            if (!this.doc.getFileName().toLowerCase().endsWith(FILE_EXT) && !this.doc.getFileName().toLowerCase().endsWith(FILE_EXT2)) {
                this.doc.setFileName(this.doc.getFileName().concat(FILE_EXT));
            }
            this.saveFile(this.doc.getFileName());
            this.setTitle();
            return true;
        }
        return false;
    }

    public void saveFile(String string) {
        try {
            if (this.currentTab != null) {
                this.currentTab.config.sync(this.currentTab.partitionIndex);
            } else {
                this.panels[0].config.sync(0);
            }
            this.doc.save(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean quit() {
        if (this.doc.validateModel() == BeautiDoc.DOC_STATUS.DIRTY) {
            int n = JOptionPane.showConfirmDialog(null, "Do you want to save the Beast specification?", "Save before closing?", 1);
            Log.err.println("result=" + n);
            if (n == 2) {
                return false;
            }
            if (n == 0 && !this.saveAs()) {
                return false;
            }
        }
        return true;
    }

    public void refreshPanel() {
        try {
            BeautiPanel beautiPanel = (BeautiPanel)this.getSelectedComponent();
            if (beautiPanel != null) {
                this.doc.determinePartitions();
                beautiPanel.updateList();
                beautiPanel.refreshPanel();
            }
            this.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('F');
        jMenuBar.add(this.fileMenu);
        this.createFileMenu();
        JMenu jMenu = new JMenu("Mode");
        jMenuBar.add(jMenu);
        jMenu.setMnemonic('M');
        this.autoSetClockRate = new JCheckBoxMenuItem("Automatic set clock rate", this.doc.autoSetClockRate);
        this.autoSetClockRate.addActionListener(actionEvent -> {
            this.doc.autoSetClockRate = this.autoSetClockRate.getState();
            this.refreshPanel();
        });
        jMenu.add(this.autoSetClockRate);
        this.allowLinking = new JCheckBoxMenuItem("Allow parameter linking", this.doc.allowLinking);
        this.allowLinking.addActionListener(actionEvent -> {
            this.doc.allowLinking = this.allowLinking.getState();
            this.doc.determineLinks();
            this.refreshPanel();
        });
        jMenu.add(this.allowLinking);
        this.autoUpdateFixMeanSubstRate = new JCheckBoxMenuItem("Automatic set fix mean substitution rate flag", this.doc.autoUpdateFixMeanSubstRate);
        this.autoUpdateFixMeanSubstRate.addActionListener(actionEvent -> {
            this.doc.autoUpdateFixMeanSubstRate = this.autoUpdateFixMeanSubstRate.getState();
            this.refreshPanel();
        });
        jMenu.add(this.autoUpdateFixMeanSubstRate);
        this.viewMenu = new JMenu("View");
        jMenuBar.add(this.viewMenu);
        this.viewMenu.setMnemonic('V');
        this.setUpViewMenu();
        JMenu jMenu2 = new JMenu("Help");
        jMenuBar.add(jMenu2);
        jMenu2.setMnemonic('H');
        jMenu2.add(this.a_help);
        jMenu2.add(this.a_msgs);
        jMenu2.add(this.a_citation);
        jMenu2.add(this.a_viewModel);
        if (!beast.app.util.Utils.isMac()) {
            jMenu2.add(this.a_about);
        }
        this.setMenuVisibiliy("", jMenuBar);
        return jMenuBar;
    }

    private void createFileMenu() {
        this.fileMenu.removeAll();
        this.fileMenu.add(this.a_new);
        this.fileMenu.add(this.a_load);
        this.fileMenu.addSeparator();
        this.addAlignmentProviderMenus(this.fileMenu);
        this.fileMenu.addSeparator();
        this.templateMenu = new JMenu("Template");
        this.fileMenu.add(this.templateMenu);
        List<AbstractAction> list = this.getTemplateActions();
        for (AbstractAction object2 : list) {
            this.templateMenu.add(object2);
        }
        JMenu jMenu = new JMenu("Set working dir");
        this.fileMenu.add(jMenu);
        List<AbstractAction> list2 = this.getWorkDirActions();
        for (AbstractAction abstractAction : list2) {
            jMenu.add(abstractAction);
        }
        this.templateMenu.addSeparator();
        this.templateMenu.add(this.a_template);
        this.fileMenu.add(this.a_addOn);
        this.fileMenu.add(this.a_appLauncher);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.a_save);
        this.fileMenu.add(this.a_saveas);
        if (!beast.app.util.Utils.isMac()) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.a_close);
            this.fileMenu.add(this.a_quit);
        }
    }

    private void addAlignmentProviderMenus(JMenu jMenu) {
        List<BeautiAlignmentProvider> list = this.doc.beautiConfig.alignmentProvider;
        for (final BeautiAlignmentProvider beautiAlignmentProvider : list) {
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        Beauti.this.setCursor(new Cursor(3));
                        List<BEASTInterface> list = beautiAlignmentProvider.getAlignments(Beauti.this.doc);
                        if (list != null) {
                            for (BEASTInterface bEASTInterface : list) {
                                if (!(bEASTInterface instanceof Alignment)) continue;
                                try {
                                    BeautiDoc.createTaxonSet((Alignment)bEASTInterface, Beauti.this.doc);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                            }
                        }
                        Beauti.this.doc.connectModel();
                        Beauti.this.doc.fireDocHasChanged();
                        if (list != null) {
                            for (BEASTInterface bEASTInterface : list) {
                                if (!(bEASTInterface instanceof MRCAPrior)) continue;
                                Beauti.this.doc.addMRCAPrior((MRCAPrior)bEASTInterface);
                            }
                        }
                        Beauti.this.a_save.setEnabled(true);
                        Beauti.this.a_saveas.setEnabled(true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        String string = "Something went wrong importing the alignment:\n";
                        JTextArea jTextArea = new JTextArea(string);
                        jTextArea.setColumns(30);
                        jTextArea.setLineWrap(true);
                        jTextArea.setWrapStyleWord(true);
                        jTextArea.append(exception.getMessage());
                        jTextArea.setSize(jTextArea.getPreferredSize().width, 1);
                        jTextArea.setOpaque(false);
                        JOptionPane.showMessageDialog(null, jTextArea, "Error importing alignment", 2);
                    }
                    Beauti.this.setCursor(new Cursor(0));
                }
            };
            String string = beautiAlignmentProvider.toString().replaceAll("Add ", "Add partition for ");
            abstractAction.putValue("ShortDescription", string);
            abstractAction.putValue("LongDescription", string);
            abstractAction.putValue("Name", beautiAlignmentProvider.toString());
            jMenu.add(abstractAction);
        }
    }

    void setUpViewMenu() {
        Serializable serializable;
        this.m_viewPanelCheckBoxMenuItems = null;
        this.viewMenu.removeAll();
        for (int i = 0; i < this.doc.beautiConfig.panels.size(); ++i) {
            serializable = new ViewPanelCheckBoxMenuItem(i);
            serializable.addActionListener(arg_0 -> Beauti.lambda$setUpViewMenu$18((ViewPanelCheckBoxMenuItem)serializable, arg_0));
            this.viewMenu.add((JMenuItem)serializable);
        }
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.a_viewall);
        this.viewMenu.addSeparator();
        MyAction myAction = new MyAction("Zoom in", "Increase font size of all components", null, 61){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UIManager.getFont("Label.font").getSize();
                beast.app.util.Utils.setFontSize(n + 1);
                beast.app.util.Utils.saveBeautiProperty("fontsize", n + 1 + "");
                Beauti.this.refreshPanel();
                Beauti.this.repaint();
            }
        };
        serializable = new MyAction("Zoom out", "Decrease font size of all components", null, 45){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = UIManager.getFont("Label.font").getSize();
                beast.app.util.Utils.setFontSize(Math.max(n - 1, 4));
                beast.app.util.Utils.saveBeautiProperty("fontsize", Math.max(n - 1, 4) + "");
                Beauti.this.refreshPanel();
                Beauti.this.repaint();
            }
        };
        this.viewMenu.add(myAction);
        this.viewMenu.add((Action)((Object)serializable));
    }

    private List<AbstractAction> getTemplateActions() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        List<String> list = AddOnManager.getBeastDirectories();
        for (String string : list) {
            File file = new File(string + "/templates");
            this.getTemplateActionForDir(file, arrayList);
        }
        return arrayList;
    }

    private void getTemplateActionForDir(File file, List<AbstractAction> list) {
        File[] fileArray;
        if (file.exists() && file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().toLowerCase().endsWith(FILE_EXT)) continue;
                try {
                    String string = BeautiDoc.load(file2.getAbsolutePath());
                    if (!string.contains("templateinfo=")) continue;
                    String string2 = file2.getName();
                    string2 = string2.substring(0, string2.length() - 4);
                    boolean bl = false;
                    for (AbstractAction abstractAction : list) {
                        String string3 = abstractAction.getValue("Name").toString();
                        if (!string3.equals(string2)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    list.add(new TemplateAction(file2));
                }
                catch (Exception exception) {
                    Log.warning.println(exception.getMessage());
                }
            }
        }
    }

    private List<AbstractAction> getWorkDirActions() {
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        List<String> list = AddOnManager.getBeastDirectories();
        HashSet<String> hashSet = new HashSet<String>();
        for (final String string : list) {
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            String string2 = string + File.separator + "examples";
            if (!new File(string2).exists()) continue;
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    g_sDir = string;
                }
            };
            String string3 = "Set working directory to " + string;
            String string4 = string;
            if (string4.indexOf(File.separator) >= 0) {
                string4 = string.substring(string.lastIndexOf(File.separator) + 1);
            }
            abstractAction.putValue("ShortDescription", string3);
            abstractAction.putValue("LongDescription", string3);
            abstractAction.putValue("Name", string4);
            arrayList.add(abstractAction);
        }
        return arrayList;
    }

    void setMenuVisibiliy(String string, Component component) {
        block7: {
            block6: {
                String string2 = "";
                if (component instanceof JMenu) {
                    string2 = ((JMenu)component).getText();
                } else if (component instanceof JMenuItem) {
                    string2 = ((JMenuItem)component).getText();
                }
                if (string2.length() > 0 && this.doc.beautiConfig.menuIsInvisible(string + string2)) {
                    component.setVisible(false);
                }
                if (!(component instanceof JMenu)) break block6;
                for (Component component2 : ((JMenu)component).getMenuComponents()) {
                    this.setMenuVisibiliy(string + string2 + (string2.length() > 0 ? "." : ""), component2);
                }
                break block7;
            }
            if (!(component instanceof Container)) break block7;
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                this.setMenuVisibiliy(string, ((Container)component).getComponent(i));
            }
        }
    }

    public void hidePanels() {
    }

    public void setUpPanels() throws NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        BeautiPanelConfig beautiPanelConfig;
        int n;
        this.isInitialising = true;
        if (this.getTabCount() > 0) {
            while (this.getTabCount() > 0) {
                this.removeTabAt(0);
            }
            this.isPaneIsVisible = new boolean[this.doc.beautiConfig.panels.size()];
            Arrays.fill(this.isPaneIsVisible, true);
        }
        for (n = 0; n < this.doc.beautiConfig.panels.size(); ++n) {
            beautiPanelConfig = this.doc.beautiConfig.panels.get(n);
            this.isPaneIsVisible[n] = beautiPanelConfig.isVisibleInput.get();
        }
        this.panels = new BeautiPanel[this.doc.beautiConfig.panels.size()];
        for (n = 0; n < this.doc.beautiConfig.panels.size(); ++n) {
            beautiPanelConfig = this.doc.beautiConfig.panels.get(n);
            this.panels[n] = new BeautiPanel(n, this.doc, beautiPanelConfig);
            this.addTab(this.doc.beautiConfig.getButtonLabel(this, beautiPanelConfig.getName()), null, this.panels[n], beautiPanelConfig.getTipText());
        }
        for (n = this.doc.beautiConfig.panels.size() - 1; n >= 0; --n) {
            if (this.isPaneIsVisible[n]) continue;
            this.removeTabAt(n);
        }
        this.isInitialising = false;
    }

    public static boolean isInBeauti() {
        return BEAUtiIntances > 0;
    }

    private static String usage() {
        return "java Beauti [options]\nwhere options can be one of the following:\n-template [template file] : BEAUti template to be used. Default templates/Standard.xml\n-nex [nexus data file] : nexus file to be read using template, multiple -nex arguments are allowed\n-xmldat [beast xml file] : as -nex but with BEAST 1 or 2 xml file instead of nexus file\n-xml [beast file] : BEAST 2 XML file to be loaded\n-exitaction [writexml|usetemplate|usexml] : what to do after processing arguments\n-out [output file name] : file to be written\n-capture : captures stdout and stderr and make them available under Help/Messages menu\n-v, -version : print version\n-h, -help : print this help message\n";
    }

    /*
     * WARNING - void declaration
     */
    public static Beauti main2(String[] stringArray) {
        try {
            JFrame jFrame;
            Object object;
            ByteArrayOutputStream byteArrayOutputStream = null;
            for (String object22 : stringArray) {
                if (object22.equals("-v") || object22.equals("-version")) {
                    System.out.println(new BEASTVersion2().getVersionString());
                    System.exit(0);
                }
                if (object22.equals("-h") || object22.equals("-help")) {
                    System.out.println(Beauti.usage());
                    System.exit(0);
                }
                if (!object22.equals("-capture")) continue;
                object = System.err;
                byteArrayOutputStream = new ByteArrayOutputStream((PrintStream)object){
                    final /* synthetic */ PrintStream val$beautiLog;
                    {
                        this.val$beautiLog = printStream;
                    }

                    @Override
                    public synchronized void write(byte[] byArray, int n, int n2) {
                        super.write(byArray, n, n2);
                        this.val$beautiLog.write(byArray, n, n2);
                    }

                    @Override
                    public synchronized void write(int n) {
                        super.write(n);
                        this.val$beautiLog.write(n);
                    }

                    @Override
                    public void write(byte[] byArray) throws IOException {
                        super.write(byArray);
                        this.val$beautiLog.write(byArray);
                    }

                    @Override
                    public void flush() throws IOException {
                        super.flush();
                        this.val$beautiLog.flush();
                    }

                    @Override
                    public void close() throws IOException {
                        super.close();
                        this.val$beautiLog.close();
                    }
                };
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                System.setOut(printStream);
                System.setErr(printStream);
                Log.err = printStream;
                Log.warning = printStream;
                Log.info = printStream;
                Log.debug = printStream;
                Log.trace = printStream;
            }
            AddOnManager.loadExternalJars();
            beast.app.util.Utils.loadUIManager();
            BEASTObjectPanel.init();
            BeautiDoc beautiDoc = new BeautiDoc();
            BeautiDoc.baos = byteArrayOutputStream;
            if (beautiDoc.parseArgs(stringArray) == BeautiDoc.ActionOnExit.WRITE_XML) {
                return null;
            }
            final Beauti beauti = new Beauti(beautiDoc);
            if (beast.app.util.Utils.isMac()) {
                Serializable serializable;
                try {
                    void var5_14;
                    serializable = ClassLoader.getSystemResource(BEAUTI_ICON);
                    Object var5_12 = null;
                    if (serializable != null) {
                        ImageIcon imageIcon = new ImageIcon((URL)serializable);
                    } else {
                        Log.warning.println("Unable to find image: beast/app/draw/icons/beauti.png");
                    }
                    object = new MultiDocApplication(null, "BEAUti", "about", (Icon)var5_14){

                        @Override
                        protected JFrame getDefaultFrame() {
                            return null;
                        }

                        @Override
                        public void doQuit() {
                            beauti.a_quit.actionPerformed(null);
                        }

                        @Override
                        public void doAbout() {
                            beauti.a_about.actionPerformed(null);
                        }

                        @Override
                        public DocumentFrame doOpenFile(File file) {
                            return null;
                        }

                        @Override
                        public DocumentFrame doNew() {
                            return null;
                        }
                    };
                    Utils.macOSXRegistration((Application)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    serializable = Class.forName("jam.maconly.OSXAdapter");
                    Method method = ((Class)serializable).getMethod("enablePrefs", Boolean.TYPE);
                    method.invoke(null, false);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            beauti.setUpPanels();
            beauti.currentTab = beauti.panels[0];
            beauti.hidePanels();
            beauti.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (beauti.currentTab == null) {
                        beauti.currentTab = beauti.panels[0];
                    }
                    if (beauti.currentTab != null) {
                        BeautiPanel beautiPanel;
                        if (!beauti.isInitialising) {
                            beauti.currentTab.config.sync(beauti.currentTab.partitionIndex);
                        }
                        beauti.currentTab = beautiPanel = (BeautiPanel)beauti.getSelectedComponent();
                        beauti.refreshPanel();
                    }
                }
            });
            beauti.setVisible(true);
            beauti.refreshPanel();
            beauti.frame = jFrame = new JFrame("BEAUti 2: " + beautiDoc.getTemplateName() + " " + beautiDoc.getFileName());
            ImageIcon imageIcon = beast.app.util.Utils.getIcon(BEAUTI_ICON);
            if (imageIcon != null) {
                jFrame.setIconImage(imageIcon.getImage());
            }
            object = beauti.makeMenuBar();
            jFrame.setJMenuBar((JMenuBar)object);
            if (beautiDoc.getFileName() != null || beautiDoc.alignments.size() > 0) {
                beauti.a_save.setEnabled(true);
                beauti.a_saveas.setEnabled(true);
            }
            jFrame.add(beauti);
            int n = UIManager.getFont("Label.font").getSize();
            jFrame.setSize(1024 * n / 13, 768 * n / 13);
            jFrame.setLocation(BEAUtiIntances * 10, BEAUtiIntances * 10);
            jFrame.setVisible(true);
            jFrame.setDefaultCloseOperation(0);
            ++BEAUtiIntances;
            jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (!beauti.quit()) {
                        return;
                    }
                    JFrame jFrame = (JFrame)windowEvent.getSource();
                    jFrame.dispose();
                    if (--BEAUtiIntances == 0) {
                        System.exit(0);
                    }
                }
            });
            return beauti;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        Beauti.main2(stringArray);
    }

    private static /* synthetic */ void lambda$setUpViewMenu$18(ViewPanelCheckBoxMenuItem viewPanelCheckBoxMenuItem, ActionEvent actionEvent) {
        viewPanelCheckBoxMenuItem.doAction();
    }

    class TemplateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        String m_sFileName;
        String templateInfo;

        public TemplateAction(File file) {
            super("xx");
            this.m_sFileName = file.getAbsolutePath();
            String string = System.getProperty("file.separator");
            if (string.equals("\\")) {
                string = "\\";
            }
            int n = this.m_sFileName.lastIndexOf(string) + 1;
            String string2 = this.m_sFileName.substring(n, this.m_sFileName.length() - 4);
            this.putValue("Name", string2);
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                Document document = documentBuilderFactory.newDocumentBuilder().parse(file);
                document.normalize();
                Element element = document.getDocumentElement();
                this.templateInfo = element.getAttribute("templateinfo");
                if (this.templateInfo == null || this.templateInfo.length() == 0) {
                    this.templateInfo = "switch to " + string2 + " template";
                }
                this.putValue("ShortDescription", this.templateInfo);
                this.putValue("LongDescription", this.templateInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (Beauti.this.doc.validateModel() == BeautiDoc.DOC_STATUS.NO_DOCUMENT) {
                    Beauti.this.doc.loadNewTemplate(this.m_sFileName);
                } else if (JOptionPane.showConfirmDialog(Beauti.this.frame, "Changing templates means the information input so far will be lost. Are you sure you want to change templates?", "Are you sure?", 1) == 0) {
                    Beauti.this.doc.loadNewTemplate(this.m_sFileName);
                }
                Beauti.this.createFileMenu();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(null, "Something went wrong loading the template: " + exception.getMessage());
            }
        }
    }

    class ActionViewModel
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionViewModel() {
            super("View model", "View model graph", "model", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFrame jFrame = new JFrame("Model Builder");
            ModelBuilder modelBuilder = new ModelBuilder();
            modelBuilder.init();
            jFrame.add((Component)modelBuilder, "Center");
            jFrame.add((Component)modelBuilder.m_jTbTools2, "North");
            modelBuilder.setEditable(false);
            modelBuilder.m_doc.init(Beauti.this.doc.mcmc.get());
            modelBuilder.setDrawingFlag();
            jFrame.setSize(600, 800);
            jFrame.setVisible(true);
        }
    }

    class ActionCitation
    extends MyAction
    implements ClipboardOwner {
        private static final long serialVersionUID = -1L;

        public ActionCitation() {
            super("Citation", "Show appropriate citations and copy to clipboard", "citation", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = Beauti.this.doc.mcmc.get().getCitations();
            try {
                StringSelection stringSelection = new StringSelection(string);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            JOptionPane.showMessageDialog(null, string + "\nCitations copied to clipboard", "Citation(s) applicable to this model:", 1);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    class ActionMsgs
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionMsgs() {
            super("Messages", "Show information, warning and error messages", "msgs", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BeautiDoc.baos == null) {
                JOptionPane.showMessageDialog(Beauti.this.frame, "<html>Error and warning messages are printed to Stdout and Stderr<br>To show them here, start BEAUti with the -capture argument.</html>");
            } else {
                String string = BeautiDoc.baos.toString();
                JTextArea jTextArea = new JTextArea(string);
                jTextArea.setRows(40);
                jTextArea.setColumns(50);
                jTextArea.setEditable(true);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                JOptionPane.showMessageDialog(Beauti.this.frame, jScrollPane);
            }
        }
    }

    class ActionHelp
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionHelp() {
            super("Help", "Help on current panel", "help", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Beauti.this.setCursor(new Cursor(3));
            HelpBrowser helpBrowser = new HelpBrowser(Beauti.this.currentTab.config.getType());
            int n = UIManager.getFont("Label.font").getSize();
            helpBrowser.setSize(800 * n / 13, 800 * n / 13);
            helpBrowser.setVisible(true);
            helpBrowser.setDefaultCloseOperation(2);
            Beauti.this.setCursor(new Cursor(0));
        }
    }

    class ActionAbout
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionAbout() {
            super("About", "Help about", "about", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BEASTVersion2 bEASTVersion2 = new BEASTVersion2();
            JOptionPane.showMessageDialog(null, bEASTVersion2.getCredits(), "About Beauti " + bEASTVersion2.getVersionString(), -1, beast.app.util.Utils.getIcon(Beauti.BEAUTI_ICON));
        }
    }

    class ActionViewAllPanels
    extends MyAction {
        private static final long serialVersionUID = -1L;

        public ActionViewAllPanels() {
            super("View all", "View all panels", "viewall", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (int i = 0; i < Beauti.this.isPaneIsVisible.length; ++i) {
                if (Beauti.this.isPaneIsVisible[i]) continue;
                Beauti.this.toggleVisible(i);
                Beauti.this.m_viewPanelCheckBoxMenuItems[i].setState(true);
            }
        }
    }

    class ViewPanelCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = 1L;
        int m_iPanel;

        ViewPanelCheckBoxMenuItem(int n) {
            super("Show " + Beauti.this.doc.beautiConfig.panels.get((int)n).nameInput.get() + " panel", Beauti.this.doc.beautiConfig.panels.get((int)n).isVisibleInput.get());
            this.m_iPanel = n;
            if (Beauti.this.m_viewPanelCheckBoxMenuItems == null) {
                Beauti.this.m_viewPanelCheckBoxMenuItems = new ViewPanelCheckBoxMenuItem[Beauti.this.doc.beautiConfig.panels.size()];
            }
            Beauti.this.m_viewPanelCheckBoxMenuItems[n] = this;
        }

        void doAction() {
            Beauti.this.toggleVisible(this.m_iPanel);
        }
    }

    class ActionQuit
    extends ActionSave {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionQuit() {
            super("Exit", "Exit Program", "exit", 115);
            this.putValue("MnemonicKey", new Integer(120));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!Beauti.this.quit()) {
                return;
            }
            System.exit(0);
        }
    }

    class ActionClose
    extends ActionSave {
        private static final long serialVersionUID = -2038911085935515L;

        public ActionClose() {
            super("Close", "Close Window", "close", 87);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!Beauti.this.quit()) {
                return;
            }
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            JPopupMenu jPopupMenu = (JPopupMenu)jMenuItem.getParent();
            Component component = jPopupMenu.getInvoker();
            JComponent jComponent = (JComponent)component;
            Container container = jComponent.getTopLevelAncestor();
            if (container != null) {
                ((JFrame)container).dispose();
            }
        }
    }

    class ActionAppLauncher
    extends MyAction {
        private static final long serialVersionUID = 1L;

        public ActionAppLauncher() {
            super("Launch Apps", "Launch BEAST Apps supplied by packages", "launch", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AppStore.main(new String[0]);
        }
    }

    class ActionAddOn
    extends MyAction {
        private static final long serialVersionUID = 1L;

        public ActionAddOn() {
            super("Manage Packages", "Manage Packages", "package", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JPackageDialog jPackageDialog = new JPackageDialog();
            JDialog jDialog = jPackageDialog.asDialog(Beauti.this.frame);
            jDialog.setVisible(true);
            Beauti.this.templateMenu.removeAll();
            List list = Beauti.this.getTemplateActions();
            for (AbstractAction abstractAction : list) {
                Beauti.this.templateMenu.add(abstractAction);
            }
            Beauti.this.templateMenu.addSeparator();
            Beauti.this.templateMenu.add(Beauti.this.a_template);
            Beauti.this.setCursor(new Cursor(0));
        }
    }

    class ActionTemplate
    extends MyAction {
        private static final long serialVersionUID = 1L;

        public ActionTemplate() {
            super("Other Template", "Load Beast Analysis Template From File", "template", -1);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Beauti.this.setCursor(new Cursor(3));
            File file = beast.app.util.Utils.getLoadFile("Load Template XML File");
            if (file != null) {
                String string = file.getAbsolutePath();
                try {
                    Beauti.this.doc.loadNewTemplate(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Something went wrong loading the template: " + exception.getMessage());
                }
            }
            Beauti.this.createFileMenu();
            Beauti.this.setCursor(new Cursor(0));
        }
    }

    class ActionLoad
    extends MyAction {
        private static final long serialVersionUID = 1L;

        public ActionLoad() {
            super("Load", "Load Beast File", "open", 79);
        }

        public ActionLoad(String string, String string2, String string3, int n) {
            super(string, string2, string3, n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = beast.app.util.Utils.getLoadFile("Load Beast XML File", new File(g_sDir), "Beast XML files", "xml");
            if (file != null) {
                Beauti.this.setCursor(new Cursor(3));
                Beauti.this.doc.newAnalysis();
                Beauti.this.doc.setFileName(file.getAbsolutePath());
                String string = System.getProperty("file.separator");
                if (string.equals("\\")) {
                    string = "\\\\";
                }
                if (Beauti.this.doc.getFileName().lastIndexOf(string) > 0) {
                    g_sDir = Beauti.this.doc.getFileName().substring(0, Beauti.this.doc.getFileName().lastIndexOf(string));
                }
                try {
                    Beauti.this.doc.loadXML(new File(Beauti.this.doc.getFileName()));
                    Beauti.this.a_save.setEnabled(true);
                    Beauti.this.a_saveas.setEnabled(true);
                    Beauti.this.setTitle();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Something went wrong loading the file: " + exception.getMessage());
                }
            }
            Beauti.this.setCursor(new Cursor(0));
        }
    }

    class ActionNew
    extends MyAction {
        private static final long serialVersionUID = 1L;

        public ActionNew() {
            super("New", "Start new analysis", "new", 78);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Beauti.main2(new String[0]);
        }
    }

    class ActionSaveAs
    extends ActionSave {
        private static final long serialVersionUID = -20389110859354L;

        public ActionSaveAs() {
            super("Save As", "Save Model As", "saveas", -1);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Beauti.this.saveAs();
        }
    }

    class ActionSave
    extends MyAction {
        private static final long serialVersionUID = 1L;

        public ActionSave() {
            super("Save", "Save Model", "save", 83);
            this.setEnabled(false);
        }

        public ActionSave(String string, String string2, String string3, int n) {
            super(string, string2, string3, n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BeautiDoc.DOC_STATUS dOC_STATUS = Beauti.this.doc.validateModel();
            if (dOC_STATUS != BeautiDoc.DOC_STATUS.DIRTY) {
                if (dOC_STATUS == BeautiDoc.DOC_STATUS.NO_DOCUMENT) {
                    JOptionPane.showMessageDialog(null, "There is no data to save to file");
                }
                return;
            }
            if (!Beauti.this.doc.getFileName().equals("")) {
                Beauti.this.saveFile(Beauti.this.doc.getFileName());
            } else if (Beauti.this.saveAs()) {
                // empty if block
            }
        }
    }
}

