/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONUtil;
import org.noggit.JSONWriter;

public class ZkNodeProps
implements JSONWriter.Writable {
    protected final Map<String, Object> propMap;

    public ZkNodeProps(Map<String, Object> propMap) {
        this.propMap = propMap;
    }

    public ZkNodeProps plus(String key, Object val) {
        return this.plus(Collections.singletonMap(key, val));
    }

    public ZkNodeProps plus(Map<String, Object> newVals) {
        LinkedHashMap<String, Object> copy = new LinkedHashMap<String, Object>(this.propMap);
        if (newVals == null || newVals.isEmpty()) {
            return new ZkNodeProps(copy);
        }
        copy.putAll(newVals);
        return new ZkNodeProps(copy);
    }

    public ZkNodeProps(String ... keyVals) {
        this(Utils.makeMap(keyVals));
    }

    public static ZkNodeProps fromKeyVals(Object ... keyVals) {
        return new ZkNodeProps(Utils.makeMap(keyVals));
    }

    public Set<String> keySet() {
        return this.propMap.keySet();
    }

    public Map<String, Object> getProperties() {
        return this.propMap;
    }

    public Map<String, Object> shallowCopy() {
        return new LinkedHashMap<String, Object>(this.propMap);
    }

    public static ZkNodeProps load(byte[] bytes) {
        Map props = (Map)Utils.fromJSON(bytes);
        return new ZkNodeProps(props);
    }

    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this.propMap);
    }

    public String getStr(String key) {
        Object o = this.propMap.get(key);
        return o == null ? null : o.toString();
    }

    public Integer getInt(String key, Integer def) {
        Object o = this.propMap.get(key);
        return o == null ? def : Integer.valueOf(o.toString());
    }

    public String getStr(String key, String def) {
        Object o = this.propMap.get(key);
        return o == null ? def : o.toString();
    }

    public Object get(String key) {
        return this.propMap.get(key);
    }

    public String toString() {
        return JSONUtil.toJSON((Object)this);
    }

    public boolean containsKey(String key) {
        return this.propMap.containsKey(key);
    }

    public boolean getBool(String key, boolean b) {
        Object o = this.propMap.get(key);
        if (o == null) {
            return b;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public boolean equals(Object that) {
        return that instanceof ZkNodeProps && ((ZkNodeProps)that).propMap.equals(this.propMap);
    }
}

