/*
 * Decompiled with CFR 0.152.
 */
package traer.physics;

import java.util.ArrayList;
import java.util.Iterator;
import traer.physics.Attraction;
import traer.physics.Force;
import traer.physics.Particle;
import traer.physics.RungeKuttaIntegrator;
import traer.physics.Spring;
import traer.physics.Vector3D;

public class ParticleSystem {
    ArrayList particles;
    ArrayList springs;
    ArrayList attractions;
    RungeKuttaIntegrator integrator = new RungeKuttaIntegrator(this);
    Vector3D gravity;
    float drag;

    public final void setGravity(float x, float y, float z) {
        this.gravity.set(x, y, z);
    }

    public final void setGravity(float g) {
        this.gravity.set(0.0f, g, 0.0f);
    }

    public final void setDrag(float d) {
        this.drag = d;
    }

    public final void advanceTime(float time) {
        this.cleanUp();
        this.integrator.step(time);
    }

    public final void tick() {
        this.cleanUp();
        this.integrator.step(1.0f);
    }

    public final void tick(float t) {
        this.cleanUp();
        this.integrator.step(t);
    }

    public final Particle makeParticle(float mass, float x, float y, float z) {
        Particle p = new Particle(mass, new Vector3D(x, y, z));
        this.particles.add(p);
        this.integrator.allocateParticles();
        return p;
    }

    public final Particle makeParticle() {
        return this.makeParticle(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public final Spring makeSpring(Particle a, Particle b, float ks, float d, float r) {
        Spring s = new Spring(a, b, ks, d, r);
        this.springs.add(s);
        return s;
    }

    public final Attraction makeAttraction(Particle a, Particle b, float k, float minDistance) {
        Attraction m = new Attraction(a, b, k, minDistance);
        this.attractions.add(m);
        return m;
    }

    public final void clear() {
        this.particles.clear();
        this.springs.clear();
        this.attractions.clear();
    }

    public ParticleSystem(float g, float somedrag) {
        this.particles = new ArrayList();
        this.springs = new ArrayList();
        this.attractions = new ArrayList();
        this.gravity = new Vector3D(0.0f, g, 0.0f);
        this.drag = somedrag;
    }

    public ParticleSystem(float gx, float gy, float gz, float somedrag) {
        this.particles = new ArrayList();
        this.springs = new ArrayList();
        this.attractions = new ArrayList();
        this.gravity = new Vector3D(gx, gy, gz);
        this.drag = somedrag;
    }

    protected final void applyForces() {
        Force f;
        int i = 0;
        while (i < this.particles.size()) {
            Particle p = (Particle)this.particles.get(i);
            p.force.add(this.gravity);
            p.force.add(p.velocity.x * -this.drag, p.velocity.y * -this.drag, p.velocity.z * -this.drag);
            ++i;
        }
        i = 0;
        while (i < this.springs.size()) {
            f = (Spring)this.springs.get(i);
            ((Spring)f).apply();
            ++i;
        }
        i = 0;
        while (i < this.attractions.size()) {
            f = (Attraction)this.attractions.get(i);
            ((Attraction)f).apply();
            ++i;
        }
    }

    protected final void clearForces() {
        Iterator i = this.particles.iterator();
        while (i.hasNext()) {
            Particle p = (Particle)i.next();
            p.force.clear();
        }
    }

    private final void cleanUp() {
        Force f;
        int i = this.particles.size() - 1;
        while (i >= 0) {
            Particle p = (Particle)this.particles.get(i);
            if (p.isDead()) {
                this.particles.remove(i);
            }
            --i;
        }
        i = this.springs.size() - 1;
        while (i >= 0) {
            f = (Spring)this.springs.get(i);
            if (((Spring)f).hasDead()) {
                this.springs.remove(i);
            }
            --i;
        }
        i = this.attractions.size() - 1;
        while (i >= 0) {
            f = (Attraction)this.attractions.get(i);
            if (((Attraction)f).hasDead()) {
                this.attractions.remove(i);
            }
            --i;
        }
    }

    public final int numberOfParticles() {
        return this.particles.size();
    }

    public final int numberOfSprings() {
        return this.springs.size();
    }

    public final int numberOfAttractions() {
        return this.attractions.size();
    }

    public final Particle getParticle(int i) {
        return (Particle)this.particles.get(i);
    }

    public final Spring getSpring(int i) {
        return (Spring)this.springs.get(i);
    }

    public final Attraction getAttraction(int i) {
        return (Attraction)this.attractions.get(i);
    }
}

