/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import Common.BoolVector;
import Common.IntVector;
import SevenZip.Archive.SevenZip.Header;
import SevenZip.Archive.SevenZip.InByte2;
import SevenZip.Common.StreamUtils;
import SevenZip.IInStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;

public class InStream {
    public static final int kNumMax = Integer.MAX_VALUE;
    final IInStream stream;
    private final Vector _inByteVector = new Vector();
    private InByte2 _inByteBack = null;
    final long archiveBeginStreamPosition;
    long position;
    public static final long SECS_BETWEEN_EPOCHS = 11644473600L;
    public static final long SECS_TO_100NS = 10000000L;

    public InStream(IInStream stream, long searchHeaderSizeLimit) throws IOException {
        this.stream = stream;
        this.position = stream.Seek(0L, 1);
        this.archiveBeginStreamPosition = this.FindAndReadSignature(searchHeaderSizeLimit);
    }

    private long FindAndReadSignature(long searchHeaderSizeLimit) throws IOException {
        this.stream.Seek(this.position, 0);
        byte[] signature = new byte[6];
        int processedSize = this.ReadDirect(this.stream, signature, 0, 6);
        if (processedSize != 6) {
            throw new IOException("detected illegal signature length: " + processedSize + " at byte " + this.position);
        }
        if (InStream.TestSignatureCandidate(signature, 0)) {
            return this.position;
        }
        int kBufferSize = 65536;
        byte[] buffer = new byte[65536];
        int numPrevBytes = 5;
        System.arraycopy(signature, 1, buffer, 0, numPrevBytes);
        long curTestPos = this.position + 1L;
        while (searchHeaderSizeLimit == -1L || curTestPos - this.position <= searchHeaderSizeLimit) {
            int numReadBytes = 65536 - numPrevBytes;
            processedSize = this.ReadDirect(this.stream, buffer, numPrevBytes, numReadBytes);
            if (processedSize == -1) {
                throw new IOException("unexpected EOF during search for signature");
            }
            int numBytesInBuffer = numPrevBytes + processedSize;
            if (numBytesInBuffer < 6) {
                throw new IOException("detected illegal signature length: " + numBytesInBuffer + " at byte " + this.position);
            }
            int numTests = numBytesInBuffer - 6 + 1;
            int pos = 0;
            while (pos < numTests) {
                if (InStream.TestSignatureCandidate(buffer, pos)) {
                    this.position = curTestPos + 6L;
                    this.stream.Seek(this.position, 0);
                    return curTestPos;
                }
                ++pos;
                ++curTestPos;
            }
            numPrevBytes = numBytesInBuffer - numTests;
            System.arraycopy(buffer, numTests, buffer, 0, numPrevBytes);
        }
        throw new IOException("signature not found within the given " + searchHeaderSizeLimit + " bytes");
    }

    public void AddByteStream(byte[] buffer, int size) {
        this._inByteBack = new InByte2(buffer, size);
        this._inByteVector.add(this._inByteBack);
    }

    public void DeleteByteStream() {
        this._inByteVector.removeElementAt(this._inByteVector.size() - 1);
        if (!this._inByteVector.isEmpty()) {
            this._inByteBack = (InByte2)this._inByteVector.lastElement();
        }
    }

    public static boolean TestSignatureCandidate(byte[] testBytes, int off) {
        if (off == 0) {
            return Arrays.equals(testBytes, Header.kSignature);
        }
        for (int i = 0; i < 6; ++i) {
            if (testBytes[i + off] == Header.kSignature[i]) continue;
            return false;
        }
        return true;
    }

    public int ReadDirect(IInStream stream, byte[] data, int off, int size) throws IOException {
        int realProcessedSize = StreamUtils.ReadStream(stream, data, off, size);
        if (realProcessedSize != -1) {
            this.position += (long)realProcessedSize;
        }
        return realProcessedSize;
    }

    public int ReadDirect(byte[] data, int size) throws IOException {
        return this.ReadDirect(this.stream, data, 0, size);
    }

    public boolean SafeReadDirect(byte[] data, int size) throws IOException {
        return this.ReadDirect(data, size) == size;
    }

    public int SafeReadDirectUInt32() throws IOException {
        int val = 0;
        byte[] b = new byte[4];
        int realProcessedSize = this.ReadDirect(b, 4);
        if (realProcessedSize != 4) {
            throw new IOException("Unexpected End Of Archive");
        }
        for (int i = 0; i < 4; ++i) {
            val |= (b[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    public int ReadUInt32() throws IOException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int b = this.ReadByte();
            value |= b << 8 * i;
        }
        return value;
    }

    public long ReadUInt64() throws IOException {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            int b = this.ReadByte();
            value |= (long)b << 8 * i;
        }
        return value;
    }

    public boolean ReadBytes(byte[] data, int size) throws IOException {
        return this._inByteBack.ReadBytes(data, size);
    }

    public boolean ReadBytes(ByteArrayOutputStream baos, int size) throws IOException {
        return this._inByteBack.readBytes(baos, size) == size;
    }

    public int ReadByte() throws IOException {
        return this._inByteBack.ReadByte();
    }

    public long SafeReadDirectUInt64() throws IOException {
        long val = 0L;
        byte[] b = new byte[8];
        int realProcessedSize = this.ReadDirect(b, 8);
        if (realProcessedSize != 8) {
            throw new IOException("Unexpected End Of Archive");
        }
        for (int i = 0; i < 8; ++i) {
            val |= (long)(b[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    public char ReadWideCharLE() throws IOException {
        int b1 = this._inByteBack.ReadByte();
        int b2 = this._inByteBack.ReadByte();
        char c = (char)(((char)b2 << 8) + b1);
        return c;
    }

    public long ReadNumber() throws IOException {
        int firstByte = this.ReadByte();
        int mask = 128;
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            if ((firstByte & mask) == 0) {
                long highPart = firstByte & mask - 1;
                return value += highPart << i * 8;
            }
            int b = this.ReadByte();
            if (b < 0) {
                throw new IOException("ReadNumber - Can't read stream");
            }
            value |= (long)b << 8 * i;
            mask >>= 1;
        }
        return value;
    }

    public int ReadNum() throws IOException {
        long value64 = this.ReadNumber();
        if (value64 > Integer.MAX_VALUE) {
            throw new IOException("ReadNum - value > CNum.kNumMax");
        }
        return (int)value64;
    }

    public long ReadID() throws IOException {
        return this.ReadNumber();
    }

    public void SkeepData(long size) throws IOException {
        for (long i = 0L; i < size; ++i) {
            this.ReadByte();
        }
    }

    public void SkeepData() throws IOException {
        long size = this.ReadNumber();
        this.SkeepData(size);
    }

    public void skipToAttribute(long attribute) throws IOException {
        long type;
        while ((type = this.ReadID()) != attribute) {
            if (type == 0L) {
                throw new IOException("unexpected end of archive");
            }
            this.SkeepData();
        }
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    public BoolVector ReadBoolVector(int numItems) throws IOException {
        BoolVector v = new BoolVector(numItems);
        int b = 0;
        int mask = 0;
        for (int i = 0; i < numItems; ++i) {
            if (mask == 0) {
                b = this.ReadByte();
                mask = 128;
            }
            v.add((b & mask) != 0);
            mask >>= 1;
        }
        return v;
    }

    public BoolVector ReadBoolVector2(int numItems) throws IOException {
        int allAreDefined = this.ReadByte();
        if (allAreDefined == 0) {
            return this.ReadBoolVector(numItems);
        }
        BoolVector v = new BoolVector(numItems);
        for (int i = 0; i < numItems; ++i) {
            v.add(true);
        }
        return v;
    }

    public IntVector ReadHashDigests(int numItems, BoolVector digestsDefined) throws IOException {
        digestsDefined.setBoolVector(this.ReadBoolVector2(numItems));
        IntVector digests = new IntVector(numItems);
        digests.clear();
        digests.Reserve(numItems);
        for (int i = 0; i < numItems; ++i) {
            int crc = 0;
            if (digestsDefined.get(i)) {
                crc = this.ReadUInt32();
            }
            digests.add(crc);
        }
        return digests;
    }

    public static long FileTimeToLong(int dwHighDateTime, int dwLowDateTime) {
        long tm = dwHighDateTime;
        tm <<= 32;
        return ((tm |= (long)dwLowDateTime & 0xFFFFFFFFL) - 116444736000000000L) / 10000L;
    }
}

