/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.transform.DocTransformer;

public class DocTransformers
extends DocTransformer {
    final List<DocTransformer> children = new ArrayList<DocTransformer>();

    @Override
    public String getName() {
        StringBuilder str = new StringBuilder();
        str.append("Transformers[");
        Iterator<DocTransformer> iter = this.children.iterator();
        while (iter.hasNext()) {
            str.append(iter.next().getName());
            if (!iter.hasNext()) continue;
            str.append(",");
        }
        str.append("]");
        return str.toString();
    }

    public void addTransformer(DocTransformer a) {
        this.children.add(a);
    }

    public int size() {
        return this.children.size();
    }

    public DocTransformer getTransformer(int idx) {
        return this.children.get(idx);
    }

    @Override
    public void setContext(ResultContext context) {
        for (DocTransformer a : this.children) {
            a.setContext(context);
        }
    }

    @Override
    public void transform(SolrDocument doc, int docid, float score) throws IOException {
        for (DocTransformer a : this.children) {
            a.transform(doc, docid, score);
        }
    }

    @Override
    public boolean needsSolrIndexSearcher() {
        for (DocTransformer kid : this.children) {
            if (!kid.needsSolrIndexSearcher()) continue;
            return true;
        }
        return false;
    }
}

