/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import org.apache.solr.common.EnumFieldValue;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.handler.component.StatsField;

class EnumStatsValues
extends AbstractStatsValues<EnumFieldValue> {
    public EnumStatsValues(StatsField statsField) {
        super(statsField);
    }

    @Override
    public long hash(EnumFieldValue v) {
        return this.hasher.hashInt(v.toInt().intValue()).asLong();
    }

    @Override
    public void accumulate(int docID) {
        if (this.values.exists(docID)) {
            Integer intValue = (Integer)this.values.objectVal(docID);
            String stringValue = this.values.strVal(docID);
            EnumFieldValue enumFieldValue = new EnumFieldValue(intValue, stringValue);
            this.accumulate(enumFieldValue, 1);
        } else {
            this.missing();
        }
    }

    @Override
    protected void updateMinMax(EnumFieldValue min, EnumFieldValue max) {
        if (this.computeMin && null != min && (null == this.min || min.compareTo((EnumFieldValue)this.min) < 0)) {
            this.min = min;
        }
        if (this.computeMax && null != max && (null == this.max || max.compareTo((EnumFieldValue)this.max) > 0)) {
            this.max = max;
        }
    }

    @Override
    protected void updateTypeSpecificStats(NamedList stv) {
    }

    @Override
    protected void updateTypeSpecificStats(EnumFieldValue value, int count) {
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
    }
}

