/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.commons.compiler.CompilerFactoryFactory;
import org.codehaus.commons.compiler.ICompilerFactory;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.ExpressionEvaluator;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Parser;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.Traverser;
import org.codehaus.janino.util.enumerator.Enumerator;
import org.codehaus.janino.util.iterator.DirectoryIterator;
import org.codehaus.janino.util.resource.PathResourceFinder;

public class JGrep {
    private static final boolean DEBUG = false;
    private List parsedCompilationUnits = new ArrayList();
    private static final String[] USAGE = new String[]{"Usage:", "", "  java org.codehaus.janino.tools.JGrep [ <option> ... ] <root-dir> ... <pattern> ...", "  java org.codehaus.janino.tools.JGrep -help", "", "Reads a set of compilation units from the files in the <root-dir>s and their", "subdirectories and searches them for specific Java[TM] constructs, e.g.", "invocations of a particular method.", "", "Supported <option>s are ('cp' is a 'combined pattern, like '*.java-*Generated*'):", "  -dirs <dir-cp>             Ignore subdirectories which don't match", "  -files <file-cp>           Include only matching files (default is '*.java')", "  -classpath <classpath>", "  -extdirs <classpath>", "  -bootclasspath <classpath>", "  -encoding <encoding>", "  -verbose", "", "Supported <pattern>s are:", "  -method-invocation <method-pattern> [ predicate:<predicate-expression> | action:<action-script> ] ...", "<method-pattern> is ('<ip>' is an 'identifier pattern' like '*foo*'):", "  -method-invocation <method-ip>", "  -method-invocation <simple-class-ip>.<method-ip>", "  -method-invocation <fully-qualified-class-ip>.<method-ip>", "  -method-invocation <method-ip>([<parameter-ip>[,<parameter-ip>]...])", "", "<predicate-expression> is a Java[TM] expression with the following signature:", "  boolean evaluate(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method)", "", "<action-script> is either", "  print-location-and-match", "  print-location", ", or a Java[TM] script (method body) with the following signature:", "  void execute(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method)"};
    private final IClassLoader iClassLoader;
    private final String optionalCharacterEncoding;
    private final Benchmark benchmark;
    static /* synthetic */ Class class$org$codehaus$janino$tools$JGrep;
    static /* synthetic */ Class class$org$codehaus$janino$tools$JGrep$MethodInvocationPredicate;
    static /* synthetic */ Class class$org$codehaus$janino$tools$JGrep$MethodInvocationAction;

    public static void main(String[] args) {
        String arg;
        int idx;
        StringPattern[] directoryNamePatterns = StringPattern.PATTERNS_ALL;
        StringPattern[] fileNamePatterns = new StringPattern[]{new StringPattern("*.java")};
        File[] classPath = new File[]{new File(".")};
        File[] optionalExtDirs = null;
        File[] optionalBootClassPath = null;
        String optionalCharacterEncoding = null;
        boolean verbose = false;
        for (idx = 0; idx < args.length && (arg = args[idx]).charAt(0) == '-'; ++idx) {
            if (arg.equals("-dirs")) {
                directoryNamePatterns = StringPattern.parseCombinedPattern(args[++idx]);
                continue;
            }
            if (arg.equals("-files")) {
                fileNamePatterns = StringPattern.parseCombinedPattern(args[++idx]);
                continue;
            }
            if (arg.equals("-classpath")) {
                classPath = PathResourceFinder.parsePath(args[++idx]);
                continue;
            }
            if (arg.equals("-extdirs")) {
                optionalExtDirs = PathResourceFinder.parsePath(args[++idx]);
                continue;
            }
            if (arg.equals("-bootclasspath")) {
                optionalBootClassPath = PathResourceFinder.parsePath(args[++idx]);
                continue;
            }
            if (arg.equals("-encoding")) {
                optionalCharacterEncoding = args[++idx];
                continue;
            }
            if (arg.equals("-verbose")) {
                verbose = true;
                continue;
            }
            if (arg.equals("-help")) {
                for (int j = 0; j < USAGE.length; ++j) {
                    System.out.println(USAGE[j]);
                }
                System.exit(1);
                continue;
            }
            System.err.println("Unexpected command-line argument \"" + arg + "\", try \"-help\".");
            System.exit(1);
            return;
        }
        int first = idx;
        while (idx < args.length && args[idx].charAt(0) != '-') {
            ++idx;
        }
        if (idx == first) {
            System.err.println("No <directory-path>es given, try \"-help\".");
            System.exit(1);
            return;
        }
        File[] rootDirectories = new File[idx - first];
        for (int i = first; i < idx; ++i) {
            rootDirectories[i - first] = new File(args[i]);
        }
        JGrep jGrep = new JGrep(classPath, optionalExtDirs, optionalBootClassPath, optionalCharacterEncoding, verbose);
        ArrayList<MethodInvocationTarget> mits = new ArrayList<MethodInvocationTarget>();
        while (idx < args.length) {
            MethodInvocationTarget mit;
            String arg2 = args[idx];
            if (arg2.equals("-method-invocation")) {
                try {
                    mit = JGrep.parseMethodInvocationPattern(args[++idx]);
                }
                catch (Exception ex) {
                    System.err.println("Parsing method invocation pattern \"" + args[idx] + "\": " + ex.getMessage());
                    System.exit(1);
                    return;
                }
                while (idx < args.length - 1) {
                    arg2 = args[idx + 1];
                    if (arg2.startsWith("predicate:")) {
                        String predicateExpression = arg2.substring(10);
                        try {
                            ExpressionEvaluator ee = new ExpressionEvaluator();
                            ee.setClassName((class$org$codehaus$janino$tools$JGrep == null ? JGrep.class$("org.codehaus.janino.tools.JGrep") : class$org$codehaus$janino$tools$JGrep).getName() + "PE");
                            mit.predicates.add((MethodInvocationPredicate)ee.createFastEvaluator(predicateExpression, class$org$codehaus$janino$tools$JGrep$MethodInvocationPredicate == null ? JGrep.class$("org.codehaus.janino.tools.JGrep$MethodInvocationPredicate") : class$org$codehaus$janino$tools$JGrep$MethodInvocationPredicate, new String[]{"uc", "invocation", "method"}));
                        }
                        catch (Exception ex) {
                            System.err.println("Compiling predicate expression \"" + predicateExpression + "\": " + ex.getMessage());
                            System.exit(1);
                            return;
                        }
                    }
                    if (!arg2.startsWith("action:")) break;
                    String action = arg2.substring(7);
                    try {
                        mit.actions.add(Action.getMethodInvocationAction(action));
                    }
                    catch (Exception ex) {
                        System.err.println("Compiling method invocation action \"" + action + "\": " + ex.getMessage());
                        System.exit(1);
                        return;
                    }
                    ++idx;
                }
            } else {
                System.err.println("Unexpected command-line argument \"" + arg2 + "\", try \"-help\".");
                System.exit(1);
                return;
            }
            mits.add(mit);
            ++idx;
        }
        try {
            jGrep.jGrep(rootDirectories, directoryNamePatterns, fileNamePatterns, mits);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            System.exit(1);
        }
    }

    private static MethodInvocationTarget parseMethodInvocationPattern(String mip) throws CompileException, IOException {
        String s;
        MethodInvocationTarget mit = new MethodInvocationTarget();
        Scanner scanner = new Scanner(null, new StringReader(mip));
        Parser parser = new Parser(scanner);
        while (true) {
            s = JGrep.readIdentifierPattern(parser);
            if (parser.peekOperator("(")) {
                mit.methodNamePattern = s;
                parser.eatToken();
                ArrayList<String> l = new ArrayList<String>();
                if (!parser.peekOperator(")")) {
                    while (true) {
                        l.add(JGrep.readIdentifierPattern(parser));
                        if (parser.peekOperator(")")) break;
                        parser.readOperator(",");
                    }
                }
                mit.optionalArgumentTypeNamePatterns = l.toArray(new String[l.size()]);
                return mit;
            }
            if (parser.peekOperator(".")) {
                mit.optionalClassNamePattern = mit.optionalClassNamePattern == null ? s : mit.optionalClassNamePattern + '.' + s;
                parser.eatToken();
                continue;
            }
            if (scanner.peek().isEOF()) break;
        }
        mit.methodNamePattern = s;
        return mit;
    }

    private static String readIdentifierPattern(Parser p) throws CompileException, IOException {
        StringBuffer sb = new StringBuffer();
        if (p.peekOperator("*")) {
            sb.append('*');
            p.eatToken();
        } else {
            sb.append(p.readIdentifier());
        }
        while (true) {
            if (p.peekOperator("*")) {
                sb.append('*');
                p.eatToken();
                continue;
            }
            if (!p.peekIdentifier()) break;
            sb.append(p.readIdentifier());
        }
        return sb.toString();
    }

    static boolean typeMatches(String pattern, String typeName) {
        return new StringPattern(pattern).matches(pattern.indexOf(46) == -1 ? typeName.substring(typeName.lastIndexOf(46) + 1) : typeName);
    }

    public JGrep(File[] classPath, File[] optionalExtDirs, File[] optionalBootClassPath, String optionalCharacterEncoding, boolean verbose) {
        this(IClassLoader.createJavacLikePathIClassLoader(optionalBootClassPath, optionalExtDirs, classPath), optionalCharacterEncoding, verbose);
        this.benchmark.report("*** JGrep - search Java(TM) source files for specific language constructs");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Class path", classPath);
        this.benchmark.report("Ext dirs", optionalExtDirs);
        this.benchmark.report("Boot class path", optionalBootClassPath);
        this.benchmark.report("Character encoding", optionalCharacterEncoding);
    }

    public JGrep(IClassLoader iClassLoader, String optionalCharacterEncoding, boolean verbose) {
        this.iClassLoader = new JGrepIClassLoader(iClassLoader);
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        this.benchmark = new Benchmark(verbose);
    }

    public void jGrep(File[] rootDirectories, final StringPattern[] directoryNamePatterns, final StringPattern[] fileNamePatterns, List methodInvocationTargets) throws CompileException, IOException {
        this.benchmark.report("Root dirs", rootDirectories);
        this.benchmark.report("Directory name patterns", directoryNamePatterns);
        this.benchmark.report("File name patterns", fileNamePatterns);
        this.jGrep(DirectoryIterator.traverseDirectories(rootDirectories, new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return StringPattern.matches(directoryNamePatterns, name);
            }
        }, new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return StringPattern.matches(fileNamePatterns, name);
            }
        }), methodInvocationTargets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jGrep(Iterator sourceFilesIterator, final List methodInvocationTargets) throws CompileException, IOException {
        UnitCompiler uc;
        this.benchmark.beginReporting();
        int sourceFileCount = 0;
        try {
            while (sourceFilesIterator.hasNext()) {
                File sourceFile = (File)sourceFilesIterator.next();
                uc = new UnitCompiler(this.parseCompilationUnit(sourceFile, this.optionalCharacterEncoding), this.iClassLoader);
                this.parsedCompilationUnits.add(uc);
                ++sourceFileCount;
            }
        }
        finally {
            this.benchmark.endReporting("Parsed " + sourceFileCount + " source file(s)");
        }
        this.benchmark.beginReporting();
        try {
            Iterator it = this.parsedCompilationUnits.iterator();
            while (it.hasNext()) {
                class UCE
                extends RuntimeException {
                    final CompileException ce;

                    UCE(CompileException ce) {
                        this.ce = ce;
                    }
                }
                uc = (UnitCompiler)it.next();
                this.benchmark.beginReporting("Grepping \"" + uc.compilationUnit.optionalFileName + "\"");
                try {
                    new Traverser(){

                        public void traverseMethodInvocation(Java.MethodInvocation mi) {
                            try {
                                this.match(mi, uc.findIMethod(mi));
                            }
                            catch (CompileException ex) {
                                throw new UCE(ex);
                            }
                            super.traverseMethodInvocation(mi);
                        }

                        public void traverseSuperclassMethodInvocation(Java.SuperclassMethodInvocation scmi) {
                            try {
                                this.match(scmi, uc.findIMethod(scmi));
                            }
                            catch (CompileException ex) {
                                throw new UCE(ex);
                            }
                            super.traverseSuperclassMethodInvocation(scmi);
                        }

                        public void traverseNewClassInstance(Java.NewClassInstance nci) {
                            super.traverseNewClassInstance(nci);
                        }

                        public void traverseNewAnonymousClassInstance(Java.NewAnonymousClassInstance naci) {
                            super.traverseNewAnonymousClassInstance(naci);
                        }

                        public void traverseConstructorInvocation(Java.ConstructorInvocation ci) {
                            super.traverseConstructorInvocation(ci);
                        }

                        private void match(Java.Invocation invocation, IClass.IMethod method) throws CompileException {
                            Iterator it2 = methodInvocationTargets.iterator();
                            while (it2.hasNext()) {
                                MethodInvocationTarget mit = (MethodInvocationTarget)it2.next();
                                mit.apply(uc, invocation, method);
                            }
                        }
                    }.traverseCompilationUnit(uc.compilationUnit);
                }
                catch (UCE uce) {
                    throw uce.ce;
                }
                finally {
                    this.benchmark.endReporting();
                }
            }
        }
        finally {
            this.benchmark.endReporting("Traversed " + sourceFileCount + " compilation units");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Java.CompilationUnit parseCompilationUnit(File sourceFile, String optionalCharacterEncoding) throws CompileException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(sourceFile));
        try {
            Parser parser = new Parser(new Scanner(sourceFile.getPath(), is, optionalCharacterEncoding));
            this.benchmark.beginReporting("Parsing \"" + sourceFile + "\"");
            try {
                Java.CompilationUnit compilationUnit = parser.parseCompilationUnit();
                this.benchmark.endReporting();
                return compilationUnit;
            }
            catch (Throwable throwable) {
                this.benchmark.endReporting();
                throw throwable;
            }
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException ex) {}
        }
    }

    public static File getClassFile(String className, File sourceFile, File optionalDestinationDirectory) {
        if (optionalDestinationDirectory != null) {
            return new File(optionalDestinationDirectory, ClassFile.getClassFileResourceName(className));
        }
        int idx = className.lastIndexOf(46);
        return new File(sourceFile.getParentFile(), ClassFile.getClassFileResourceName(className.substring(idx + 1)));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JGrepIClassLoader
    extends IClassLoader {
        public JGrepIClassLoader(IClassLoader optionalParentIClassLoader) {
            super(optionalParentIClassLoader);
            super.postConstruct();
        }

        protected IClass findIClass(String type) {
            String className = Descriptor.toClassName(type);
            if (className.startsWith("java.")) {
                return null;
            }
            for (int i = 0; i < JGrep.this.parsedCompilationUnits.size(); ++i) {
                UnitCompiler uc = (UnitCompiler)JGrep.this.parsedCompilationUnits.get(i);
                IClass res = uc.findClass(className);
                if (res == null) continue;
                this.defineIClass(res);
                return res;
            }
            return null;
        }
    }

    public static interface MethodInvocationAction {
        public void execute(UnitCompiler var1, Java.Invocation var2, IClass.IMethod var3) throws Exception;
    }

    public static interface MethodInvocationPredicate {
        public boolean evaluate(UnitCompiler var1, Java.Invocation var2, IClass.IMethod var3) throws Exception;
    }

    private static class MethodInvocationTarget {
        String optionalClassNamePattern = null;
        String methodNamePattern = null;
        String[] optionalArgumentTypeNamePatterns = null;
        List predicates = new ArrayList();
        List actions = new ArrayList();

        private MethodInvocationTarget() {
        }

        void apply(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method) throws CompileException {
            if (this.optionalClassNamePattern != null && !JGrep.typeMatches(this.optionalClassNamePattern, Descriptor.toClassName(method.getDeclaringIClass().getDescriptor()))) {
                return;
            }
            if (!new StringPattern(this.methodNamePattern).matches(method.getName())) {
                return;
            }
            IClass[] fpts = method.getParameterTypes();
            if (this.optionalArgumentTypeNamePatterns != null) {
                String[] atnps = this.optionalArgumentTypeNamePatterns;
                if (atnps.length != fpts.length) {
                    return;
                }
                for (int i = 0; i < atnps.length; ++i) {
                    if (new StringPattern(atnps[i]).matches(Descriptor.toClassName(fpts[i].getDescriptor()))) continue;
                }
            }
            Iterator it = this.predicates.iterator();
            while (it.hasNext()) {
                MethodInvocationPredicate mip = (MethodInvocationPredicate)it.next();
                try {
                    if (mip.evaluate(uc, invocation, method)) continue;
                    return;
                }
                catch (Exception ex) {
                    return;
                }
            }
            it = this.actions.iterator();
            while (it.hasNext()) {
                MethodInvocationAction mia = (MethodInvocationAction)it.next();
                try {
                    mia.execute(uc, invocation, method);
                }
                catch (Exception ex) {}
            }
        }
    }

    private static final class Action
    extends Enumerator {
        private Action(String name) {
            super(name);
        }

        static MethodInvocationAction getMethodInvocationAction(String action) throws CompileException {
            ICompilerFactory cf;
            if ("print-location-and-match".equals(action)) {
                return new MethodInvocationAction(){

                    public void execute(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method) {
                        System.out.println(invocation.getLocation() + ": " + method);
                    }
                };
            }
            if ("print-location".equals(action)) {
                return new MethodInvocationAction(){

                    public void execute(UnitCompiler uc, Java.Invocation invocation, IClass.IMethod method) {
                        System.out.println(invocation.getLocation());
                    }
                };
            }
            try {
                cf = CompilerFactoryFactory.getDefaultCompilerFactory();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
            return (MethodInvocationAction)cf.newScriptEvaluator().createFastEvaluator(action, class$org$codehaus$janino$tools$JGrep$MethodInvocationAction == null ? (class$org$codehaus$janino$tools$JGrep$MethodInvocationAction = JGrep.class$("org.codehaus.janino.tools.JGrep$MethodInvocationAction")) : class$org$codehaus$janino$tools$JGrep$MethodInvocationAction, new String[]{"uc", "invocation", "method"});
        }
    }
}

