/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim;

import java.awt.Shape;
import java.awt.geom.Point2D;
import org.apache.batik.anim.InterpolatingAnimation;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.anim.values.AnimatableAngleValue;
import org.apache.batik.anim.values.AnimatableMotionPointValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimatableElement;
import org.apache.batik.ext.awt.geom.Cubic;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.ext.awt.geom.ExtendedPathIterator;
import org.apache.batik.ext.awt.geom.PathLength;

public class MotionAnimation
extends InterpolatingAnimation {
    protected ExtendedGeneralPath path;
    protected PathLength pathLength;
    protected float[] keyPoints;
    protected boolean rotateAuto;
    protected boolean rotateAutoReverse;
    protected float rotateAngle;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MotionAnimation(TimedElement timedElement, AnimatableElement animatableElement, int n, float[] fArray, float[] fArray2, boolean bl, boolean bl2, AnimatableValue[] animatableValueArray, AnimatableValue animatableValue, AnimatableValue animatableValue2, AnimatableValue animatableValue3, ExtendedGeneralPath extendedGeneralPath, float[] fArray3, boolean bl3, boolean bl4, float f, short s) {
        super(timedElement, animatableElement, n, fArray, fArray2, bl, bl2);
        int n2;
        int n3;
        this.rotateAuto = bl3;
        this.rotateAutoReverse = bl4;
        this.rotateAngle = AnimatableAngleValue.rad(f, s);
        if (extendedGeneralPath == null) {
            AnimatableMotionPointValue animatableMotionPointValue;
            extendedGeneralPath = new ExtendedGeneralPath();
            if (animatableValueArray == null || animatableValueArray.length == 0) {
                if (animatableValue != null) {
                    AnimatableMotionPointValue animatableMotionPointValue2;
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue;
                    float f2 = animatableMotionPointValue.getX();
                    float f3 = animatableMotionPointValue.getY();
                    extendedGeneralPath.moveTo(f2, f3);
                    if (animatableValue2 != null) {
                        animatableMotionPointValue2 = (AnimatableMotionPointValue)animatableValue2;
                        extendedGeneralPath.lineTo(animatableMotionPointValue2.getX(), animatableMotionPointValue2.getY());
                    } else {
                        if (animatableValue3 == null) throw timedElement.createException("values.to.by.path.missing", new Object[]{null});
                        animatableMotionPointValue2 = (AnimatableMotionPointValue)animatableValue3;
                        extendedGeneralPath.lineTo(f2 + animatableMotionPointValue2.getX(), f3 + animatableMotionPointValue2.getY());
                    }
                } else if (animatableValue2 != null) {
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableElement.getUnderlyingValue();
                    AnimatableMotionPointValue animatableMotionPointValue3 = (AnimatableMotionPointValue)animatableValue2;
                    extendedGeneralPath.moveTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                    extendedGeneralPath.lineTo(animatableMotionPointValue3.getX(), animatableMotionPointValue3.getY());
                    this.cumulative = false;
                } else {
                    if (animatableValue3 == null) throw timedElement.createException("values.to.by.path.missing", new Object[]{null});
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableValue3;
                    extendedGeneralPath.moveTo(0.0f, 0.0f);
                    extendedGeneralPath.lineTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                    this.additive = true;
                }
            } else {
                animatableMotionPointValue = (AnimatableMotionPointValue)animatableValueArray[0];
                extendedGeneralPath.moveTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                for (int i = 1; i < animatableValueArray.length; ++i) {
                    animatableMotionPointValue = (AnimatableMotionPointValue)animatableValueArray[i];
                    extendedGeneralPath.lineTo(animatableMotionPointValue.getX(), animatableMotionPointValue.getY());
                }
            }
        }
        this.path = extendedGeneralPath;
        this.pathLength = new PathLength((Shape)extendedGeneralPath);
        int n4 = 0;
        ExtendedPathIterator extendedPathIterator = extendedGeneralPath.getExtendedPathIterator();
        while (!extendedPathIterator.isDone()) {
            int n5 = extendedPathIterator.currentSegment();
            if (n5 != 0) {
                ++n4;
            }
            extendedPathIterator.next();
        }
        int n6 = fArray3 == null ? n4 + 1 : fArray3.length;
        float f4 = this.pathLength.lengthOfPath();
        if (this.keyTimes != null && n != 2) {
            if (this.keyTimes.length != n6) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyTimes"});
            }
        } else if (n == 1 || n == 3) {
            this.keyTimes = new float[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                this.keyTimes[n3] = (float)n3 / (float)(n6 - 1);
            }
        } else if (n == 0) {
            this.keyTimes = new float[n6];
            for (n3 = 0; n3 < n6; ++n3) {
                this.keyTimes[n3] = (float)n3 / (float)n6;
            }
        } else {
            extendedPathIterator = extendedGeneralPath.getExtendedPathIterator();
            this.keyTimes = new float[n6];
            n3 = 0;
            for (n2 = 0; n2 < n6 - 1; ++n2) {
                while (extendedPathIterator.currentSegment() == 0) {
                    ++n3;
                    extendedPathIterator.next();
                }
                this.keyTimes[n2] = this.pathLength.getLengthAtSegment(n3) / f4;
                ++n3;
                extendedPathIterator.next();
            }
            this.keyTimes[n6 - 1] = 1.0f;
        }
        if (fArray3 != null) {
            if (fArray3.length != this.keyTimes.length) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyPoints"});
            }
        } else {
            extendedPathIterator = extendedGeneralPath.getExtendedPathIterator();
            fArray3 = new float[n6];
            n3 = 0;
            for (n2 = 0; n2 < n6 - 1; ++n2) {
                while (extendedPathIterator.currentSegment() == 0) {
                    ++n3;
                    extendedPathIterator.next();
                }
                fArray3[n2] = this.pathLength.getLengthAtSegment(n3) / f4;
                ++n3;
                extendedPathIterator.next();
            }
            fArray3[n6 - 1] = 1.0f;
        }
        this.keyPoints = fArray3;
    }

    protected void sampledAtUnitTime(float f, int n) {
        AnimatableMotionPointValue animatableMotionPointValue;
        AnimatableMotionPointValue animatableMotionPointValue2;
        float f2;
        float f3 = 0.0f;
        if (f != 1.0f) {
            float f4;
            int n2;
            for (n2 = 0; n2 < this.keyTimes.length - 1 && f >= this.keyTimes[n2 + 1]; ++n2) {
            }
            if (n2 == this.keyTimes.length - 1 && this.calcMode == 0) {
                n2 = this.keyTimes.length - 2;
                f3 = 1.0f;
            } else if (this.calcMode == 1 || this.calcMode == 2 || this.calcMode == 3) {
                f3 = f == 0.0f ? 0.0f : (f - this.keyTimes[n2]) / (this.keyTimes[n2 + 1] - this.keyTimes[n2]);
                if (this.calcMode == 3 && f != 0.0f) {
                    float f5;
                    Point2D.Double double_;
                    double d;
                    Cubic cubic = this.keySplineCubics[n2];
                    float f6 = 0.001f;
                    f4 = 0.0f;
                    float f7 = 1.0f;
                    while (!(Math.abs((d = (double_ = cubic.eval((double)(f5 = (f4 + f7) / 2.0f))).getX()) - (double)f3) < (double)f6)) {
                        if (d < (double)f3) {
                            f4 = f5;
                            continue;
                        }
                        f7 = f5;
                    }
                    f3 = (float)double_.getY();
                }
            }
            f2 = this.keyPoints[n2];
            if (f3 != 0.0f) {
                f2 += f3 * (this.keyPoints[n2 + 1] - this.keyPoints[n2]);
            }
            Point2D point2D = this.pathLength.pointAtLength(f2 *= this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                f4 = this.pathLength.angleAtLength(f2);
                if (this.rotateAutoReverse) {
                    f4 = (float)((double)f4 + Math.PI);
                }
            } else {
                f4 = this.rotateAngle;
            }
            animatableMotionPointValue2 = new AnimatableMotionPointValue(null, (float)point2D.getX(), (float)point2D.getY(), f4);
        } else {
            Point2D point2D = this.pathLength.pointAtLength(this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                f2 = this.pathLength.angleAtLength(this.pathLength.lengthOfPath());
                if (this.rotateAutoReverse) {
                    f2 = (float)((double)f2 + Math.PI);
                }
            } else {
                f2 = this.rotateAngle;
            }
            animatableMotionPointValue2 = new AnimatableMotionPointValue(null, (float)point2D.getX(), (float)point2D.getY(), f2);
        }
        if (this.cumulative) {
            Point2D point2D = this.pathLength.pointAtLength(this.pathLength.lengthOfPath());
            if (this.rotateAuto) {
                f2 = this.pathLength.angleAtLength(this.pathLength.lengthOfPath());
                if (this.rotateAutoReverse) {
                    f2 = (float)((double)f2 + Math.PI);
                }
            } else {
                f2 = this.rotateAngle;
            }
            animatableMotionPointValue = new AnimatableMotionPointValue(null, (float)point2D.getX(), (float)point2D.getY(), f2);
        } else {
            animatableMotionPointValue = null;
        }
        this.value = ((AnimatableValue)animatableMotionPointValue2).interpolate(this.value, null, f3, animatableMotionPointValue, n);
        if (this.value.hasChanged()) {
            this.markDirty();
        }
    }
}

