/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim;

import org.apache.batik.anim.AbstractAnimation;
import org.apache.batik.anim.timing.TimedElement;
import org.apache.batik.dom.anim.AnimatableElement;
import org.apache.batik.ext.awt.geom.Cubic;

public abstract class InterpolatingAnimation
extends AbstractAnimation {
    protected int calcMode;
    protected float[] keyTimes;
    protected float[] keySplines;
    protected Cubic[] keySplineCubics;
    protected boolean additive;
    protected boolean cumulative;

    public InterpolatingAnimation(TimedElement timedElement, AnimatableElement animatableElement, int n, float[] fArray, float[] fArray2, boolean bl, boolean bl2) {
        super(timedElement, animatableElement);
        int n2;
        this.calcMode = n;
        this.keyTimes = fArray;
        this.keySplines = fArray2;
        this.additive = bl;
        this.cumulative = bl2;
        if (n == 3) {
            if (fArray2 == null || fArray2.length % 4 != 0) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keySplines"});
            }
            this.keySplineCubics = new Cubic[fArray2.length / 4];
            for (n2 = 0; n2 < fArray2.length / 4; ++n2) {
                this.keySplineCubics[n2] = new Cubic(0.0, 0.0, (double)fArray2[n2 * 4], (double)fArray2[n2 * 4 + 1], (double)fArray2[n2 * 4 + 2], (double)fArray2[n2 * 4 + 3], 1.0, 1.0);
            }
        }
        if (fArray != null) {
            n2 = 0;
            if ((n == 1 || n == 3 || n == 2) && (fArray.length < 2 || fArray[0] != 0.0f || fArray[fArray.length - 1] != 1.0f) || n == 0 && (fArray.length == 0 || fArray[0] != 0.0f)) {
                n2 = 1;
            }
            if (n2 == 0) {
                for (int i = 1; i < fArray.length; ++i) {
                    if (!(fArray[i] < 0.0f) && !(fArray[1] > 1.0f) && !(fArray[i] < fArray[i - 1])) continue;
                    n2 = 1;
                    break;
                }
            }
            if (n2 != 0) {
                throw timedElement.createException("attribute.malformed", new Object[]{null, "keyTimes"});
            }
        }
    }

    protected boolean willReplace() {
        return !this.additive;
    }

    protected void sampledLastValue(int n) {
        this.sampledAtUnitTime(1.0f, n);
    }

    protected void sampledAt(float f, float f2, int n) {
        float f3 = f2 == Float.POSITIVE_INFINITY ? 0.0f : f / f2;
        this.sampledAtUnitTime(f3, n);
    }

    protected abstract void sampledAtUnitTime(float var1, int var2);
}

