/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.NewPeersSupport;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PeerReader;
import org.litesoft.p2pchat.PeerWriter;
import org.litesoft.p2pchat.PendingPeerLinkedList;
import org.litesoft.p2pchat.PendingPeerNode;
import org.litesoft.p2pchat.PendingPeersSupport;
import org.litesoft.p2pchat.UserDialog;

public class PendingPeerManager
extends Thread
implements NewPeersSupport {
    private UserDialog zUserDialog;
    private PendingPeerLinkedList zPendingPeers = new PendingPeerLinkedList();
    private PendingPeersSupport zPendingPeersSupport = null;
    private int maxRetries = 3;
    private boolean finish = false;

    public PendingPeerManager(UserDialog userDialog) {
        this.zUserDialog = userDialog;
        IllegalArgument.ifNull("UserDialog", this.zUserDialog);
        this.zUserDialog.setPendingPeerManager(this);
    }

    public void start(PendingPeersSupport pendingPeersSupport) {
        this.zPendingPeersSupport = pendingPeersSupport;
        IllegalArgument.ifNull("PendingPeersSupport", this.zPendingPeersSupport);
        this.start();
    }

    public void addNewPeer(PeerInfo peerInfo) {
        IllegalArgument.ifNull("Info", peerInfo);
        this.zPendingPeers.add(null, peerInfo);
    }

    public void addNewPeer(Socket socket) {
        IllegalArgument.ifNull("Socket", socket);
        InetAddress inetAddress = socket.getInetAddress();
        String string = inetAddress.getHostName();
        String string2 = inetAddress.getHostAddress();
        String string3 = string2.equals(string) ? null : "(Host: " + string + ")";
        this.zPendingPeers.add(socket, new PeerInfo(string3, string2));
    }

    public void addNewPeer(PeerInfo peerInfo, PeerReader peerReader, PeerWriter peerWriter) {
        this.zPendingPeersSupport.addActivePeer(peerInfo, peerReader, peerWriter);
    }

    public void run() {
        while (true) {
            final PendingPeerNode pendingPeerNode = this.zPendingPeers.next();
            if (this.finish) {
                return;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    PendingPeerManager.this.handleNewPeerClient(pendingPeerNode);
                }
            };
            new Thread(runnable).start();
        }
    }

    public void finish() {
        this.finish = true;
        this.interrupt();
    }

    private void handleNewPeerClient(PendingPeerNode pendingPeerNode) {
        Socket socket;
        PeerInfo peerInfo = pendingPeerNode.getPeerInfo();
        if (this.zPendingPeersSupport.isAlreadyConnected(peerInfo)) {
            return;
        }
        if ("true".equals(System.getProperty("debug"))) {
            System.err.println("Attempting to contact " + peerInfo.format());
        }
        if ((socket = pendingPeerNode.getSocket()) == null) {
            try {
                socket = this.getPeerClientSocketFromAddresses(peerInfo);
            }
            catch (IOException iOException) {
                if ("true".equals(System.getProperty("debug"))) {
                    System.err.println("Failed to establish connection to " + peerInfo.format() + ":  " + iOException.getMessage());
                }
                if (peerInfo.incrementFailureCount() <= this.maxRetries) {
                    this.zPendingPeers.add(socket, peerInfo);
                } else {
                    if ("true".equals(System.getProperty("debug"))) {
                        System.err.println("Maximum retries reached for " + peerInfo.format());
                    }
                    peerInfo.setFailureReason(iOException);
                    this.zUserDialog.showConnectFailed(peerInfo);
                }
                return;
            }
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = socket.getInputStream();
            outputStream = socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.zUserDialog.showStreamsFailed(peerInfo);
            try {
                socket.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return;
        }
        this.zPendingPeersSupport.addActivePeer(peerInfo, inputStream, outputStream);
        this.zUserDialog.showConnect(peerInfo);
    }

    private Socket getPeerClientSocketFromAddresses(PeerInfo peerInfo) throws IOException {
        int n;
        String string = peerInfo.getAddresses();
        int n2 = peerInfo.getPort();
        while (-1 != (n = string.indexOf(44))) {
            try {
                return this.getPeerClientSocket(string.substring(0, n), n2);
            }
            catch (IOException iOException) {
                if ("true".equals(System.getProperty("debug"))) {
                    System.err.println("Failed to establish connection to " + string.substring(0, n) + ":" + n2 + ".  " + iOException.getMessage());
                }
                string = string.substring(n + 1);
            }
        }
        return this.getPeerClientSocket(string, n2);
    }

    private Socket getPeerClientSocket(String string, int n) throws IOException {
        Socket socket = new Socket(string, n);
        if ("true".equals(System.getProperty("debug"))) {
            System.err.println("Established connection to " + string + ":" + n);
        }
        return socket;
    }

    public void setMaxRetries(int n) {
        this.maxRetries = n;
    }

    public void setSocketConnectTimeout(long l) {
    }
}

