/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.io.FileStore;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageTileDiskCache
implements ImageTileSource,
FileStore {
    protected final String cpath;

    public ImageTileDiskCache(String string) {
        this.cpath = string;
    }

    @Override
    public BufferedImage getTile(String string, int n, int n2, double d) throws ImageIOException {
        return TileUtils.read(this.cpath + '/' + TileUtils.tileName(string, n, n2, (int)(1.0 / d)));
    }

    @Override
    public Dimension getTileSize(String string, int n, int n2, double d) throws ImageIOException {
        return TileUtils.size(this.cpath + '/' + TileUtils.tileName(string, n, n2, (int)(1.0 / d)));
    }

    @Override
    public boolean tileExists(String string, int n, int n2, double d) throws ImageIOException {
        File file = new File(this.cpath + '/' + TileUtils.tileName(string, n, n2, (int)(1.0 / d)));
        return file.exists() && file.isFile();
    }

    @Override
    public boolean contains(String string) throws IOException {
        return new File(this.cpath + "/" + string).exists();
    }

    @Override
    public InputStream getInputStream(String string) throws IOException {
        return new FileInputStream(this.cpath + "/" + string);
    }

    @Override
    public long getSize(String string) throws IOException {
        return new File(this.cpath + "/" + string).length();
    }

    @Override
    public long getMTime(String string) throws IOException {
        return new File(this.cpath + "/" + string).lastModified();
    }

    @Override
    public List<String> getFiles() throws IOException {
        File[] fileArray = new File(this.cpath).listFiles();
        ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
        for (File file : fileArray) {
            arrayList.add(file.getPath());
        }
        return arrayList;
    }

    @Override
    public List<String> getFiles(String string) throws IOException {
        File[] fileArray = new File(this.cpath).listFiles();
        ArrayList<String> arrayList = new ArrayList<String>(fileArray.length);
        for (File file : fileArray) {
            String string2 = file.getPath();
            if (!string2.startsWith(string)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void close() {
    }
}

