/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.icon;

import VASSAL.build.IllegalBuildException;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.JarArchive;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.icon.IconFamily;
import VASSAL.tools.io.IOUtils;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IconFactory {
    private static final Logger logger = LoggerFactory.getLogger(IconFactory.class);
    static final String FILE = "file:";
    static final String JAR = "jar:";
    private static final JarArchive jar = new JarArchive();
    private static IconFactory instance = new IconFactory();
    private Map<String, IconFamily> iconFamilies = new ConcurrentHashMap<String, IconFamily>();
    private static final Object preloadLock = new Object();
    private Thread preloadThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = preloadLock;
            synchronized (object) {
                try {
                    IconFactory.this.initVassalIconFamilys();
                }
                catch (IllegalBuildException illegalBuildException) {
                    ErrorDialog.bug(illegalBuildException);
                }
            }
        }
    }, "IconFactory-preload");

    static void setInstance(IconFactory iconFactory) {
        instance = iconFactory;
    }

    static IconFactory getInstance() {
        if (instance == null) {
            throw new IllegalStateException("No IconFactory instance");
        }
        return instance;
    }

    public IconFactory() {
        this.preloadThread.start();
    }

    public static Icon getIcon(String string, int n) {
        IconFamily iconFamily = IconFactory.getInstance().getFamily(string);
        if (iconFamily == null) {
            throw new IllegalStateException(Resources.getString("Error.not_found", IconFamily.getConfigureTypeName() + " " + string));
        }
        return iconFamily.getIcon(n);
    }

    public static BufferedImage getImage(String string, int n) {
        IconFamily iconFamily = IconFactory.getInstance().getFamily(string);
        if (iconFamily == null) {
            throw new IllegalStateException(Resources.getString("Error.not_found", IconFamily.getConfigureTypeName() + " " + string));
        }
        return iconFamily.getImage(n);
    }

    public static List<String> getIconFamilyNames() {
        return IconFactory.getInstance().getIconFamilyList();
    }

    public static void addIconFamily(IconFamily iconFamily) {
        IconFactory.getInstance().add(iconFamily);
    }

    public static void removeIconFamily(IconFamily iconFamily) {
        IconFactory.getInstance().remove(iconFamily);
    }

    public static void renameIconFamily(String string, IconFamily iconFamily) {
        IconFactory.getInstance().rename(string, iconFamily);
    }

    public static IconFamily getIconFamily(String string) {
        return IconFactory.getInstance().getFamily(string);
    }

    private void add(IconFamily iconFamily) {
        if (this.iconFamilies.get(iconFamily.getName()) == null) {
            this.iconFamilies.put(iconFamily.getName(), iconFamily);
        }
    }

    private void remove(IconFamily iconFamily) {
        IconFamily iconFamily2 = this.iconFamilies.get(iconFamily.getName());
        if (iconFamily2 != null && iconFamily2 == iconFamily) {
            this.iconFamilies.remove(iconFamily.getName());
        }
    }

    private void rename(String string, IconFamily iconFamily) {
        IconFamily iconFamily2 = this.iconFamilies.get(string);
        if (iconFamily2 != null && iconFamily2 == iconFamily) {
            this.iconFamilies.remove(string);
        }
        this.add(iconFamily);
    }

    IconFamily getFamily(String string) {
        try {
            if (this.preloadThread.isAlive()) {
                try {
                    this.preloadThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.iconFamilies.get(string);
        }
        catch (IllegalStateException illegalStateException) {
            ErrorDialog.bug(illegalStateException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getIconFamilyList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = preloadLock;
        synchronized (object) {
            for (String string : this.iconFamilies.keySet()) {
                arrayList.add(string);
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    private void initVassalIconFamilys() {
        block5: {
            URL uRL = null;
            try {
                uRL = jar.getURL("images/VASSAL-256x256.png");
                uRL = new URL(uRL.toString().substring(0, uRL.toString().length() - "VASSAL-256x256.png".length()));
                logger.info("VASSAL images folder found at " + uRL);
                if (uRL.toString().startsWith(FILE)) {
                    this.findLocalScalableIcons();
                    for (int i = 0; i < IconFamily.SIZE_DIRS.length; ++i) {
                        this.findLocalSizedIcons(i);
                    }
                    break block5;
                }
                if (uRL.toString().startsWith(JAR)) {
                    this.findJarIcons();
                    break block5;
                }
                throw new IllegalBuildException("Unknown Vassal Image source type: " + uRL.toString());
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, uRL.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findLocalSizedIcons(int n) throws IOException {
        String string = "icons/" + IconFamily.SIZE_DIRS[n];
        URL uRL = jar.getURL(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string2 = "";
            while (string2 != null) {
                string2 = bufferedReader.readLine();
                if (string2 == null) continue;
                String string3 = string2.split("\\.")[0];
                IconFamily iconFamily = this.iconFamilies.get(string3);
                if (iconFamily == null) {
                    iconFamily = new IconFamily(string3);
                    logger.info("Icon family " + string3 + " created for " + string2);
                }
                iconFamily.setSizeIconPath(n, "/" + string + string2);
                this.iconFamilies.put(string3, iconFamily);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findLocalScalableIcons() throws IOException {
        URL uRL = jar.getURL("icons/scalable/");
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            String string = "";
            while (string != null) {
                string = bufferedReader.readLine();
                if (string == null) continue;
                String string2 = string.split("\\.")[0];
                IconFamily iconFamily = this.iconFamilies.get(string2);
                if (iconFamily == null) {
                    iconFamily = new IconFamily(string2);
                    logger.info("Icon family " + string2 + " created for " + string);
                }
                iconFamily.setScalableIconPath("/icons/scalable/" + string);
                this.iconFamilies.put(string2, iconFamily);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)bufferedReader);
    }

    private void findJarIcons() throws IOException {
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            stringArray[i] = "icons/" + IconFamily.SIZE_DIRS[i];
        }
        JarURLConnection jarURLConnection = (JarURLConnection)jar.getURL("images/").openConnection();
        JarFile jarFile = jarURLConnection.getJarFile();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        block1: while (enumeration.hasMoreElements()) {
            Object object;
            String string;
            JarEntry jarEntry = enumeration.nextElement();
            String string2 = jarEntry.getName();
            if (!string2.startsWith("icons/")) continue;
            if (string2.startsWith("icons/scalable/") && !string2.equals("icons/scalable/")) {
                String string3 = string2.substring("icons/scalable/".length());
                string = string3.split("\\.")[0];
                object = this.iconFamilies.get(string);
                if (object == null) {
                    object = new IconFamily(string);
                    logger.info("Icon family " + string + " created for " + string3);
                }
                ((IconFamily)object).setScalableIconPath("/" + string2);
                this.iconFamilies.put(string, (IconFamily)object);
                continue;
            }
            for (int i = 0; i < 4; ++i) {
                if (!string2.startsWith(stringArray[i]) || string2.equals(stringArray[i])) continue;
                string = string2.substring(stringArray[i].length());
                object = string.split("\\.")[0];
                IconFamily iconFamily = this.iconFamilies.get(object);
                if (iconFamily == null) {
                    iconFamily = new IconFamily((String)object);
                    logger.info("Icon family " + (String)object + " created for " + string);
                }
                iconFamily.setSizeIconPath(i, "/" + string2);
                this.iconFamilies.put((String)object, iconFamily);
                continue block1;
            }
        }
    }
}

