/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.NamedKeyManager;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class NamedKeyStroke {
    public static final NamedKeyStroke NULL_KEYSTROKE = new NamedKeyStroke();
    protected KeyStroke stroke;
    protected String name;

    public NamedKeyStroke(int n, int n2) {
        this(n, n2, null);
    }

    public NamedKeyStroke(int n, int n2, String string) {
        this(KeyStroke.getKeyStroke(n, n2), string);
    }

    public NamedKeyStroke(KeyStroke keyStroke, String string) {
        this.stroke = keyStroke;
        this.name = string;
    }

    public NamedKeyStroke(KeyStroke keyStroke) {
        this(keyStroke, null);
    }

    public NamedKeyStroke(String string) {
        this(NamedKeyManager.getMarkerKeyStroke(), string);
    }

    public NamedKeyStroke() {
        this(null, null);
    }

    public boolean isNamed() {
        return this.name != null && this.name.length() != 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNull() {
        return this.stroke == null && this.name == null || this.stroke != null & this.stroke.getKeyCode() == 0 && this.stroke.getModifiers() == 0;
    }

    public KeyStroke getStroke() {
        return this.stroke;
    }

    public boolean equals(Object object) {
        if (object instanceof NamedKeyStroke) {
            if (this.getKeyStroke() == null) {
                return ((NamedKeyStroke)object).getKeyStroke() == null;
            }
            return this.getKeyStroke().equals(((NamedKeyStroke)object).getKeyStroke());
        }
        if (object instanceof KeyStroke) {
            KeyStroke keyStroke = this.getKeyStroke();
            if (keyStroke == null) {
                return object == null;
            }
            return keyStroke.equals(object);
        }
        return false;
    }

    public KeyStroke getKeyStroke() {
        if (this.isNamed()) {
            return NamedKeyManager.getInstance().getKeyStroke(this);
        }
        return this.getStroke();
    }

    public static NamedKeyStroke getNamedKeyStroke(char c) {
        return NamedKeyStroke.getNamedKeyStroke(c, 0);
    }

    public static NamedKeyStroke getNamedKeyStroke(char c, int n) {
        return new NamedKeyStroke(KeyStroke.getKeyStroke((int)c, n));
    }

    public static NamedKeyStroke getNamedKeyStroke(int n, int n2) {
        return new NamedKeyStroke(KeyStroke.getKeyStroke(n, n2));
    }

    public static NamedKeyStroke getKeyStrokeForEvent(KeyEvent keyEvent) {
        return new NamedKeyStroke(KeyStroke.getKeyStrokeForEvent(keyEvent));
    }
}

