/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.chat.CgiServerStatus;
import VASSAL.chat.ui.ServerStatusView;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.AboutVASSALAction;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.Editor;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchTourAction;
import VASSAL.launch.ModuleManager;
import VASSAL.launch.Player;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ApplicationIcons;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ModuleExtensionFileFilter;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.logging.LogPane;
import VASSAL.tools.menu.CheckBoxMenuItemProxy;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.version.UpdateCheckAction;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManagerWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ModuleManagerWindow.class);
    private static final String SHOW_STATUS_KEY = "showServerStatus";
    private static final String DIVIDER_LOCATION_KEY = "moduleManagerDividerLocation";
    private static final int COLUMNS = 4;
    private static final int KEY_COLUMN = 0;
    private static final int VERSION_COLUMN = 1;
    private static final int VASSAL_COLUMN = 2;
    private static final int SPARE_COLUMN = 3;
    private static final String[] columnHeadings = new String[4];
    private final ImageIcon moduleIcon;
    private final ImageIcon activeExtensionIcon;
    private final ImageIcon inactiveExtensionIcon;
    private final ImageIcon openGameFolderIcon;
    private final ImageIcon closedGameFolderIcon;
    private final ImageIcon fileIcon;
    private StringArrayConfigurer recentModuleConfig;
    private File selectedModule;
    private CardLayout modulePanelLayout;
    private JPanel moduleView;
    private ComponentSplitter.SplitPane serverStatusView;
    private MyTreeNode rootNode;
    private MyTree tree;
    private MyTreeTableModel treeModel;
    private MyTreeNode selectedNode;
    private long lastExpansionTime;
    private TreePath lastExpansionPath;
    private IntConfigurer dividerLocationConfig;
    private static final long doubleClickInterval;
    private static final ModuleManagerWindow instance;

    public static ModuleManagerWindow getInstance() {
        return instance;
    }

    public ModuleManagerWindow() {
        JComponent jComponent;
        Serializable serializable;
        this.setTitle("VASSAL");
        this.setLayout(new BoxLayout(this.getContentPane(), 0));
        ApplicationIcons.setFor(this);
        final AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AbstractLaunchAction.shutDown()) {
                    return;
                }
                Prefs prefs = Prefs.getGlobalPrefs();
                try {
                    prefs.close();
                }
                catch (IOException iOException) {
                    WriteErrorDialog.error(iOException, prefs.getFile());
                }
                finally {
                    IOUtils.closeQuietly((Closeable)prefs);
                }
                try {
                    ModuleManager.getInstance().shutDown();
                }
                catch (IOException iOException) {
                    ErrorDialog.bug(iOException);
                }
                logger.info("Exiting");
                System.exit(0);
            }
        };
        abstractAction.putValue("Name", Resources.getString("General.quit"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                abstractAction.actionPerformed(null);
            }
        });
        MenuManager menuManager = MenuManager.getInstance();
        MenuBarProxy menuBarProxy = menuManager.getMenuBarProxyFor(this);
        MenuProxy menuProxy = new MenuProxy(Resources.getString("General.file"));
        menuProxy.setMnemonic(Resources.getString("General.file.shortcut").charAt(0));
        menuProxy.add(menuManager.addKey("Main.play_module"));
        menuProxy.add(menuManager.addKey("Main.edit_module"));
        menuProxy.add(menuManager.addKey("Main.new_module"));
        menuProxy.add(menuManager.addKey("Main.import_module"));
        menuProxy.addSeparator();
        if (!SystemUtils.IS_OS_MAC_OSX) {
            menuProxy.add(menuManager.addKey("Prefs.edit_preferences"));
            menuProxy.addSeparator();
            menuProxy.add(menuManager.addKey("General.quit"));
        }
        MenuProxy menuProxy2 = new MenuProxy(Resources.getString("General.tools"));
        Prefs.getGlobalPrefs().getEditor().initDialog(this);
        Prefs.initSharedGlobalPrefs();
        final BooleanConfigurer booleanConfigurer = new BooleanConfigurer(SHOW_STATUS_KEY, null, Boolean.FALSE);
        Prefs.getGlobalPrefs().addOption(null, booleanConfigurer);
        this.dividerLocationConfig = new IntConfigurer(DIVIDER_LOCATION_KEY, null, (Integer)-10);
        Prefs.getGlobalPrefs().addOption(null, this.dividerLocationConfig);
        menuProxy2.add(new CheckBoxMenuItemProxy(new AbstractAction(Resources.getString("Chat.server_status")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ModuleManagerWindow.this.serverStatusView.toggleVisibility();
                booleanConfigurer.setValue(booleanConfigurer.booleanValue() != false ? Boolean.FALSE : Boolean.TRUE);
                if (ModuleManagerWindow.this.serverStatusView.isVisible()) {
                    ModuleManagerWindow.this.setDividerLocation(ModuleManagerWindow.this.getPreferredDividerLocation());
                }
            }
        }, booleanConfigurer.booleanValue()));
        menuProxy2.add(new MenuItemProxy(new AbstractAction(Resources.getString("ModuleManager.clear_tilecache")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                if (Dialogs.showConfirmDialog(ModuleManagerWindow.this, Resources.getString("ModuleManager.clear_tilecache_title"), Resources.getString("ModuleManager.clear_tilecache_heading"), Resources.getString("ModuleManager.clear_tilecache_message"), 2, 2) == 0 && (file = new File(Info.getConfDir(), "tiles")).exists()) {
                    try {
                        FileUtils.forceDelete((File)file);
                        FileUtils.forceMkdir((File)file);
                    }
                    catch (IOException iOException) {
                        WriteErrorDialog.error(iOException, file);
                    }
                }
            }
        }));
        MenuProxy menuProxy3 = new MenuProxy(Resources.getString("General.help"));
        menuProxy3.setMnemonic(Resources.getString("General.help.shortcut").charAt(0));
        menuProxy3.add(menuManager.addKey("General.help"));
        menuProxy3.add(menuManager.addKey("Main.tour"));
        menuProxy3.add(menuManager.addKey("Help.user_guide"));
        menuProxy3.addSeparator();
        menuProxy3.add(menuManager.addKey("UpdateCheckAction.update_check"));
        menuProxy3.add(menuManager.addKey("Help.error_log"));
        if (!SystemUtils.IS_OS_MAC_OSX) {
            menuProxy3.addSeparator();
            menuProxy3.add(menuManager.addKey("AboutScreen.about_vassal"));
        }
        menuBarProxy.add(menuProxy);
        menuBarProxy.add(menuProxy2);
        menuBarProxy.add(menuProxy3);
        menuManager.addAction("Main.play_module", new Player.PromptLaunchAction(this));
        menuManager.addAction("Main.edit_module", new Editor.PromptLaunchAction(this));
        menuManager.addAction("Main.new_module", new Editor.NewModuleLaunchAction(this));
        menuManager.addAction("Main.import_module", new Editor.PromptImportLaunchAction(this));
        menuManager.addAction("Prefs.edit_preferences", Prefs.getGlobalPrefs().getEditor().getEditAction());
        menuManager.addAction("General.quit", abstractAction);
        try {
            serializable = new File(Documentation.getDocumentationBaseDir(), "README.html").toURI().toURL();
            menuManager.addAction("General.help", new ShowHelpAction((URL)serializable, null));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        try {
            serializable = new File(Documentation.getDocumentationBaseDir(), "userguide/userguide.pdf").toURI().toURL();
            menuManager.addAction("Help.user_guide", new ShowHelpAction("Help.user_guide", (URL)serializable, null));
        }
        catch (MalformedURLException malformedURLException) {
            ErrorDialog.bug(malformedURLException);
        }
        menuManager.addAction("Main.tour", new LaunchTourAction(this));
        menuManager.addAction("AboutScreen.about_vassal", new AboutVASSALAction(this));
        menuManager.addAction("UpdateCheckAction.update_check", new UpdateCheckAction(this));
        menuManager.addAction("Help.error_log", new ShowErrorLogAction(this));
        this.setJMenuBar(menuManager.getMenuBarFor(this));
        this.moduleIcon = new ImageIcon(this.getClass().getResource("/images/mm-module.png"));
        this.activeExtensionIcon = new ImageIcon(this.getClass().getResource("/images/mm-extension-active.png"));
        this.inactiveExtensionIcon = new ImageIcon(this.getClass().getResource("/images/mm-extension-inactive.png"));
        this.openGameFolderIcon = new ImageIcon(this.getClass().getResource("/images/mm-gamefolder-open.png"));
        this.closedGameFolderIcon = new ImageIcon(this.getClass().getResource("/images/mm-gamefolder-closed.png"));
        this.fileIcon = new ImageIcon(this.getClass().getResource("/images/mm-file.png"));
        serializable = new JPanel(new BorderLayout());
        this.modulePanelLayout = new CardLayout();
        this.moduleView = new JPanel(this.modulePanelLayout);
        this.buildTree();
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.tree));
        this.moduleView.add((Component)jScrollPane, "modules");
        JEditorPane jEditorPane = new JEditorPane("text/html", Resources.getString("ModuleManager.quickstart"));
        jEditorPane.setEditable(false);
        Color color = UIManager.getColor("control");
        Font font = UIManager.getFont("Label.font");
        if (color == null || font == null) {
            jComponent = new JLabel();
            if (color == null) {
                color = jComponent.getBackground();
            }
            if (font == null) {
                font = jComponent.getFont();
            }
        }
        jEditorPane.setBackground(color);
        ((HTMLEditorKit)jEditorPane.getEditorKit()).getStyleSheet().addRule("body { font: " + font.getFamily() + " " + font.getSize() + "pt }");
        jEditorPane.addHyperlinkListener(BrowserSupport.getListener());
        jComponent = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        jComponent.add((Component)jEditorPane, gridBagConstraints);
        this.moduleView.add((Component)jComponent, "quickStart");
        this.modulePanelLayout.show(this.moduleView, this.getModuleCount() == 0 ? "quickStart" : "modules");
        ((Container)serializable).add(this.moduleView, "Center");
        ((JComponent)serializable).setBorder(new TitledBorder(Resources.getString("ModuleManager.recent_modules")));
        this.add((Component)serializable);
        ServerStatusView serverStatusView = new ServerStatusView(new CgiServerStatus());
        serverStatusView.setBorder(new TitledBorder(Resources.getString("Chat.server_status")));
        this.serverStatusView = new ComponentSplitter().splitRight((Component)serializable, serverStatusView, false);
        this.serverStatusView.revalidate();
        if (booleanConfigurer.booleanValue().booleanValue()) {
            this.serverStatusView.showComponent();
        }
        this.setDividerLocation(this.getPreferredDividerLocation());
        this.serverStatusView.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModuleManagerWindow.this.setPreferredDividerLocation((Integer)propertyChangeEvent.getNewValue());
            }
        });
        Rectangle rectangle = Info.getScreenBounds(this);
        serverStatusView.setPreferredSize(new Dimension((int)((double)rectangle.width / 3.5), 0));
        this.setSize(3 * rectangle.width / 4, 3 * rectangle.height / 4);
        PositionOption positionOption = new PositionOption(PositionOption.key + "ModuleManager", this);
        Prefs.getGlobalPrefs().addOption(positionOption);
    }

    public void setWaitCursor(boolean bl) {
        this.setCursor(Cursor.getPredefinedCursor(bl ? 3 : 0));
    }

    protected void setDividerLocation(int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            public void run() {
                ModuleManagerWindow.this.serverStatusView.setDividerLocation(n2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    protected void setPreferredDividerLocation(int n) {
        this.dividerLocationConfig.setValue(n);
    }

    protected int getPreferredDividerLocation() {
        return this.dividerLocationConfig.getIntValue(500);
    }

    protected void buildTree() {
        this.recentModuleConfig = new StringArrayConfigurer("RecentModules", null);
        Prefs.getGlobalPrefs().addOption(null, this.recentModuleConfig);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ModuleInfo> arrayList2 = new ArrayList<ModuleInfo>();
        for (String object2 : this.recentModuleConfig.getStringArray()) {
            ModuleInfo moduleInfo = new ModuleInfo(object2);
            if (moduleInfo.getFile().exists() && moduleInfo.isValid()) {
                arrayList2.add(moduleInfo);
                continue;
            }
            arrayList.add(object2);
        }
        for (String string : arrayList) {
            logger.info(Resources.getString("ModuleManager.removing_module", string));
            arrayList2.remove(string);
            this.recentModuleConfig.removeValue(string);
        }
        Collections.sort(arrayList2, new Comparator<ModuleInfo>(){

            @Override
            public int compare(ModuleInfo moduleInfo, ModuleInfo moduleInfo2) {
                return moduleInfo.compareTo(moduleInfo2);
            }
        });
        this.rootNode = new MyTreeNode(new RootInfo());
        for (ModuleInfo moduleInfo : arrayList2) {
            MyTreeNode myTreeNode = new MyTreeNode(moduleInfo);
            for (ExtensionInfo extensionInfo : moduleInfo.getExtensions()) {
                MyTreeNode myTreeNode2 = new MyTreeNode(extensionInfo);
                myTreeNode.add((MutableTreeTableNode)myTreeNode2);
            }
            ArrayList<File> arrayList3 = new ArrayList<File>();
            for (File file : moduleInfo.getFolders()) {
                if (file.exists() && file.isDirectory()) {
                    GameFolderInfo gameFolderInfo = new GameFolderInfo(file, moduleInfo);
                    MyTreeNode myTreeNode3 = new MyTreeNode(gameFolderInfo);
                    myTreeNode.add((MutableTreeTableNode)myTreeNode3);
                    ArrayList<File> arrayList4 = new ArrayList<File>();
                    File[] fileArray = file.listFiles();
                    if (fileArray == null) continue;
                    for (Object object : fileArray) {
                        if (!object.isFile()) continue;
                        arrayList4.add((File)object);
                    }
                    Collections.sort(arrayList4);
                    for (File file2 : arrayList4) {
                        Object object;
                        SaveFileInfo saveFileInfo = new SaveFileInfo(file2, gameFolderInfo);
                        if (!saveFileInfo.isValid() || !saveFileInfo.belongsToModule()) continue;
                        object = new MyTreeNode(saveFileInfo);
                        myTreeNode3.add((MutableTreeTableNode)object);
                    }
                    continue;
                }
                arrayList3.add(file);
            }
            for (File file : arrayList3) {
                logger.info(Resources.getString("ModuleManager.removing_folder", file.getPath()));
                moduleInfo.removeFolder(file);
            }
            this.rootNode.add((MutableTreeTableNode)myTreeNode);
        }
        this.updateModuleList();
        this.treeModel = new MyTreeTableModel(this.rootNode);
        this.tree = new MyTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.setTreeCellRenderer(new MyTreeCellRenderer());
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    TreePath treePath = ModuleManagerWindow.this.tree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                    if (treePath == null || ModuleManagerWindow.this.lastExpansionPath == treePath && mouseEvent.getWhen() - ModuleManagerWindow.this.lastExpansionTime <= doubleClickInterval) {
                        return;
                    }
                    ModuleManagerWindow.this.selectedNode = (MyTreeNode)((Object)treePath.getLastPathComponent());
                    int n = ModuleManagerWindow.this.tree.getRowForPath(treePath);
                    if (n < 0) {
                        return;
                    }
                    AbstractInfo abstractInfo = (AbstractInfo)ModuleManagerWindow.this.selectedNode.getUserObject();
                    if (abstractInfo instanceof ModuleInfo) {
                        ModuleInfo moduleInfo = (ModuleInfo)abstractInfo;
                        if (moduleInfo.isModuleTooNew()) {
                            ErrorDialog.show("Error.module_too_new", moduleInfo.getFile().getPath(), moduleInfo.getVassalVersion(), Info.getVersion());
                            return;
                        }
                        ((ModuleInfo)abstractInfo).play();
                    } else if (abstractInfo instanceof SaveFileInfo) {
                        ((SaveFileInfo)abstractInfo).play();
                    } else if (ModuleManagerWindow.this.tree.isExpanded(n)) {
                        ModuleManagerWindow.this.tree.collapseRow(n);
                    } else {
                        ModuleManagerWindow.this.tree.expandRow(n);
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int n;
                TreePath treePath = ModuleManagerWindow.this.tree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                if (treePath == null) {
                    return;
                }
                ModuleManagerWindow.this.selectedNode = (MyTreeNode)((Object)treePath.getLastPathComponent());
                if (mouseEvent.isMetaDown() && (n = ModuleManagerWindow.this.tree.getRowForPath(treePath)) >= 0) {
                    ModuleManagerWindow.this.tree.clearSelection();
                    ModuleManagerWindow.this.tree.addRowSelectionInterval(n, n);
                    AbstractInfo abstractInfo = (AbstractInfo)ModuleManagerWindow.this.selectedNode.getUserObject();
                    abstractInfo.buildPopup(n).show((Component)((Object)ModuleManagerWindow.this.tree), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) {
                ModuleManagerWindow.this.lastExpansionTime = System.currentTimeMillis();
                ModuleManagerWindow.this.lastExpansionPath = treeExpansionEvent.getPath();
            }

            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) {
                ModuleManagerWindow.this.lastExpansionTime = System.currentTimeMillis();
                ModuleManagerWindow.this.lastExpansionPath = treeExpansionEvent.getPath();
            }
        });
        this.tree.setToggleClickCount(3);
        this.tree.setSelectionMode(0);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                MyTreeNode myTreeNode = (MyTreeNode)((Object)treeSelectionEvent.getPath().getLastPathComponent());
                AbstractInfo abstractInfo = myTreeNode.getNodeInfo();
                if (abstractInfo instanceof ModuleInfo) {
                    ModuleManagerWindow.this.setSelectedModule(abstractInfo.getFile());
                } else if (myTreeNode.getParent() != null) {
                    ModuleManagerWindow.this.setSelectedModule(myTreeNode.getParentModuleFile());
                }
            }
        });
        this.tree.getColumnModel().getColumn(0).setMinWidth(250);
        this.tree.getColumnModel().getColumn(1).setCellRenderer(new VersionCellRenderer());
        this.tree.getColumnModel().getColumn(1).setMinWidth(100);
        this.tree.getColumnModel().getColumn(2).setCellRenderer(new VersionCellRenderer());
        this.tree.getColumnModel().getColumn(2).setMinWidth(100);
        this.tree.getColumnModel().getColumn(3).setMinWidth(10);
        this.tree.getColumnModel().getColumn(3).setPreferredWidth(600);
        this.tree.getTableHeader().setAlignmentX(0.5f);
    }

    public void update(File file) {
        AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(file);
        if (abstractMetaData instanceof ModuleMetaData) {
            MyTreeNode myTreeNode = this.rootNode.findNode(file);
            if (myTreeNode == null) {
                this.addModule(file);
            } else {
                myTreeNode.refresh();
            }
        } else if (abstractMetaData instanceof ExtensionMetaData) {
            for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                MyTreeNode myTreeNode = this.rootNode.getChild(i);
                ModuleInfo moduleInfo = (ModuleInfo)myTreeNode.getNodeInfo();
                for (ExtensionInfo extensionInfo : moduleInfo.getExtensions()) {
                    if (!extensionInfo.getFile().equals(file)) continue;
                    myTreeNode.refresh();
                    return;
                }
            }
        } else if (abstractMetaData instanceof SaveMetaData) {
            for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
                MyTreeNode myTreeNode = this.rootNode.getChild(i);
                MyTreeNode myTreeNode2 = myTreeNode.findNode(file.getParentFile());
                if (myTreeNode2 == null || !(myTreeNode2.getNodeInfo() instanceof GameFolderInfo)) continue;
                ((GameFolderInfo)myTreeNode2.getNodeInfo()).update(file);
                return;
            }
        }
        this.tree.repaint();
    }

    private int getModuleCount() {
        return this.rootNode.getChildCount();
    }

    public File getSelectedModule() {
        return this.selectedModule;
    }

    private void setSelectedModule(File file) {
        this.selectedModule = file;
    }

    public void addModule(File file) {
        ModuleInfo moduleInfo;
        if (!this.rootNode.contains(file) && (moduleInfo = new ModuleInfo(file)).isValid()) {
            MyTreeNode myTreeNode = new MyTreeNode(moduleInfo);
            this.treeModel.insertNodeInto((MutableTreeTableNode)myTreeNode, (MutableTreeTableNode)this.rootNode, this.rootNode.findInsertIndex(moduleInfo));
            for (ExtensionInfo extensionInfo : moduleInfo.getExtensions()) {
                MyTreeNode myTreeNode2 = new MyTreeNode(extensionInfo);
                this.treeModel.insertNodeInto((MutableTreeTableNode)myTreeNode2, (MutableTreeTableNode)myTreeNode, myTreeNode.findInsertIndex(extensionInfo));
            }
            this.updateModuleList();
        }
    }

    public void removeModule(File file) {
        MyTreeNode myTreeNode = this.rootNode.findNode(file);
        this.treeModel.removeNodeFromParent((MutableTreeTableNode)myTreeNode);
        this.updateModuleList();
    }

    public File getModuleByName(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            ModuleInfo moduleInfo = (ModuleInfo)this.rootNode.getChild(i).getNodeInfo();
            if (!string.equals(moduleInfo.getModuleName())) continue;
            return moduleInfo.getFile();
        }
        return null;
    }

    private void updateModuleList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.rootNode.getChildCount(); ++i) {
            ModuleInfo moduleInfo = (ModuleInfo)this.rootNode.getChild(i).getNodeInfo();
            arrayList.add(moduleInfo.encode());
        }
        this.recentModuleConfig.setValue(arrayList.toArray(new String[arrayList.size()]));
        this.modulePanelLayout.show(this.moduleView, this.getModuleCount() == 0 ? "quickStart" : "modules");
    }

    static {
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
        doubleClickInterval = object instanceof Integer ? (long)((Integer)object).intValue() : 200L;
        instance = new ModuleManagerWindow();
    }

    private static class ShowErrorLogAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private Frame frame;

        public ShowErrorLogAction(Frame frame) {
            super(Resources.getString("Help.error_log"));
            this.frame = frame;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = new File(Info.getHomeDir(), "errorLog");
            LogPane logPane = new LogPane(file);
            JDialog jDialog = new JDialog(this.frame, Resources.getString("Help.error_log"));
            jDialog.setLayout(new MigLayout("insets 0"));
            jDialog.add((Component)new JScrollPane(logPane), "grow, push, w 500, h 600");
            jDialog.setLocationRelativeTo(this.frame);
            jDialog.setDefaultCloseOperation(2);
            jDialog.pack();
            jDialog.setVisible(true);
        }
    }

    private static class EditExtensionLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public EditExtensionLaunchAction(Frame frame, File file, File file2) {
            super(Resources.getString("Editor.edit_extension"), frame, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.EDIT_EXT, file2, file));
            this.setEnabled(!using.containsKey(file2) && !editing.contains(file2) && !editing.contains(file) && !using.containsKey(file));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (editing.contains(this.lr.module) || editing.contains(this.lr.extension)) {
                return;
            }
            Integer n2 = (Integer)using.get(this.lr.module);
            File file = this.lr.module;
            if (n2 == null) {
                n = 1;
            } else {
                n2 = n2 + 1;
                n = n2;
            }
            using.put(file, n);
            editing.add(this.lr.extension);
            super.actionPerformed(actionEvent);
            this.setEnabled(false);
        }

        protected void addFileFilters(FileChooser fileChooser) {
            fileChooser.addChoosableFileFilter(new ModuleExtensionFileFilter());
        }

        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                protected void done() {
                    super.done();
                    Integer n = AbstractLaunchAction.using.get(this.lr.module);
                    if (n == 1) {
                        AbstractLaunchAction.using.remove(this.lr.module);
                    } else {
                        n = n - 1;
                        AbstractLaunchAction.using.put(this.lr.module, n);
                    }
                    AbstractLaunchAction.editing.remove(this.lr.extension);
                    EditExtensionLaunchAction.this.setEnabled(true);
                }
            };
        }
    }

    private class NewExtensionLaunchAction
    extends AbstractLaunchAction {
        private static final long serialVersionUID = 1L;

        public NewExtensionLaunchAction(Frame frame) {
            super(Resources.getString("ModuleManager.new_extension"), frame, Editor.class.getName(), new LaunchRequest(LaunchRequest.Mode.NEW_EXT));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            this.lr.module = ModuleManagerWindow.this.getSelectedModule();
            if (editing.contains(this.lr.module)) {
                return;
            }
            Integer n2 = (Integer)using.get(this.lr.module);
            File file = this.lr.module;
            if (n2 == null) {
                n = 1;
            } else {
                n2 = n2 + 1;
                n = n2;
            }
            using.put(file, n);
            super.actionPerformed(actionEvent);
        }

        protected AbstractLaunchAction.LaunchTask getLaunchTask() {
            return new AbstractLaunchAction.LaunchTask(){

                protected void done() {
                    super.done();
                    Integer n = AbstractLaunchAction.using.get(this.lr.module);
                    if (n == 1) {
                        AbstractLaunchAction.using.remove(this.lr.module);
                    } else {
                        n = n - 1;
                        AbstractLaunchAction.using.put(this.lr.module, n);
                    }
                }
            };
        }
    }

    private class SaveFileInfo
    extends AbstractInfo {
        protected GameFolderInfo folderInfo;
        protected SaveMetaData metadata;

        public SaveFileInfo(File file, GameFolderInfo gameFolderInfo) {
            super(file, ModuleManagerWindow.this.fileIcon);
            this.folderInfo = gameFolderInfo;
            this.loadMetaData();
        }

        protected void loadMetaData() {
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.file);
            if (abstractMetaData != null && abstractMetaData instanceof SaveMetaData) {
                this.metadata = (SaveMetaData)abstractMetaData;
                this.setValid(true);
            } else {
                this.setValid(false);
            }
        }

        public void refresh() {
            this.loadMetaData();
            ModuleManagerWindow.this.tree.repaint();
        }

        public JPopupMenu buildPopup(int n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new Player.LaunchAction(ModuleManagerWindow.this, this.getModuleFile(), this.file));
            return jPopupMenu;
        }

        protected File getModuleFile() {
            return this.folderInfo.getModuleInfo().getFile();
        }

        public void play() {
            new Player.LaunchAction(ModuleManagerWindow.this, this.getModuleFile(), this.file).actionPerformed(null);
        }

        public String getValueAt(int n) {
            return n == 3 ? this.buildComments() : super.getValueAt(n);
        }

        private String buildComments() {
            String string = "";
            if (!this.belongsToModule() && this.metadata != null && this.metadata.getModuleName().length() > 0) {
                string = "[" + this.metadata.getModuleName() + "] ";
            }
            string = string + (this.metadata == null ? "" : this.metadata.getDescription());
            return string;
        }

        private boolean belongsToModule() {
            return this.metadata != null && (this.metadata.getModuleName().length() == 0 || this.folderInfo.getModuleInfo().getModuleName().equals(this.metadata.getModuleName()));
        }

        public Color getTreeCellFgColor() {
            return this.belongsToModule() ? Color.black : Color.gray;
        }

        public String getVersion() {
            return this.metadata == null ? "" : this.metadata.getModuleVersion();
        }

        public String getSortKey() {
            return this.getFile().getName();
        }
    }

    private class GameFolderInfo
    extends AbstractInfo {
        protected String comment;
        protected ModuleInfo moduleInfo;
        protected long dtm;

        public GameFolderInfo(File file, ModuleInfo moduleInfo) {
            super(file, ModuleManagerWindow.this.openGameFolderIcon, ModuleManagerWindow.this.closedGameFolderIcon);
            this.moduleInfo = moduleInfo;
            this.dtm = file.lastModified();
        }

        public JPopupMenu buildPopup(int n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new AbstractAction(Resources.getString("General.refresh")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    GameFolderInfo.this.refresh();
                }
            });
            jPopupMenu.addSeparator();
            jPopupMenu.add(new AbstractAction(Resources.getString("General.remove")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    MyTreeNode myTreeNode = ModuleManagerWindow.this.rootNode.findNode(GameFolderInfo.this.moduleInfo.getFile());
                    MyTreeNode myTreeNode2 = myTreeNode.findNode(GameFolderInfo.this.getFile());
                    ModuleManagerWindow.this.treeModel.removeNodeFromParent((MutableTreeTableNode)myTreeNode2);
                    GameFolderInfo.this.moduleInfo.removeFolder(GameFolderInfo.this.getFile());
                    ModuleManagerWindow.this.updateModuleList();
                }
            });
            return jPopupMenu;
        }

        public ModuleInfo getModuleInfo() {
            return this.moduleInfo;
        }

        public void refresh() {
            for (int i = this.getTreeNode().getChildCount() - 1; i >= 0; --i) {
                File[] fileArray = this.getTreeNode().getChild(i);
                SaveFileInfo saveFileInfo = (SaveFileInfo)fileArray.getNodeInfo();
                if (saveFileInfo.getFile().exists()) continue;
                ModuleManagerWindow.this.treeModel.removeNodeFromParent((MutableTreeTableNode)fileArray);
            }
            File[] fileArray = this.getFile().listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file : fileArray) {
                String string;
                AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(file);
                if (abstractMetaData == null || !(abstractMetaData instanceof SaveMetaData) || (string = ((SaveMetaData)abstractMetaData).getModuleName()) != null && string.length() != 0 && !string.equals(this.getModuleInfo().getModuleName())) continue;
                this.update(file);
            }
        }

        public void update(File file) {
            Object object;
            for (int i = 0; i < this.getTreeNode().getChildCount(); ++i) {
                object = (SaveFileInfo)this.getTreeNode().getChild(i).getNodeInfo();
                if (!object.getFile().equals(file)) continue;
                object.refresh();
                return;
            }
            SaveFileInfo saveFileInfo = new SaveFileInfo(file, this);
            object = new MyTreeNode(saveFileInfo);
            ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)object, (MutableTreeTableNode)this.getTreeNode(), this.getTreeNode().findInsertIndex(saveFileInfo));
        }

        public String getSortKey() {
            return "~~~" + this.getFile().getName();
        }
    }

    private class ExtensionInfo
    extends AbstractInfo {
        private boolean active;
        private ModuleInfo moduleInfo;
        private ExtensionMetaData metadata;

        public ExtensionInfo(File file, boolean bl, ModuleInfo moduleInfo) {
            super(file, bl ? ModuleManagerWindow.this.activeExtensionIcon : ModuleManagerWindow.this.inactiveExtensionIcon);
            this.active = bl;
            this.moduleInfo = moduleInfo;
            this.loadMetaData();
        }

        protected void loadMetaData() {
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.file);
            if (abstractMetaData != null && abstractMetaData instanceof ExtensionMetaData) {
                this.setValid(true);
                this.metadata = (ExtensionMetaData)abstractMetaData;
            } else {
                this.setError(Resources.getString("ModuleManager.invalid_extension"));
                this.setValid(false);
            }
        }

        public void refresh() {
            this.loadMetaData();
            this.setActive(this.getExtensionsManager().isExtensionActive(this.getFile()));
            ModuleManagerWindow.this.tree.repaint();
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
            this.setIcon(this.active ? ModuleManagerWindow.this.activeExtensionIcon : ModuleManagerWindow.this.inactiveExtensionIcon);
        }

        public String getVersion() {
            return this.metadata == null ? "" : this.metadata.getVersion();
        }

        public String getVassalVersion() {
            return this.metadata == null ? "" : this.metadata.getVassalVersion();
        }

        public String getDescription() {
            return this.metadata == null ? "" : this.metadata.getDescription();
        }

        public ExtensionsManager getExtensionsManager() {
            return this.moduleInfo == null ? null : this.moduleInfo.getExtensionsManager();
        }

        public String toString() {
            String string = this.getFile().getName();
            String string2 = "";
            if (this.metadata == null) {
                string2 = Resources.getString("ModuleManager.invalid");
            }
            if (!this.active) {
                string2 = string2 + (string2.length() > 0 ? "," : "");
                string2 = string2 + Resources.getString("ModuleManager.inactive");
            }
            if (string2.length() > 0) {
                string = string + " (" + string2 + ")";
            }
            return string;
        }

        public JPopupMenu buildPopup(int n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.add(new ActivateExtensionAction(Resources.getString(this.isActive() ? "ModuleManager.deactivate" : "ModuleManager.activate")));
            EditExtensionLaunchAction editExtensionLaunchAction = new EditExtensionLaunchAction(ModuleManagerWindow.this, this.getFile(), ModuleManagerWindow.this.getSelectedModule());
            editExtensionLaunchAction.setEnabled(!Info.isModuleTooNew(this.metadata.getVassalVersion()));
            jPopupMenu.add(editExtensionLaunchAction);
            return jPopupMenu;
        }

        public Color getTreeCellFgColor() {
            if (this.isActive()) {
                return this.metadata == null ? Color.red : Color.black;
            }
            return this.metadata == null ? Color.pink : Color.gray;
        }

        public String getValueAt(int n) {
            return n == 3 ? this.getDescription() : super.getValueAt(n);
        }

        public boolean isInUse() {
            return AbstractLaunchAction.isInUse(this.file) || AbstractLaunchAction.isEditing(this.file);
        }

        public String getSortKey() {
            return this.getFile().getName();
        }

        private class ActivateExtensionAction
        extends AbstractAction {
            private static final long serialVersionUID = 1L;

            public ActivateExtensionAction(String string) {
                super(string);
                this.setEnabled(!ExtensionInfo.this.isInUse() && !ExtensionInfo.this.moduleInfo.isInUse());
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ExtensionInfo.this.setFile(ExtensionInfo.this.getExtensionsManager().setActive(ExtensionInfo.this.getFile(), !ExtensionInfo.this.isActive()));
                ExtensionInfo.this.setActive(ExtensionInfo.this.getExtensionsManager().isExtensionActive(ExtensionInfo.this.getFile()));
                TreePath treePath = ModuleManagerWindow.this.tree.getPathForRow(ModuleManagerWindow.this.tree.getSelectedRow());
                MyTreeNode myTreeNode = (MyTreeNode)((Object)treePath.getLastPathComponent());
                ModuleManagerWindow.this.treeModel.setValueAt("", (Object)myTreeNode, 0);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ModuleInfo
    extends AbstractInfo {
        private ExtensionsManager extMgr;
        private SortedSet<File> gameFolders;
        private ModuleMetaData metadata;
        private Action newExtensionAction;
        private AbstractAction addExtensionAction;
        private AbstractAction addFolderAction;

        public ModuleInfo(File file) {
            super(file, ModuleManagerWindow.this.moduleIcon);
            this.gameFolders = new TreeSet<File>();
            this.newExtensionAction = new NewExtensionLaunchAction(ModuleManagerWindow.this);
            this.addExtensionAction = new AbstractAction(Resources.getString("ModuleManager.add_extension")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    FileChooser fileChooser = FileChooser.createFileChooser(ModuleManagerWindow.this, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
                    if (fileChooser.showOpenDialog() == 0) {
                        File file = fileChooser.getSelectedFile();
                        ExtensionInfo extensionInfo = new ExtensionInfo(file, true, null);
                        if (extensionInfo.isValid()) {
                            MyTreeNode myTreeNode;
                            File file2 = ModuleInfo.this.getExtensionsManager().setActive(fileChooser.getSelectedFile(), true);
                            ExtensionInfo extensionInfo2 = new ExtensionInfo(file2, true, (ModuleInfo)(myTreeNode = ModuleManagerWindow.this.rootNode.findNode(ModuleManagerWindow.this.selectedModule)).getNodeInfo());
                            if (extensionInfo2.isValid()) {
                                MyTreeNode myTreeNode2 = new MyTreeNode(extensionInfo2);
                                ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)myTreeNode2, (MutableTreeTableNode)myTreeNode, myTreeNode.findInsertIndex(extensionInfo2));
                            }
                        } else {
                            JOptionPane.showMessageDialog(null, extensionInfo.getError(), null, 0);
                        }
                    }
                }
            };
            this.addFolderAction = new AbstractAction(Resources.getString("ModuleManager.add_save_game_folder")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    FileChooser fileChooser = FileChooser.createFileChooser(ModuleManagerWindow.this, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"), 1);
                    if (fileChooser.showOpenDialog() == 0) {
                        ModuleInfo.this.addFolder(fileChooser.getSelectedFile());
                    }
                }
            };
            this.extMgr = new ExtensionsManager(file);
            this.loadMetaData();
        }

        protected void loadMetaData() {
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.file);
            if (abstractMetaData != null && abstractMetaData instanceof ModuleMetaData) {
                this.setValid(true);
                this.metadata = (ModuleMetaData)abstractMetaData;
            } else {
                this.setValid(false);
            }
        }

        protected boolean isModuleTooNew() {
            return this.metadata == null ? false : Info.isModuleTooNew(this.metadata.getVassalVersion());
        }

        @Override
        public String getVassalVersion() {
            return this.metadata == null ? "" : this.metadata.getVassalVersion();
        }

        public ModuleInfo(String string) {
            this.gameFolders = new TreeSet<File>();
            this.newExtensionAction = new NewExtensionLaunchAction(ModuleManagerWindow.this);
            this.addExtensionAction = new /* invalid duplicate definition of identical inner class */;
            this.addFolderAction = new /* invalid duplicate definition of identical inner class */;
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
            this.setFile(new File(decoder.nextToken()));
            this.setIcon(ModuleManagerWindow.this.moduleIcon);
            this.loadMetaData();
            this.extMgr = new ExtensionsManager(this.getFile());
            while (decoder.hasMoreTokens()) {
                this.gameFolders.add(new File(decoder.nextToken()));
            }
        }

        @Override
        public void refresh() {
            int n;
            this.loadMetaData();
            MyTreeNode[] myTreeNodeArray = new MyTreeNode[this.getTreeNode().getChildCount()];
            for (n = 0; n < this.getTreeNode().getChildCount(); ++n) {
                myTreeNodeArray[n] = this.getTreeNode().getChild(n);
            }
            for (n = 0; n < myTreeNodeArray.length; ++n) {
                if (myTreeNodeArray[n].getFile().exists()) continue;
                ModuleManagerWindow.this.treeModel.removeNodeFromParent((MutableTreeTableNode)myTreeNodeArray[n]);
            }
            for (ExtensionInfo extensionInfo : this.getExtensions()) {
                MyTreeNode myTreeNode = this.getTreeNode().findNode(extensionInfo.getFile());
                if (myTreeNode == null) {
                    if (!extensionInfo.isValid()) continue;
                    myTreeNode = new MyTreeNode(extensionInfo);
                    ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)myTreeNode, (MutableTreeTableNode)this.getTreeNode(), this.getTreeNode().findInsertIndex(extensionInfo));
                    continue;
                }
                myTreeNode.refresh();
            }
        }

        public String encode() {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(this.file.getPath(), ';');
            for (File file : this.gameFolders) {
                sequenceEncoder.append(file.getPath());
            }
            return sequenceEncoder.getValue();
        }

        public ExtensionsManager getExtensionsManager() {
            return this.extMgr;
        }

        public void addFolder(File file) {
            if (!file.exists() && !file.mkdirs()) {
                JOptionPane.showMessageDialog(ModuleManagerWindow.this, Resources.getString("Install.error_unable_to_create", file.getPath()), "Error", 0);
                return;
            }
            this.gameFolders.add(file);
            MyTreeNode myTreeNode = ModuleManagerWindow.this.rootNode.findNode(ModuleManagerWindow.this.selectedModule);
            GameFolderInfo gameFolderInfo = new GameFolderInfo(file, (ModuleInfo)myTreeNode.getNodeInfo());
            MyTreeNode myTreeNode2 = new MyTreeNode(gameFolderInfo);
            int n = myTreeNode.findInsertIndex(gameFolderInfo);
            ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)myTreeNode2, (MutableTreeTableNode)myTreeNode, n);
            for (File file2 : file.listFiles()) {
                SaveFileInfo saveFileInfo;
                if (!file2.isFile() || !(saveFileInfo = new SaveFileInfo(file2, gameFolderInfo)).isValid() || !saveFileInfo.belongsToModule()) continue;
                MyTreeNode myTreeNode3 = new MyTreeNode(saveFileInfo);
                ModuleManagerWindow.this.treeModel.insertNodeInto((MutableTreeTableNode)myTreeNode3, (MutableTreeTableNode)myTreeNode2, myTreeNode2.findInsertIndex(saveFileInfo));
            }
            ModuleManagerWindow.this.updateModuleList();
        }

        public void removeFolder(File file) {
            this.gameFolders.remove(file);
        }

        public SortedSet<File> getFolders() {
            return this.gameFolders;
        }

        public List<ExtensionInfo> getExtensions() {
            ArrayList<ExtensionInfo> arrayList = new ArrayList<ExtensionInfo>();
            for (File file : this.extMgr.getActiveExtensions()) {
                arrayList.add(new ExtensionInfo(file, true, this));
            }
            for (File file : this.extMgr.getInactiveExtensions()) {
                arrayList.add(new ExtensionInfo(file, false, this));
            }
            Collections.sort(arrayList);
            return arrayList;
        }

        public void play() {
            new Player.LaunchAction(ModuleManagerWindow.this, this.file).actionPerformed(null);
        }

        @Override
        public JPopupMenu buildPopup(int n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            Player.LaunchAction launchAction = new Player.LaunchAction(ModuleManagerWindow.this, this.file);
            launchAction.setEnabled(!Info.isModuleTooNew(this.metadata.getVassalVersion()));
            jPopupMenu.add(launchAction);
            Editor.ListLaunchAction listLaunchAction = new Editor.ListLaunchAction(ModuleManagerWindow.this, this.file);
            listLaunchAction.setEnabled(!Info.isModuleTooNew(this.metadata.getVassalVersion()));
            jPopupMenu.add(listLaunchAction);
            jPopupMenu.add(new AbstractAction(Resources.getString("General.remove")){
                private static final long serialVersionUID = 1L;

                public void actionPerformed(ActionEvent actionEvent) {
                    ModuleManagerWindow.this.removeModule(ModuleInfo.this.file);
                    ModuleInfo.this.cleanupTileCache();
                }
            });
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.addFolderAction);
            jPopupMenu.addSeparator();
            jPopupMenu.add(this.newExtensionAction);
            jPopupMenu.add(this.addExtensionAction);
            return jPopupMenu;
        }

        public void cleanupTileCache() {
            String string = DigestUtils.shaHex((String)(this.metadata.getName() + "_" + this.metadata.getVersion()));
            File file = new File(Info.getConfDir(), "tiles/" + string);
            if (file.exists()) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException iOException) {
                    WriteErrorDialog.error(iOException, file);
                }
            }
        }

        public boolean isInUse() {
            return AbstractLaunchAction.isInUse(this.file) || AbstractLaunchAction.isEditing(this.file);
        }

        @Override
        public String getVersion() {
            return this.metadata.getVersion();
        }

        public String getLocalizedDescription() {
            return this.metadata.getLocalizedDescription();
        }

        public String getModuleName() {
            return this.metadata.getName();
        }

        @Override
        public String toString() {
            return this.metadata.getLocalizedName();
        }

        @Override
        public String getValueAt(int n) {
            return n == 3 ? this.getLocalizedDescription() : super.getValueAt(n);
        }

        @Override
        public String getSortKey() {
            return this.metadata == null ? "" : this.metadata.getLocalizedName();
        }

        @Override
        public Color getTreeCellFgColor() {
            return Info.isModuleTooNew(this.getVassalVersion()) ? Color.GRAY : Color.BLACK;
        }
    }

    private class RootInfo
    extends AbstractInfo {
        public RootInfo() {
            super(null);
        }

        public String getSortKey() {
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractInfo
    implements Comparable<AbstractInfo> {
        protected File file;
        protected Icon openIcon;
        protected Icon closedIcon;
        protected boolean valid = true;
        protected String error = "";
        protected MyTreeNode node;

        public AbstractInfo(File file, Icon icon, Icon icon2) {
            this.setFile(file);
            this.setIcon(icon, icon2);
        }

        public AbstractInfo(File file, Icon icon) {
            this(file, icon, icon);
        }

        public AbstractInfo(File file) {
            this(file, null);
        }

        public AbstractInfo() {
        }

        public String toString() {
            return this.file == null ? "" : this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            if (file == null) {
                return;
            }
            try {
                this.file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                this.file = file.getAbsoluteFile();
            }
        }

        public String getToolTipText() {
            if (this.file == null) {
                return "";
            }
            return this.file.getPath();
        }

        @Override
        public int compareTo(AbstractInfo abstractInfo) {
            return this.getSortKey().compareTo(abstractInfo.getSortKey());
        }

        public JPopupMenu buildPopup(int n) {
            return null;
        }

        public Icon getIcon(boolean bl) {
            return bl ? this.openIcon : this.closedIcon;
        }

        public void setIcon(Icon icon) {
            this.setIcon(icon, icon);
        }

        public void setIcon(Icon icon, Icon icon2) {
            this.openIcon = icon;
            this.closedIcon = icon2;
        }

        public String getValueAt(int n) {
            switch (n) {
                case 0: {
                    return this.toString();
                }
                case 1: {
                    return this.getVersion();
                }
                case 2: {
                    return this.getVassalVersion();
                }
            }
            return null;
        }

        public void setValid(boolean bl) {
            this.valid = bl;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setError(String string) {
            this.error = string;
        }

        public String getError() {
            return this.error;
        }

        public String getVersion() {
            return "";
        }

        public String getVassalVersion() {
            return "";
        }

        public String getComments() {
            return "";
        }

        public MyTreeNode getTreeNode() {
            return this.node;
        }

        public void setTreeNode(MyTreeNode myTreeNode) {
            this.node = myTreeNode;
        }

        public abstract String getSortKey();

        public Color getTreeCellFgColor() {
            return Color.black;
        }

        public void refresh() {
            this.refreshChildren();
        }

        public void refreshChildren() {
            for (int i = 0; i < this.node.getChildCount(); ++i) {
                this.node.getChild(i).refresh();
            }
        }
    }

    private static class MyTreeNode
    extends DefaultMutableTreeTableNode {
        public MyTreeNode(AbstractInfo abstractInfo) {
            super((Object)abstractInfo);
            abstractInfo.setTreeNode(this);
        }

        public AbstractInfo getNodeInfo() {
            return (AbstractInfo)this.getUserObject();
        }

        public File getFile() {
            return this.getNodeInfo().getFile();
        }

        public void refresh() {
            this.getNodeInfo().refresh();
        }

        public void setValueAt(Object object, int n) {
        }

        public Object getValueAt(int n) {
            return this.getNodeInfo().getValueAt(n);
        }

        public MyTreeNode getChild(int n) {
            return (MyTreeNode)super.getChildAt(n);
        }

        public MyTreeNode findNode(File file) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                MyTreeNode myTreeNode = this.getChild(i);
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException iOException) {
                    file = file.getAbsoluteFile();
                }
                if (!file.equals(myTreeNode.getNodeInfo().getFile())) continue;
                return myTreeNode;
            }
            return null;
        }

        public boolean contains(File file) {
            return this.findNode(file) != null;
        }

        public int findInsertIndex(AbstractInfo abstractInfo) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                MyTreeNode myTreeNode = this.getChild(i);
                if (myTreeNode.getNodeInfo().compareTo(abstractInfo) < 0) continue;
                return i;
            }
            return this.getChildCount();
        }

        public MyTreeNode getParentModuleNode() {
            AbstractInfo abstractInfo = this.getNodeInfo();
            if (abstractInfo instanceof RootInfo) {
                return null;
            }
            if (abstractInfo instanceof ModuleInfo) {
                return this;
            }
            if ((MyTreeNode)this.getParent() == null) {
                return null;
            }
            return ((MyTreeNode)this.getParent()).getParentModuleNode();
        }

        public File getParentModuleFile() {
            MyTreeNode myTreeNode = this.getParentModuleNode();
            return myTreeNode == null ? null : myTreeNode.getFile();
        }
    }

    private static class VersionCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        public VersionCellRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    private static class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            AbstractInfo abstractInfo = ((MyTreeNode)((Object)object)).getNodeInfo();
            this.setText(abstractInfo.toString());
            this.setToolTipText(abstractInfo.getToolTipText());
            this.setIcon(abstractInfo.getIcon(bl2));
            this.setForeground(abstractInfo.getTreeCellFgColor());
            return this;
        }
    }

    private static class MyTree
    extends JXTreeTable {
        private static final long serialVersionUID = 1L;

        public MyTree(MyTreeTableModel myTreeTableModel) {
            super((TreeTableModel)myTreeTableModel);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            if (this.getComponentAt(mouseEvent.getPoint().x, mouseEvent.getPoint().y) == null) {
                return null;
            }
            return super.getToolTipText(mouseEvent);
        }
    }

    private static class MyTreeTableModel
    extends DefaultTreeTableModel {
        public MyTreeTableModel(MyTreeNode myTreeNode) {
            super((TreeTableNode)myTreeNode);
            columnHeadings[0] = Resources.getString("ModuleManager.module");
            columnHeadings[1] = Resources.getString("ModuleManager.version");
            columnHeadings[2] = Resources.getString("ModuleManager.vassal_version");
            columnHeadings[3] = Resources.getString("ModuleManager.description");
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            return columnHeadings[n];
        }

        public Object getValueAt(Object object, int n) {
            return ((MyTreeNode)((Object)object)).getValueAt(n);
        }
    }
}

