/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class StringArrayConfigurer
extends Configurer {
    protected JPanel panel;
    protected JList list;
    protected DefaultListModel model;
    private static final String[] EMPTY = new String[0];
    protected JTextField textField;

    public StringArrayConfigurer(String string, String string2, Object object) {
        super(string, string2, object);
    }

    public StringArrayConfigurer(String string, String string2) {
        super(string, string2);
    }

    public DefaultListModel getModel() {
        return this.model;
    }

    public void addValue(String string) {
        String[] stringArray;
        if (this.value == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        } else {
            stringArray = ArrayUtils.append((String[])this.value, string);
        }
        this.setValue(stringArray);
    }

    public void removeValue(String string) {
        String[] stringArray;
        String[] stringArray2 = this.getStringArray();
        if (stringArray2 != (stringArray = ArrayUtils.remove(stringArray2, string))) {
            this.setValue(stringArray);
        }
    }

    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setBorder(new TitledBorder(this.name));
            this.panel.setLayout(new MigLayout("fill"));
            Box box = Box.createHorizontalBox();
            Box box2 = Box.createVerticalBox();
            this.model = new DefaultListModel();
            this.updateModel();
            this.list = new JList(this.model);
            this.list.setPrototypeCellValue("MMMMMMMM");
            this.list.setVisibleRowCount(2);
            this.list.setSelectionMode(0);
            JButton jButton = new JButton(Resources.getString("General.add"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = StringArrayConfigurer.this.getTextValue();
                    StringArrayConfigurer.this.addValue(string);
                    StringArrayConfigurer.this.setTextValue("");
                }
            });
            box.add(jButton);
            JButton jButton2 = new JButton(Resources.getString("General.remove"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Object[] objectArray = StringArrayConfigurer.this.list.getSelectedValues();
                    for (int i = 0; i < objectArray.length; ++i) {
                        StringArrayConfigurer.this.removeValue((String)objectArray[i]);
                    }
                }
            });
            box.add(jButton2);
            JButton jButton3 = new JButton(Resources.getString("General.insert"));
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (StringArrayConfigurer.this.value == null) {
                        StringArrayConfigurer.this.addValue(StringArrayConfigurer.this.getTextValue());
                    } else {
                        int n = StringArrayConfigurer.this.list.getSelectedIndex();
                        if (n < 0) {
                            n = StringArrayConfigurer.this.list.getModel().getSize();
                        }
                        StringArrayConfigurer.this.setValue(ArrayUtils.insert((String[])StringArrayConfigurer.this.value, n, StringArrayConfigurer.this.getTextValue()));
                        StringArrayConfigurer.this.setTextValue("");
                        StringArrayConfigurer.this.list.setSelectedIndex(n + 1);
                    }
                }
            };
            jButton3.addActionListener(actionListener);
            box.add(jButton3);
            Component component = this.getTextComponent();
            this.addTextActionListener(actionListener);
            box2.add(component);
            box2.add(box);
            JSplitPane jSplitPane = new JSplitPane(1);
            jSplitPane.setLeftComponent(box2);
            jSplitPane.setRightComponent(new ScrollPane(this.list));
            this.panel.add((Component)jSplitPane, "grow");
        }
        return this.panel;
    }

    protected Component getTextComponent() {
        if (this.textField == null) {
            this.textField = new JTextField(8);
            this.textField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.textField.getPreferredSize().height));
        }
        return this.textField;
    }

    protected String getTextValue() {
        return this.textField.getText();
    }

    protected void setTextValue(String string) {
        this.textField.setText(string);
    }

    protected void addTextActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    public String[] getStringArray() {
        if (this.value instanceof String[]) {
            return (String[])this.value;
        }
        return EMPTY;
    }

    public String getValueString() {
        return StringArrayConfigurer.arrayToString(this.getStringArray());
    }

    public static String arrayToString(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < stringArray.length; ++i) {
            sequenceEncoder.append(stringArray[i] != null ? stringArray[i] : "");
        }
        return sequenceEncoder.getValue();
    }

    public void setValue(Object stringArray) {
        if (stringArray == null) {
            stringArray = EMPTY;
        }
        super.setValue(stringArray);
        this.updateModel();
    }

    public void setValue(String string) {
        String[] stringArray = StringArrayConfigurer.stringToArray(string);
        this.setValue(stringArray);
    }

    public static String[] stringToArray(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        ArrayList<String> arrayList = new ArrayList<String>();
        while (decoder.hasMoreTokens()) {
            arrayList.add(decoder.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected void updateModel() {
        if (this.model != null) {
            this.model.removeAllElements();
            String[] stringArray = this.getStringArray();
            for (int i = 0; i < stringArray.length; ++i) {
                this.model.addElement(stringArray[i]);
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        final StringArrayConfigurer stringArrayConfigurer = new StringArrayConfigurer(null, "Visible to these players:  ");
        stringArrayConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                System.err.println(stringArrayConfigurer.getName() + " = " + stringArrayConfigurer.getValueString());
            }
        });
        stringArrayConfigurer.setValue("Rack,Shack,Benny");
        jFrame.add(stringArrayConfigurer.getControls());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

