/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.command.Command;
import VASSAL.command.RemovePiece;
import VASSAL.counters.GamePiece;

public class AddPiece
extends Command {
    private Command undo;
    private GamePiece target;
    private String state;

    public AddPiece(GamePiece gamePiece) {
        this(gamePiece, gamePiece.getState());
    }

    public AddPiece(GamePiece gamePiece, String string) {
        this.target = gamePiece;
        this.state = string;
    }

    protected void executeCommand() {
        if (this.target != null) {
            GameModule.getGameModule().getGameState().addPiece(this.target);
            this.target.setState(this.state);
            if (this.target.getMap() != null) {
                HighlightLastMoved.setLastMoved(this.target);
                if (GlobalOptions.getInstance().centerOnOpponentsMove() && !Boolean.TRUE.equals(this.target.getProperty("Invisible"))) {
                    this.target.getMap().ensureVisible(this.target.getMap().selectionBoundsOf(this.target));
                    this.target.getMap().repaint();
                }
            }
        }
    }

    protected Command myUndoCommand() {
        if (this.undo == null) {
            this.undo = new RemovePiece(this.target);
        }
        return this.undo;
    }

    public GamePiece getTarget() {
        return this.target;
    }

    public String getState() {
        return this.state;
    }
}

