/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatter;
import VASSAL.i18n.Resources;
import VASSAL.tools.menu.MenuManager;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class PrivateChatManager {
    private ChatServerConnection client;
    private List<Entry> chatters = new ArrayList<Entry>();
    private List<Player> banned = new ArrayList<Player>();

    public PrivateChatManager(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
    }

    public PrivateChatter getChatterFor(final Player player) {
        if (this.banned.contains(player)) {
            return null;
        }
        PrivateChatter privateChatter = null;
        int n = this.chatters.indexOf(new Entry(player, null));
        if (n >= 0) {
            privateChatter = this.chatters.get(n).chatter;
        }
        if (privateChatter == null) {
            privateChatter = new PrivateChatter(player, this.client);
            this.chatters.add(new Entry(player, privateChatter));
            JFrame jFrame = new JFrame();
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    PrivateChatManager.this.promptToBan(player);
                }
            });
            jFrame.setTitle(Resources.getString("Chat.private_channel", player.getName()));
            jFrame.setJMenuBar(MenuManager.getInstance().getMenuBarFor(jFrame));
            jFrame.getContentPane().add(privateChatter);
            jFrame.pack();
            jFrame.setLocation(Toolkit.getDefaultToolkit().getScreenSize().width / 2 - jFrame.getSize().width / 2, 0);
        }
        return privateChatter;
    }

    private void promptToBan(Player player) {
        if (0 == JOptionPane.showConfirmDialog(null, Resources.getString("Chat.ignore_messages", player.getName()), null, 0)) {
            this.banned.add(player);
        }
    }

    private static class Entry {
        private Player player;
        private PrivateChatter chatter;

        private Entry(Player player, PrivateChatter privateChatter) {
            if (player == null) {
                throw new NullPointerException();
            }
            this.player = player;
            this.chatter = privateChatter;
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                return this.player.equals(((Entry)object).player);
            }
            return false;
        }
    }
}

