/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionMetaData
extends AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionMetaData.class);
    public static final String ZIP_ENTRY_NAME = "extensiondata";
    public static final String DATA_VERSION = "1";
    protected static final String UNIVERSAL_ELEMENT = "universal";
    protected static final String UNIVERSAL_ATTR = "anyModule";
    protected ModuleMetaData moduleData;
    protected boolean universal;

    public ExtensionMetaData(ModuleExtension moduleExtension) {
        this.setVersion(moduleExtension.getVersion());
        this.setDescription(new AbstractMetaData.Attribute("description", moduleExtension.getDescription()));
        this.universal = moduleExtension.getUniversal();
    }

    public ExtensionMetaData(ZipFile zipFile) {
        this.read(zipFile);
    }

    public String getModuleName() {
        return this.moduleData == null ? "" : this.moduleData.getName();
    }

    public String getModuleVersion() {
        return this.moduleData == null ? "" : this.moduleData.getVersion();
    }

    public String getZipEntryName() {
        return ZIP_ENTRY_NAME;
    }

    public String getMetaDataVersion() {
        return DATA_VERSION;
    }

    public void save(ArchiveWriter archiveWriter) throws IOException {
        super.save(archiveWriter);
        this.copyModuleMetadata(archiveWriter);
    }

    protected void addElements(Document document, Element element) {
        Element element2 = document.createElement(UNIVERSAL_ELEMENT);
        element2.appendChild(document.createTextNode(String.valueOf(this.universal)));
        element.appendChild(element2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zipFile) {
        try {
            Object object;
            DefaultHandler defaultHandler = null;
            ZipEntry zipEntry = zipFile.getEntry(this.getZipEntryName());
            if (zipEntry == null) {
                zipEntry = zipFile.getEntry("buildFile");
                defaultHandler = new ExtensionBuildFileXMLHandler();
            } else {
                defaultHandler = new MetadataXMLHandler();
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                object = parser;
                synchronized (object) {
                    parser.setContentHandler(defaultHandler);
                    parser.setDTDHandler(defaultHandler);
                    parser.setEntityResolver(defaultHandler);
                    parser.setErrorHandler(defaultHandler);
                    parser.parse(new InputSource(bufferedInputStream));
                }
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
            object = this.moduleData;
            this.moduleData = new ModuleMetaData(zipFile);
            if (this.moduleData == null) {
                this.moduleData = object;
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
        catch (AbstractMetaData.SAXEndException sAXEndException) {
        }
        catch (SAXException sAXException) {
            logger.error("", (Throwable)sAXException);
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
    }

    private class ExtensionBuildFileXMLHandler
    extends AbstractMetaData.BuildFileXMLHandler {
        private ExtensionBuildFileXMLHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws AbstractMetaData.SAXEndException {
            super.startElement(string, string2, string3, attributes);
            if ("VASSAL.build.module.ModuleExtension".equals(string3)) {
                ExtensionMetaData.this.setVersion(this.getAttr(attributes, "version"));
                ExtensionMetaData.this.setVassalVersion(this.getAttr(attributes, "vassalVersion"));
                ExtensionMetaData.this.setDescription(this.getAttr(attributes, "description"));
                ExtensionMetaData.this.universal = "true".equals(this.getAttr(attributes, ExtensionMetaData.UNIVERSAL_ATTR));
                String string4 = this.getAttr(attributes, "moduleName");
                String string5 = this.getAttr(attributes, "moduleVersion");
                ExtensionMetaData.this.moduleData = new ModuleMetaData(string4, string5);
                throw new AbstractMetaData.SAXEndException();
            }
        }
    }

    private class MetadataXMLHandler
    extends AbstractMetaData.XMLHandler {
        private MetadataXMLHandler() {
        }

        public void endElement(String string, String string2, String string3) {
            if (ExtensionMetaData.UNIVERSAL_ELEMENT.equals(string3)) {
                ExtensionMetaData.this.universal = "true".equals(this.accumulator.toString().trim());
            } else {
                super.endElement(string, string2, string3);
            }
        }
    }
}

