/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorManager;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBoxItemInstance
extends ItemInstance {
    protected static final String VALUE = "value";
    protected static final String BG_COLOR = "borderColor";
    protected String val = "";
    private VisibilityCondition valueCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return !((TextItem)TextBoxItemInstance.this.getItem()).isFixed();
        }
    };

    public TextBoxItemInstance() {
        this.setFgColor(ColorSwatch.getBlack());
        this.setBgColor(ColorManager.getColorManager().getColorSwatch(Color.LIGHT_GRAY));
    }

    public TextBoxItemInstance(String string, GamePieceImage gamePieceImage) {
        super(gamePieceImage);
        this.decode(string);
    }

    public TextBoxItemInstance(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setFgColor(ColorSwatch.getBlack());
        this.setBgColor(ColorManager.getColorManager().getColorSwatch(Color.LIGHT_GRAY));
    }

    public void setValue(String string) {
        this.val = string;
    }

    public String getValue() {
        return this.val;
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getType());
        sequenceEncoder.append(this.getName());
        sequenceEncoder.append(this.getLocation());
        sequenceEncoder.append(this.getFgColor().encode());
        sequenceEncoder.append(this.getBgColor().encode());
        sequenceEncoder.append(this.getValue());
        return sequenceEncoder.getValue();
    }

    public void decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.setType(decoder.nextToken(""));
        this.setName(decoder.nextToken(""));
        this.setLocation(decoder.nextToken(""));
        this.setFgColor(new ColorSwatch(decoder.nextToken("")));
        this.setBgColor(new ColorSwatch(decoder.nextToken("")));
        this.setValue(decoder.nextToken(""));
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Value:  ", "Text Color:  ", "Background Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{WrappingTextConfigurer.class, FgColorSwatchConfig.class, BgColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{VALUE, "fgColor", BG_COLOR};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (VALUE.equals(string)) {
            this.val = (String)object;
        } else if ("fgColor".equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.fgColor = (ColorSwatch)object;
        } else if (BG_COLOR.equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.bgColor = (ColorSwatch)object;
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (VALUE.equals(string)) {
            return this.val;
        }
        if ("fgColor".equals(string)) {
            return this.fgColor.encode();
        }
        if (BG_COLOR.equals(string)) {
            return this.bgColor.encode();
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (VALUE.equals(string)) {
            return this.valueCond;
        }
        return super.getAttributeVisibility(string);
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((ItemInstance)autoConfigurable).getBgColor());
        }
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((ItemInstance)autoConfigurable).getFgColor());
        }
    }

    public static class WrappingTextConfigurer
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new TextConfigurer(string, string2, ((TextBoxItemInstance)autoConfigurable).val, true);
        }
    }
}

