/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.Map;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.command.AddPiece;
import VASSAL.command.AlertCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.CommandFilter;
import VASSAL.command.ConditionalCommand;
import VASSAL.command.NullCommand;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.launch.Launcher;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.LogAndSaveFileFilter;
import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ObfuscatingOutputStream;
import VASSAL.tools.io.ZipArchive;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.Dialogs;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.jdesktop.swingworker.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameState
implements CommandEncoder {
    private static final Logger log = LoggerFactory.getLogger(GameState.class);
    protected java.util.Map<String, GamePiece> pieces = new HashMap<String, GamePiece>();
    protected List<GameComponent> gameComponents = new ArrayList<GameComponent>();
    protected List<GameSetupStep> setupSteps = new ArrayList<GameSetupStep>();
    protected Action loadGame;
    protected Action saveGame;
    protected Action saveGameAs;
    protected Action newGame;
    protected Action closeGame;
    protected String lastSave;
    protected File lastSaveFile = null;
    protected DirectoryConfigurer savedGameDirectoryPreference;
    protected String loadComments;
    private boolean gameStarting = false;
    private boolean gameStarted = false;
    private volatile boolean gameUpdating = false;
    public static final String SAVEFILE_ZIP_ENTRY = "savedGame";
    public static final String BEGIN_SAVE = "begin_save";
    public static final String END_SAVE = "end_save";

    public void addTo(GameModule gameModule) {
        this.loadGame = new AbstractAction(Resources.getString("GameState.load_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.loadGame();
            }
        };
        this.loadGame.putValue("MnemonicKey", Resources.getString("GameState.load_game.shortcut").charAt(0));
        this.saveGame = new AbstractAction(Resources.getString("GameState.save_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.saveGame();
            }
        };
        this.saveGame.putValue("MnemonicKey", Resources.getString("GameState.save_game.shortcut").charAt(0));
        this.saveGameAs = new AbstractAction(Resources.getString("GameState.save_game_as")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.saveGameAs();
            }
        };
        this.saveGameAs.putValue("MnemonicKey", Resources.getString("GameState.save_game_as.shortcut").charAt(0));
        this.newGame = new AbstractAction(Resources.getString("GameState.new_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.setup(false);
                GameState.this.setup(true);
            }
        };
        this.newGame.putValue("MnemonicKey", Resources.getString("GameState.new_game.shortcut").charAt(0));
        this.closeGame = new AbstractAction(Resources.getString("GameState.close_game")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                GameState.this.setup(false);
            }
        };
        this.closeGame.putValue("MnemonicKey", Resources.getString("GameState.close_game.shortcut").charAt(0));
        MenuManager menuManager = MenuManager.getInstance();
        menuManager.addAction("GameState.new_game", this.newGame);
        menuManager.addAction("GameState.load_game", this.loadGame);
        menuManager.addAction("GameState.save_game", this.saveGame);
        menuManager.addAction("GameState.save_game_as", this.saveGameAs);
        menuManager.addAction("GameState.close_game", this.closeGame);
        this.saveGame.setEnabled(this.gameStarting);
        this.saveGameAs.setEnabled(this.gameStarting);
        this.closeGame.setEnabled(this.gameStarting);
    }

    public boolean isModified() {
        String string = this.saveString();
        return string != null && !string.equals(this.lastSave);
    }

    public void addGameComponent(GameComponent gameComponent) {
        this.gameComponents.add(gameComponent);
    }

    public void removeGameComponent(GameComponent gameComponent) {
        this.gameComponents.remove(gameComponent);
    }

    @Deprecated
    public Enumeration<GameComponent> getGameComponentsEnum() {
        return Collections.enumeration(this.gameComponents);
    }

    public Collection<GameComponent> getGameComponents() {
        return Collections.unmodifiableCollection(this.gameComponents);
    }

    public void addGameSetupStep(GameSetupStep gameSetupStep) {
        this.setupSteps.add(gameSetupStep);
    }

    public void removeGameSetupStep(GameSetupStep gameSetupStep) {
        this.setupSteps.remove(gameSetupStep);
    }

    public Iterator<GameSetupStep> getUnfinishedSetupSteps() {
        ArrayList<GameSetupStep> arrayList = new ArrayList<GameSetupStep>();
        for (GameSetupStep gameSetupStep : this.setupSteps) {
            if (gameSetupStep.isFinished()) continue;
            arrayList.add(gameSetupStep);
        }
        return arrayList.iterator();
    }

    public void setup(boolean bl, boolean bl2) {
        this.gameUpdating = bl2;
        this.setup(bl);
    }

    public void updateDone() {
        this.gameUpdating = false;
    }

    public boolean isUpdating() {
        return this.gameUpdating;
    }

    public void setup(boolean bl) {
        if (!bl && this.gameStarted && this.isModified()) {
            switch (JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("GameState.save_game_query"), Resources.getString("GameState.game_modified"), 1)) {
                case 0: {
                    this.saveGame();
                    break;
                }
                case -1: 
                case 2: {
                    return;
                }
            }
        }
        this.gameStarting = bl;
        if (!bl) {
            this.pieces.clear();
        }
        this.newGame.setEnabled(!bl);
        this.saveGame.setEnabled(bl);
        this.saveGameAs.setEnabled(bl);
        this.closeGame.setEnabled(bl);
        if (bl) {
            this.loadGame.putValue("Name", Resources.getString("GameState.load_continuation"));
            GameModule.getGameModule().getWizardSupport().showGameSetupWizard();
        } else {
            this.loadGame.putValue("Name", Resources.getString("GameState.load_game"));
            GameModule.getGameModule().appendToTitle(null);
        }
        this.gameStarted &= this.gameStarting;
        for (GameComponent gameComponent : this.gameComponents) {
            gameComponent.setup(this.gameStarting);
        }
        this.gameStarted |= this.gameStarting;
        this.lastSave = bl ? this.saveString() : null;
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public void loadGame() {
        GameModule gameModule = GameModule.getGameModule();
        this.loadComments = "";
        FileChooser fileChooser = gameModule.getFileChooser();
        fileChooser.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (fileChooser.showOpenDialog() != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        try {
            if (!file.exists()) {
                throw new FileNotFoundException("Unable to locate " + file.getPath());
            }
            AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(file);
            if (abstractMetaData == null || !(abstractMetaData instanceof SaveMetaData)) {
                WarningDialog.show("GameState.invalid_save_file", file.getPath());
                return;
            }
            SaveMetaData saveMetaData = (SaveMetaData)abstractMetaData;
            String string = "?";
            if (saveMetaData.getModuleData() != null) {
                this.loadComments = saveMetaData.getLocalizedDescription();
                String string2 = saveMetaData.getModuleName();
                string = saveMetaData.getModuleVersion();
                String string3 = gameModule.getGameName();
                String string4 = gameModule.getGameVersion();
                String string5 = null;
                if (!string2.equals(string3)) {
                    string5 = Resources.getString("GameState.load_module_mismatch", file.getName(), string2, string3);
                } else if (!string.equals(string4)) {
                    string5 = Resources.getString("GameState.load_version_mismatch", file.getName(), string, string4);
                }
                if (string5 != null && JOptionPane.showConfirmDialog(null, string5, Resources.getString("GameState.load_mismatch"), 0, 3) != 0) {
                    gameModule.warn(Resources.getString("GameState.cancel_load", file.getName()));
                    return;
                }
            }
            log.info("Loading save game " + file.getPath() + ", created with module version " + string);
            if (this.gameStarted) {
                this.loadContinuation(file);
            } else {
                this.loadGameInBackground(file);
            }
            this.lastSaveFile = file;
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, file);
        }
    }

    protected String saveString() {
        return GameModule.getGameModule().encode(this.getRestoreCommand());
    }

    protected boolean checkForOldSaveFile(File file) {
        AbstractMetaData abstractMetaData;
        if (file.exists() && (abstractMetaData = MetaDataFactory.buildMetaData(file)) != null && abstractMetaData instanceof SaveMetaData && Info.hasOldFormat(abstractMetaData.getVassalVersion())) {
            return Dialogs.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("Warning.save_will_be_updated_title"), Resources.getString("Warning.save_will_be_updated_heading"), Resources.getString("Warning.save_will_be_updated_message", file.getPath(), "3.2"), 2, 2) != 2;
        }
        return true;
    }

    public void saveGame() {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.warn(Resources.getString("GameState.saving_game"));
        if (this.lastSaveFile != null) {
            if (!this.checkForOldSaveFile(this.lastSaveFile)) {
                return;
            }
            try {
                this.saveGame(this.lastSaveFile);
                gameModule.warn(Resources.getString("GameState.game_saved"));
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, this.lastSaveFile);
            }
        } else {
            this.saveGameAs();
        }
    }

    public void saveGameAs() {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.warn(Resources.getString("GameState.saving_game"));
        File file = this.getSaveFile();
        if (file == null) {
            gameModule.warn(Resources.getString("GameState.save_canceled"));
        } else {
            if (!this.checkForOldSaveFile(file)) {
                return;
            }
            try {
                this.saveGame(file);
                this.lastSaveFile = file;
                gameModule.warn(Resources.getString("GameState.game_saved"));
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, file);
            }
        }
    }

    public void setModified(boolean bl) {
        this.lastSave = bl ? null : this.saveString();
    }

    private File getSaveFile() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.selectDotSavFile();
        fileChooser.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (fileChooser.showSaveDialog() != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        if (file.getName().indexOf(46) == -1) {
            file = new File(file.getParent(), file.getName() + ".vsav");
        }
        return file;
    }

    public void addPiece(GamePiece gamePiece) {
        if (gamePiece.getId() == null) {
            gamePiece.setId(this.getNewPieceId());
        }
        this.pieces.put(gamePiece.getId(), gamePiece);
    }

    public GamePiece getPieceForId(String string) {
        return string == null ? null : this.pieces.get(string);
    }

    public void removePiece(String string) {
        if (string != null) {
            this.pieces.remove(string);
        }
    }

    public String getNewPieceId() {
        long l = System.currentTimeMillis();
        String string = Long.toString(l);
        while (this.pieces.get(string) != null) {
            string = Long.toString(++l);
        }
        return string;
    }

    public void loadContinuation(File file) throws IOException {
        GameModule.getGameModule().warn(Resources.getString("GameState.loading", file.getName()));
        Command command = this.decodeSavedGame(file);
        CommandFilter commandFilter = new CommandFilter(){

            protected boolean accept(Command command) {
                return command instanceof BasicLogger.LogCommand;
            }
        };
        command = commandFilter.apply(command);
        if (command != null) {
            command.execute();
        }
        String string = Resources.getString("GameState.loaded", file.getName());
        if (this.loadComments != null && this.loadComments.length() > 0) {
            string = string + ": " + this.loadComments;
        }
        GameModule.getGameModule().warn(string);
    }

    @Deprecated
    public Enumeration<GamePiece> getPieces() {
        return Collections.enumeration(this.pieces.values());
    }

    public Collection<GamePiece> getAllPieces() {
        return this.pieces.values();
    }

    public Command getRestoreCommand() {
        if (!this.saveGame.isEnabled()) {
            return null;
        }
        SetupCommand setupCommand = new SetupCommand(false);
        setupCommand.append(this.checkVersionCommand());
        setupCommand.append(this.getRestorePiecesCommand());
        for (GameComponent gameComponent : this.gameComponents) {
            setupCommand.append(gameComponent.getRestoreCommand());
        }
        setupCommand.append(new SetupCommand(true));
        return setupCommand;
    }

    private Command checkVersionCommand() {
        String string = GameModule.getGameModule().getAttributeValueString("runningVassalVersion");
        ConditionalCommand.Lt lt = new ConditionalCommand.Lt("runningVassalVersion", string);
        ConditionalCommand conditionalCommand = new ConditionalCommand(new ConditionalCommand.Condition[]{lt}, new AlertCommand(Resources.getString("GameState.version_mismatch", string)));
        String string2 = GameModule.getGameModule().getAttributeValueString("name");
        String string3 = GameModule.getGameModule().getAttributeValueString("version");
        lt = new ConditionalCommand.Lt("version", string3);
        conditionalCommand.append(new ConditionalCommand(new ConditionalCommand.Condition[]{lt}, new AlertCommand(Resources.getString("GameState.version_mismatch2", string2, string3))));
        return conditionalCommand;
    }

    @Override
    public String encode(Command command) {
        if (command instanceof SetupCommand) {
            return ((SetupCommand)command).isGameStarting() ? END_SAVE : BEGIN_SAVE;
        }
        return null;
    }

    @Override
    public Command decode(String string) {
        if (BEGIN_SAVE.equals(string)) {
            return new SetupCommand(false);
        }
        if (END_SAVE.equals(string)) {
            return new SetupCommand(true);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame(File file) throws IOException {
        String string = this.saveString();
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        ObfuscatingOutputStream obfuscatingOutputStream = null;
        try {
            obfuscatingOutputStream = new ObfuscatingOutputStream(fastByteArrayOutputStream);
            ((OutputStream)obfuscatingOutputStream).write(string.getBytes("UTF-8"));
            ((OutputStream)obfuscatingOutputStream).close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(obfuscatingOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)obfuscatingOutputStream);
        ZipArchive zipArchive = null;
        try {
            zipArchive = new ZipArchive(file);
            zipArchive.add(SAVEFILE_ZIP_ENTRY, fastByteArrayOutputStream.toInputStream());
            new SaveMetaData().save(zipArchive);
            zipArchive.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipArchive);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)zipArchive);
        Launcher.getInstance().sendSaveCmd(file);
        this.setModified(false);
    }

    public void loadGameInBackground(File file) {
        try {
            this.loadGameInBackground(file.getName(), new BufferedInputStream(new FileInputStream(file)));
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, file);
        }
    }

    public void loadGameInBackground(final String string, final InputStream inputStream) {
        GameModule.getGameModule().warn(Resources.getString("GameState.loading", string));
        final JFrame jFrame = GameModule.getGameModule().getFrame();
        jFrame.setCursor(Cursor.getPredefinedCursor(3));
        new SwingWorker<Command, Void>(){

            public Command doInBackground() throws Exception {
                try {
                    Command command = GameState.this.decodeSavedGame(inputStream);
                    return command;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void done() {
                try {
                    Command command = null;
                    String string2 = null;
                    try {
                        command = (Command)this.get();
                        if (command != null) {
                            string2 = Resources.getString("GameState.loaded", string);
                            if (GameState.this.loadComments != null && GameState.this.loadComments.length() > 0) {
                                string2 = string2 + ": " + GameState.this.loadComments;
                            }
                        } else {
                            string2 = Resources.getString("GameState.invalid_savefile", string);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        ErrorDialog.bug(interruptedException);
                    }
                    catch (ExecutionException executionException) {
                        OutOfMemoryError outOfMemoryError = ThrowableUtils.getAncestor(OutOfMemoryError.class, executionException);
                        if (outOfMemoryError != null) {
                            ErrorDialog.bug(executionException);
                        } else {
                            log.error("", (Throwable)executionException);
                        }
                        string2 = Resources.getString("GameState.error_loading", string);
                    }
                    if (command != null) {
                        command.execute();
                    }
                    GameModule.getGameModule().warn(string2);
                    VASSAL.command.Logger logger = GameModule.getGameModule().getLogger();
                    if (logger instanceof BasicLogger) {
                        ((BasicLogger)logger).queryNewLogFile(true);
                    }
                }
                finally {
                    jFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }.execute();
    }

    public Command getRestorePiecesCommand() {
        ArrayList<GamePiece> arrayList = new ArrayList<GamePiece>(this.pieces.values());
        Collections.sort(arrayList, new Comparator<GamePiece>(){
            private final java.util.Map<GamePiece, Integer> indices = new HashMap<GamePiece, Integer>();

            private int indexOf(GamePiece gamePiece, Map map) {
                Integer n = this.indices.get(gamePiece);
                if (n == null) {
                    n = map.getPieceCollection().indexOf(gamePiece);
                    this.indices.put(gamePiece, n);
                }
                return n;
            }

            @Override
            public int compare(GamePiece gamePiece, GamePiece gamePiece2) {
                Map map = gamePiece.getMap();
                Map map2 = gamePiece2.getMap();
                if (map == null) {
                    return map2 == null ? gamePiece.getId().compareTo(gamePiece2.getId()) : -1;
                }
                if (map2 == null) {
                    return 1;
                }
                if (map == map2) {
                    return this.indexOf(gamePiece, map) - this.indexOf(gamePiece2, map2);
                }
                return map.getId().compareTo(map2.getId());
            }
        });
        NullCommand nullCommand = new NullCommand();
        for (GamePiece gamePiece : arrayList) {
            nullCommand.append(new AddPiece(gamePiece));
        }
        return nullCommand;
    }

    public Command decodeSavedGame(File file) throws IOException {
        return this.decodeSavedGame(new BufferedInputStream(new FileInputStream(file)));
    }

    /*
     * Exception decompiling
     */
    public Command decodeSavedGame(InputStream var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DirectoryConfigurer getSavedGameDirectoryPreference() {
        if (this.savedGameDirectoryPreference == null) {
            this.savedGameDirectoryPreference = new DirectoryConfigurer("savedGameDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, this.savedGameDirectoryPreference);
        }
        return this.savedGameDirectoryPreference;
    }

    public static class SetupCommand
    extends Command {
        private boolean gameStarting;

        public SetupCommand(boolean bl) {
            this.gameStarting = bl;
        }

        public boolean isGameStarting() {
            return this.gameStarting;
        }

        protected void executeCommand() {
            GameModule.getGameModule().getGameState().setup(this.gameStarting);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

