/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.ContentEmitter;
import com.icl.saxon.Controller;
import com.icl.saxon.ExtendedInputSource;
import com.icl.saxon.PreviewManager;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.Stripper;
import com.icl.saxon.output.Emitter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class Builder
extends Emitter
implements ErrorHandler,
Locator,
SourceLocator {
    public static final int STANDARD_TREE = 0;
    public static final int TINY_TREE = 1;
    protected int estimatedLength;
    protected Writer errorOutput = new PrintWriter(System.err);
    protected Stripper stripper;
    protected PreviewManager previewManager = null;
    protected boolean discardComments;
    protected DocumentInfo currentDocument;
    protected ErrorHandler errorHandler = this;
    protected ErrorListener errorListener = null;
    protected boolean failed = false;
    protected boolean started = false;
    protected boolean timing = false;
    protected boolean inDTD = false;
    protected boolean lineNumbering = false;
    protected int lineNumber = -1;
    protected int columnNumber = -1;
    private long startTime;
    protected Controller controller;

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public void setRootNode(DocumentInfo documentInfo) {
        this.currentDocument = documentInfo;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public void setStripper(Stripper stripper) {
        this.stripper = stripper;
    }

    public Stripper getStripper() {
        return this.stripper;
    }

    public void setPreviewManager(PreviewManager previewManager) {
        this.previewManager = previewManager;
    }

    public void setDiscardCommentsAndPIs(boolean bl) {
        this.discardComments = bl;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public void setErrorOutput(Writer writer) {
        this.errorOutput = writer;
    }

    public DocumentInfo build(SAXSource sAXSource) throws TransformerException {
        InputSource inputSource = sAXSource.getInputSource();
        XMLReader xMLReader = sAXSource.getXMLReader();
        if (this.timing) {
            System.err.println("Building tree for " + inputSource.getSystemId() + " using " + this.getClass());
            this.startTime = new Date().getTime();
        }
        this.failed = true;
        this.started = false;
        if (sAXSource.getSystemId() != null) {
            this.setSystemId(sAXSource.getSystemId());
        } else {
            this.setSystemId(inputSource.getSystemId());
        }
        if (inputSource instanceof ExtendedInputSource) {
            this.estimatedLength = ((ExtendedInputSource)inputSource).getEstimatedLength();
            if (this.estimatedLength < 1) {
                this.estimatedLength = 4096;
            }
            if (this.estimatedLength > 1000000) {
                this.estimatedLength = 1000000;
            }
        } else {
            this.estimatedLength = 4096;
        }
        if (xMLReader == null) {
            try {
                xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            }
            catch (Exception exception) {
                throw new TransformerException(exception);
            }
        }
        ContentEmitter contentEmitter = new ContentEmitter();
        contentEmitter.setNamePool(this.namePool);
        xMLReader.setContentHandler(contentEmitter);
        xMLReader.setDTDHandler(contentEmitter);
        xMLReader.setErrorHandler(this.errorHandler);
        if (!this.discardComments) {
            try {
                xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", contentEmitter);
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                // empty catch block
            }
        }
        if (this.stripper != null) {
            contentEmitter.setEmitter(this.stripper);
            this.stripper.setUnderlyingEmitter(this);
        } else {
            contentEmitter.setEmitter(this);
        }
        try {
            xMLReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xMLReader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            throw new TransformerException("The SAX2 parser does not recognize a required namespace feature");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            throw new TransformerException("The SAX2 parser does not support a required namespace feature");
        }
        try {
            xMLReader.parse(inputSource);
        }
        catch (IOException iOException) {
            throw new TransformerException("Failure reading " + inputSource.getSystemId(), iOException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception != null && exception instanceof TransformerException) {
                throw (TransformerException)exception;
            }
            throw new TransformerException(sAXException);
        }
        if (!this.started) {
            throw new TransformerException("Source document not supplied");
        }
        if (this.failed) {
            throw new TransformerException("XML Parsing failed");
        }
        if (this.timing) {
            long l = new Date().getTime();
            System.err.println("Tree built in " + (l - this.startTime) + " milliseconds");
            this.startTime = l;
        }
        return this.currentDocument;
    }

    public DocumentInfo getCurrentDocument() {
        return this.currentDocument;
    }

    @Override
    public void warning(SAXParseException sAXParseException) {
        if (this.errorListener != null) {
            try {
                this.errorListener.warning(new TransformerException(sAXParseException));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, false);
        this.failed = true;
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.reportError(sAXParseException, true);
        this.failed = true;
        throw sAXParseException;
    }

    protected void reportError(SAXParseException sAXParseException, boolean bl) {
        block7: {
            if (this.errorListener != null) {
                try {
                    this.systemId = sAXParseException.getSystemId();
                    this.lineNumber = sAXParseException.getLineNumber();
                    this.columnNumber = sAXParseException.getColumnNumber();
                    TransformerException transformerException = new TransformerException("Error reported by XML parser", this, sAXParseException);
                    if (bl) {
                        this.errorListener.fatalError(transformerException);
                        break block7;
                    }
                    this.errorListener.error(transformerException);
                }
                catch (Exception exception) {}
            } else {
                try {
                    String string = bl ? "Fatal error" : "Error";
                    this.errorOutput.write(string + " reported by XML parser: " + sAXParseException.getMessage() + "\n");
                    this.errorOutput.write("  URL:    " + sAXParseException.getSystemId() + "\n");
                    this.errorOutput.write("  Line:   " + sAXParseException.getLineNumber() + "\n");
                    this.errorOutput.write("  Column: " + sAXParseException.getColumnNumber() + "\n");
                    this.errorOutput.flush();
                }
                catch (Exception exception) {
                    System.err.println(sAXParseException);
                    System.err.println(exception);
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public abstract void setUnparsedEntity(String var1, String var2);

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }
}

