/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.XPathException;

public abstract class Value
extends Expression {
    public static final int BOOLEAN = 1;
    public static final int NUMBER = 2;
    public static final int STRING = 3;
    public static final int NODESET = 4;
    public static final int OBJECT = 6;
    public static final int ANY = -1;

    public static double stringToNumber(String string) {
        if (string.indexOf(43) >= 0 || string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
            return Double.NaN;
        }
        try {
            return new Double(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        return this;
    }

    @Override
    public Expression simplify() {
        return this;
    }

    @Override
    public int getDependencies() {
        return 0;
    }

    public abstract String asString() throws XPathException;

    public abstract double asNumber() throws XPathException;

    public abstract boolean asBoolean() throws XPathException;

    public boolean equals(Value value) throws XPathException {
        if (value instanceof NodeSetValue) {
            return value.equals(this);
        }
        if (this instanceof BooleanValue || value instanceof BooleanValue) {
            return this.asBoolean() == value.asBoolean();
        }
        if (this instanceof NumericValue || value instanceof NumericValue) {
            return this.asNumber() == value.asNumber();
        }
        return this.asString().equals(value.asString());
    }

    public boolean notEquals(Value value) throws XPathException {
        if (value instanceof NodeSetValue) {
            return value.notEquals(this);
        }
        return !this.equals(value);
    }

    public boolean compare(int n, Value value) throws XPathException {
        if (n == 11) {
            return this.equals(value);
        }
        if (n == 34) {
            return this.notEquals(value);
        }
        if (value instanceof NodeSetValue) {
            return value.compare(Value.inverse(n), this);
        }
        return this.numericCompare(n, this.asNumber(), value.asNumber());
    }

    protected static final int inverse(int n) {
        switch (n) {
            case 22: {
                return 21;
            }
            case 24: {
                return 23;
            }
            case 21: {
                return 22;
            }
            case 23: {
                return 24;
            }
        }
        return n;
    }

    protected final boolean numericCompare(int n, double d, double d2) {
        switch (n) {
            case 22: {
                return d < d2;
            }
            case 24: {
                return d <= d2;
            }
            case 21: {
                return d > d2;
            }
            case 23: {
                return d >= d2;
            }
        }
        return false;
    }

    @Override
    public Expression reduce(int n, Context context) {
        return this;
    }

    public abstract Object convertToJava(Class var1) throws XPathException;

    public abstract int conversionPreference(Class var1);
}

