/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.InternalSaxonError;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class NodeSetValue
extends Value {
    private Hashtable stringValues = null;

    @Override
    public int getDataType() {
        return 4;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        this.sort();
        return this;
    }

    @Override
    public NodeSetValue evaluateAsNodeSet(Context context) throws XPathException {
        this.sort();
        return this;
    }

    public abstract NodeEnumeration enumerate() throws XPathException;

    @Override
    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        if (bl) {
            this.sort();
        }
        return this.enumerate();
    }

    public abstract void setSorted(boolean var1);

    public abstract boolean isSorted() throws XPathException;

    @Override
    public abstract String asString() throws XPathException;

    @Override
    public double asNumber() throws XPathException {
        return new StringValue(this.asString()).asNumber();
    }

    @Override
    public abstract boolean asBoolean() throws XPathException;

    public abstract int getCount() throws XPathException;

    public abstract NodeSetValue sort() throws XPathException;

    public abstract NodeInfo getFirst() throws XPathException;

    private Hashtable getStringValues() throws XPathException {
        if (this.stringValues == null) {
            this.stringValues = new Hashtable();
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                this.stringValues.put(nodeEnumeration.nextElement().getStringValue(), "x");
            }
        }
        return this.stringValues;
    }

    @Override
    public boolean equals(Value value) throws XPathException {
        if (value instanceof ObjectValue) {
            return false;
        }
        if (value instanceof SingletonNodeSet) {
            if (value.asBoolean()) {
                return this.equals(new StringValue(value.asString()));
            }
            return false;
        }
        if (value instanceof NodeSetValue) {
            Hashtable hashtable = this.getStringValues();
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                if (hashtable.get(nodeEnumeration.nextElement().getStringValue()) == null) continue;
                return true;
            }
            return false;
        }
        if (value instanceof NumericValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (Value.stringToNumber(nodeInfo.getStringValue()) != value.asNumber()) continue;
                return true;
            }
            return false;
        }
        if (value instanceof StringValue) {
            if (this.stringValues == null) {
                NodeEnumeration nodeEnumeration = this.enumerate();
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo = nodeEnumeration.nextElement();
                    if (!nodeInfo.getStringValue().equals(value.asString())) continue;
                    return true;
                }
                return false;
            }
            return this.stringValues.get(value.asString()) != null;
        }
        if (value instanceof BooleanValue) {
            return this.asBoolean() == value.asBoolean();
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    @Override
    public boolean notEquals(Value value) throws XPathException {
        if (value instanceof ObjectValue) {
            return false;
        }
        if (value instanceof SingletonNodeSet) {
            if (value.asBoolean()) {
                return this.notEquals(new StringValue(value.asString()));
            }
            return false;
        }
        if (value instanceof NodeSetValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                String string = nodeEnumeration.nextElement().getStringValue();
                NodeEnumeration nodeEnumeration2 = ((NodeSetValue)value).enumerate();
                while (nodeEnumeration2.hasMoreElements()) {
                    String string2 = nodeEnumeration2.nextElement().getStringValue();
                    if (string.equals(string2)) continue;
                    return true;
                }
            }
            return false;
        }
        if (value instanceof NumericValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (Value.stringToNumber(nodeInfo.getStringValue()) == value.asNumber()) continue;
                return true;
            }
            return false;
        }
        if (value instanceof StringValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (nodeInfo.getStringValue().equals(value.asString())) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BooleanValue) {
            return this.asBoolean() != value.asBoolean();
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    @Override
    public boolean compare(int n, Value value) throws XPathException {
        if (value instanceof ObjectValue) {
            return false;
        }
        if (value instanceof SingletonNodeSet) {
            if (value.asBoolean()) {
                value = new StringValue(value.asString());
            } else {
                return false;
            }
        }
        if (n == 11) {
            return this.equals(value);
        }
        if (n == 34) {
            return this.notEquals(value);
        }
        if (value instanceof NodeSetValue) {
            double d;
            double d2 = Double.NEGATIVE_INFINITY;
            double d3 = Double.POSITIVE_INFINITY;
            boolean bl = true;
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                d = Value.stringToNumber(nodeEnumeration.nextElement().getStringValue());
                if (d < d3) {
                    d3 = d;
                }
                if (d > d2) {
                    d2 = d;
                }
                bl = false;
            }
            if (bl) {
                return false;
            }
            d = Double.NEGATIVE_INFINITY;
            double d4 = Double.POSITIVE_INFINITY;
            boolean bl2 = true;
            NodeEnumeration nodeEnumeration2 = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration2.hasMoreElements()) {
                double d5 = Value.stringToNumber(nodeEnumeration2.nextElement().getStringValue());
                if (d5 < d4) {
                    d4 = d5;
                }
                if (d5 > d) {
                    d = d5;
                }
                bl2 = false;
            }
            if (bl2) {
                return false;
            }
            switch (n) {
                case 22: {
                    return d3 < d;
                }
                case 24: {
                    return d3 <= d;
                }
                case 21: {
                    return d2 > d4;
                }
                case 23: {
                    return d2 >= d4;
                }
            }
            return false;
        }
        if (value instanceof NumericValue || value instanceof StringValue) {
            NodeEnumeration nodeEnumeration = this.enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                if (!this.numericCompare(n, Value.stringToNumber(nodeInfo.getStringValue()), value.asNumber())) continue;
                return true;
            }
            return false;
        }
        if (value instanceof BooleanValue) {
            return this.numericCompare(n, new BooleanValue(this.asBoolean()).asNumber(), new BooleanValue(value.asBoolean()).asNumber());
        }
        throw new InternalSaxonError("Unknown data type in a relational expression");
    }

    @Override
    public void display(int n) {
        System.err.println(NodeSetValue.indent(n) + "** node set value (class " + this.getClass() + ") **");
    }

    @Override
    public int conversionPreference(Class clazz) {
        if (clazz.isAssignableFrom(NodeSetValue.class)) {
            return 0;
        }
        if (clazz == NodeList.class) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 8;
        }
        if (clazz == Boolean.class) {
            return 9;
        }
        if (clazz == Byte.TYPE) {
            return 6;
        }
        if (clazz == Byte.class) {
            return 7;
        }
        if (clazz == Character.TYPE) {
            return 4;
        }
        if (clazz == Character.class) {
            return 5;
        }
        if (clazz == Double.TYPE) {
            return 6;
        }
        if (clazz == Double.class) {
            return 7;
        }
        if (clazz == Float.TYPE) {
            return 6;
        }
        if (clazz == Float.class) {
            return 7;
        }
        if (clazz == Integer.TYPE) {
            return 6;
        }
        if (clazz == Integer.class) {
            return 7;
        }
        if (clazz == Long.TYPE) {
            return 6;
        }
        if (clazz == Long.class) {
            return 7;
        }
        if (clazz == Short.TYPE) {
            return 6;
        }
        if (clazz == Short.class) {
            return 7;
        }
        if (clazz == String.class) {
            return 2;
        }
        if (clazz == Object.class) {
            return 3;
        }
        if (clazz == Node.class) {
            return 1;
        }
        if (clazz == Element.class) {
            return 1;
        }
        if (clazz == Document.class) {
            return 1;
        }
        if (clazz == DocumentFragment.class) {
            return 1;
        }
        if (clazz == Attr.class) {
            return 1;
        }
        if (clazz == Comment.class) {
            return 1;
        }
        if (clazz == Text.class) {
            return 1;
        }
        if (clazz == CharacterData.class) {
            return 1;
        }
        if (clazz == ProcessingInstruction.class) {
            return 1;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        if (clazz == NodeEnumeration.class) {
            return this.enumerate();
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == Boolean.class) {
            return new Boolean(this.asBoolean());
        }
        if (clazz == Object.class || clazz == NodeList.class) {
            if (this instanceof NodeList) {
                return this;
            }
            return new NodeSetExtent(this.enumerate(), (NodeOrderComparer)new LocalOrderComparer());
        }
        if (clazz == Node.class) {
            NodeInfo nodeInfo = this.getFirst();
            return nodeInfo;
        }
        if (clazz == Attr.class) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 2) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == CharacterData.class || clazz == Text.class) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 3) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == Comment.class) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 8) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == Document.class) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 9) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == Element.class) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 1) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == ProcessingInstruction.class) {
            NodeInfo nodeInfo = this.getFirst();
            if (nodeInfo == null) {
                return null;
            }
            if (nodeInfo.getNodeType() == 7) {
                return nodeInfo;
            }
            throw new XPathException("Node is of wrong type");
        }
        if (clazz == String.class) {
            return this.asString();
        }
        if (clazz == Double.TYPE) {
            return new Double(this.asNumber());
        }
        if (clazz == Double.class) {
            return new Double(this.asNumber());
        }
        if (clazz == Float.TYPE) {
            return new Float(this.asNumber());
        }
        if (clazz == Float.class) {
            return new Float(this.asNumber());
        }
        if (clazz == Long.TYPE) {
            return new Long((long)this.asNumber());
        }
        if (clazz == Long.class) {
            return new Long((long)this.asNumber());
        }
        if (clazz == Integer.TYPE) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == Integer.class) {
            return new Integer((int)this.asNumber());
        }
        if (clazz == Short.TYPE) {
            return new Short((short)this.asNumber());
        }
        if (clazz == Short.class) {
            return new Short((short)this.asNumber());
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == Byte.class) {
            return new Byte((byte)this.asNumber());
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            String string = this.asString();
            if (string.length() == 1) {
                return new Character(string.charAt(0));
            }
            throw new XPathException("Cannot convert string to Java char unless length is 1");
        }
        throw new XPathException("Conversion of node-set to " + clazz.getName() + " is not supported");
    }
}

