/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ObjectValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.NodeOrderComparer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.xsl.XSLTContext;

public class FunctionProxy
extends Function {
    private Class theClass;
    private Vector candidateMethods = new Vector();
    private XPathException theException = null;
    private String name;
    private Class resultClass = null;

    public boolean setFunctionName(Class clazz, String string) {
        char c;
        int n;
        boolean bl = false;
        this.name = string;
        int n2 = n = this.getNumberOfArguments();
        this.theClass = clazz;
        if (this.name.equals("new")) {
            int n3 = this.theClass.getModifiers();
            if (Modifier.isAbstract(n3)) {
                this.theException = new XPathException("Class " + this.theClass + " is abstract");
                return false;
            }
            if (Modifier.isInterface(n3)) {
                this.theException = new XPathException(this.theClass + " is an interface");
                return false;
            }
            if (Modifier.isPrivate(n3)) {
                this.theException = new XPathException("Class " + this.theClass + " is private");
                return false;
            }
            if (Modifier.isProtected(n3)) {
                this.theException = new XPathException("Class " + this.theClass + " is protected");
                return false;
            }
            this.resultClass = this.theClass;
            Constructor<?>[] constructorArray = this.theClass.getConstructors();
            for (int i = 0; i < constructorArray.length; ++i) {
                bl = true;
                Constructor<?> constructor = constructorArray[i];
                if (constructor.getParameterTypes().length != n) continue;
                bl = true;
                this.candidateMethods.addElement(constructor);
            }
            if (bl) {
                return true;
            }
            this.theException = new XPathException("No constructor with " + n + (n == 1 ? " parameter" : " parameters") + " found in class " + this.theClass.getName());
            return false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i = 0; i < this.name.length(); ++i) {
            c = this.name.charAt(i);
            if (c == '-') {
                bl2 = true;
                continue;
            }
            if (bl2) {
                stringBuffer.append(Character.toUpperCase(c));
            } else {
                stringBuffer.append(c);
            }
            bl2 = false;
        }
        this.name = stringBuffer.toString();
        if (this.name.equals("if")) {
            this.name = "IF";
        }
        Method[] methodArray = this.theClass.getMethods();
        c = '\u0001';
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!method.getName().equals(this.name) || !Modifier.isPublic(method.getModifiers())) continue;
            bl = true;
            if (c != '\u0000') {
                if (this.resultClass == null) {
                    this.resultClass = method.getReturnType();
                } else {
                    c = method.getReturnType() == this.resultClass ? (char)'\u0001' : '\u0000';
                }
            }
            Class<?>[] classArray = method.getParameterTypes();
            boolean bl3 = Modifier.isStatic(method.getModifiers());
            int n4 = n2 = bl3 ? n : n - 1;
            if (n2 < 0) continue;
            if (classArray.length == n2 && (n2 == 0 || classArray[0] != Context.class)) {
                bl = true;
                this.candidateMethods.addElement(method);
            }
            if (classArray.length != n2 + 1 || classArray[0] != Context.class && classArray[0] != XSLTContext.class) continue;
            bl = true;
            this.candidateMethods.addElement(method);
        }
        if (c == '\u0000') {
            this.resultClass = null;
        }
        if (bl) {
            return true;
        }
        this.theException = new XPathException("No method matching " + this.name + " with " + n2 + (n2 == 1 ? " parameter" : " parameters") + " found in class " + this.theClass.getName());
        return false;
    }

    @Override
    public int getDataType() {
        if (this.resultClass == null || this.resultClass == Value.class) {
            return -1;
        }
        if (this.resultClass.toString().equals("void")) {
            return 4;
        }
        if (this.resultClass == String.class || this.resultClass == StringValue.class) {
            return 3;
        }
        if (this.resultClass == Boolean.class || this.resultClass == Boolean.TYPE || this.resultClass == BooleanValue.class) {
            return 1;
        }
        if (this.resultClass == Double.class || this.resultClass == Double.TYPE || this.resultClass == Float.class || this.resultClass == Float.TYPE || this.resultClass == Long.class || this.resultClass == Long.TYPE || this.resultClass == Integer.class || this.resultClass == Integer.TYPE || this.resultClass == Short.class || this.resultClass == Short.TYPE || this.resultClass == Byte.class || this.resultClass == Byte.TYPE || this.resultClass == NumericValue.class) {
            return 2;
        }
        if (NodeSetValue.class.isAssignableFrom(this.resultClass) || NodeEnumeration.class.isAssignableFrom(this.resultClass) || NodeList.class.isAssignableFrom(this.resultClass) || Node.class.isAssignableFrom(this.resultClass)) {
            return 4;
        }
        return 6;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Expression simplify() throws XPathException {
        int n;
        for (n = 0; n < this.getNumberOfArguments(); ++n) {
            this.argument[n] = this.argument[n].simplify();
        }
        if (this.candidateMethods.size() > 1) {
            int n2;
            n = 1;
            for (int i = 0; i < this.getNumberOfArguments(); ++i) {
                n2 = this.argument[i].getDataType();
                if (n2 != -1 && n2 != 6) continue;
                n = 0;
                break;
            }
            if (n != 0) {
                Value[] valueArray = new Value[this.getNumberOfArguments()];
                block10: for (n2 = 0; n2 < this.getNumberOfArguments(); ++n2) {
                    switch (this.argument[n2].getDataType()) {
                        case 1: {
                            valueArray[n2] = new BooleanValue(true);
                            continue block10;
                        }
                        case 2: {
                            valueArray[n2] = new NumericValue(1.0);
                            continue block10;
                        }
                        case 3: {
                            valueArray[n2] = new StringValue("");
                            continue block10;
                        }
                        case 4: {
                            valueArray[n2] = new EmptyNodeSet();
                        }
                    }
                }
                try {
                    Object object = this.getBestFit(valueArray);
                    this.candidateMethods = new Vector();
                    this.candidateMethods.addElement(object);
                }
                catch (XPathException xPathException) {
                    this.theException = xPathException;
                }
            }
        }
        return this;
    }

    @Override
    public int getDependencies() {
        int n = 0;
        n = 56;
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            n |= this.argument[i].getDependencies();
        }
        return n;
    }

    @Override
    public Expression reduce(int n, Context context) throws XPathException {
        if ((n & 0x38) != 0) {
            return this.evaluate(context);
        }
        FunctionProxy functionProxy = new FunctionProxy();
        functionProxy.theClass = this.theClass;
        functionProxy.candidateMethods = this.candidateMethods;
        functionProxy.theException = this.theException;
        functionProxy.name = this.name;
        functionProxy.argument = new Expression[this.getNumberOfArguments()];
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            functionProxy.addArgument(this.argument[i].reduce(n, context));
        }
        return functionProxy;
    }

    public Object getBestFit(Value[] valueArray) throws XPathException {
        int n;
        Object object;
        int n2;
        if (this.candidateMethods.size() == 1) {
            return this.candidateMethods.elementAt(0);
        }
        int n3 = this.candidateMethods.size();
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = false;
        }
        for (n2 = 0; n2 < n3 - 1; ++n2) {
            object = this.getConversionPreferences(valueArray, this.candidateMethods.elementAt(n2));
            if (blArray[n2]) continue;
            for (n = n2 + 1; n < n3; ++n) {
                if (blArray[n]) continue;
                int[] nArray = this.getConversionPreferences(valueArray, this.candidateMethods.elementAt(n));
                for (int i = 0; i < nArray.length; ++i) {
                    if (object[i] > nArray[i]) {
                        blArray[n2] = true;
                    }
                    if (object[i] >= nArray[i]) continue;
                    blArray[n] = true;
                }
            }
        }
        n2 = 0;
        object = null;
        for (n = 0; n < n3; ++n) {
            if (blArray[n]) continue;
            object = this.candidateMethods.elementAt(n);
            ++n2;
        }
        if (n2 == 0) {
            throw new XPathException("There is no Java method that is a unique best match");
        }
        if (n2 > 1) {
            throw new XPathException("There are several Java methods that match equally well");
        }
        return object;
    }

    @Override
    public Value evaluate(Context context) throws XPathException {
        Object object = this.call(context);
        return FunctionProxy.convertJavaObjectToXPath(object, context.getController());
    }

    @Override
    public String evaluateAsString(Context context) throws XPathException {
        if (this.resultClass == String.class) {
            return (String)this.call(context);
        }
        if (this.resultClass == NodeEnumeration.class) {
            NodeEnumeration nodeEnumeration = this.enumerate(context, true);
            if (nodeEnumeration.hasMoreElements()) {
                return nodeEnumeration.nextElement().getStringValue();
            }
            return "";
        }
        return this.evaluate(context).asString();
    }

    @Override
    public double evaluateAsNumber(Context context) throws XPathException {
        if (this.resultClass == Double.TYPE) {
            return (Double)this.call(context);
        }
        if (this.resultClass == NodeEnumeration.class) {
            NodeEnumeration nodeEnumeration = this.enumerate(context, true);
            if (nodeEnumeration.hasMoreElements()) {
                return Value.stringToNumber(nodeEnumeration.nextElement().getStringValue());
            }
            return Double.NaN;
        }
        return this.evaluate(context).asNumber();
    }

    @Override
    public boolean evaluateAsBoolean(Context context) throws XPathException {
        if (this.resultClass == Boolean.TYPE) {
            return (Boolean)this.call(context);
        }
        if (this.resultClass == NodeEnumeration.class) {
            NodeEnumeration nodeEnumeration = this.enumerate(context, false);
            return nodeEnumeration.hasMoreElements();
        }
        return this.evaluate(context).asBoolean();
    }

    @Override
    public NodeEnumeration enumerate(Context context, boolean bl) throws XPathException {
        if (this.resultClass == NodeEnumeration.class) {
            NodeEnumeration nodeEnumeration = (NodeEnumeration)this.call(context);
            if (bl && !nodeEnumeration.isSorted()) {
                NodeSetExtent nodeSetExtent = new NodeSetExtent(nodeEnumeration, (NodeOrderComparer)context.getController());
                nodeSetExtent.sort();
                return nodeSetExtent.enumerate();
            }
            return nodeEnumeration;
        }
        return super.enumerate(context, bl);
    }

    private Object call(Context context) throws XPathException {
        Object[] objectArray;
        int n;
        Object object;
        boolean bl;
        if (this.theException != null) {
            throw this.theException;
        }
        context.setException(null);
        Value[] valueArray = new Value[this.getNumberOfArguments()];
        for (int i = 0; i < this.getNumberOfArguments(); ++i) {
            valueArray[i] = this.argument[i].evaluate(context);
        }
        Object object2 = this.getBestFit(valueArray);
        if (object2 instanceof Constructor) {
            Constructor constructor = (Constructor)object2;
            Class[] classArray = constructor.getParameterTypes();
            Object[] objectArray2 = new Object[classArray.length];
            this.setupParams(valueArray, objectArray2, classArray, 0, 0);
            try {
                Object t = constructor.newInstance(objectArray2);
                if (context.getException() != null) {
                    throw context.getException();
                }
                return t;
            }
            catch (InstantiationException instantiationException) {
                throw new XPathException("Cannot instantiate class", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XPathException("Constructor access is illegal", illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new XPathException("Argument is of wrong type", illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof XPathException) {
                    throw (XPathException)throwable;
                }
                if (context.getController().isTracing()) {
                    invocationTargetException.getTargetException().printStackTrace();
                }
                throw new XPathException("Exception in extension function " + invocationTargetException.getTargetException().toString());
            }
        }
        Method method = (Method)object2;
        boolean bl2 = Modifier.isStatic(method.getModifiers());
        Class[] classArray = method.getParameterTypes();
        boolean bl3 = bl = classArray.length > 0 && (classArray[0] == Context.class || classArray[0] == XSLTContext.class);
        if (bl2) {
            object = null;
        } else {
            n = this.getNumberOfArguments();
            if (n == 0) {
                throw new XPathException("Must supply an argument for an instance-level extension function");
            }
            objectArray = this.argument[0].evaluate(context);
            if (objectArray instanceof ObjectValue) {
                object = ((ObjectValue)objectArray).getObject();
            } else if (this.theClass == String.class) {
                object = objectArray.asString();
            } else if (this.theClass == Boolean.class) {
                object = new Boolean(objectArray.asBoolean());
            } else if (this.theClass == Double.class) {
                object = new Double(objectArray.asNumber());
            } else {
                throw new XPathException("First argument is not an object instance");
            }
        }
        n = classArray.length - (bl ? 1 : 0) + (bl2 ? 0 : 1);
        this.checkArgumentCount(n, n);
        objectArray = new Object[classArray.length];
        if (bl) {
            objectArray[0] = context;
        }
        this.setupParams(valueArray, objectArray, classArray, bl ? 1 : 0, bl2 ? 0 : 1);
        try {
            Object object3 = method.invoke(object, objectArray);
            if (context.getException() != null) {
                throw context.getException();
            }
            if (method.getReturnType().toString().equals("void")) {
                return new EmptyNodeSet();
            }
            return object3;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XPathException("Method access is illegal", illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XPathException("Argument is of wrong type", illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof XPathException) {
                throw (XPathException)throwable;
            }
            if (context.getController().isTracing()) {
                invocationTargetException.getTargetException().printStackTrace();
            }
            throw new XPathException("Exception in extension function " + invocationTargetException.getTargetException().toString());
        }
    }

    public static Value convertJavaObjectToXPath(Object object, Controller controller) throws XPathException {
        if (object == null) {
            return new ObjectValue(null);
        }
        if (object instanceof String) {
            return new StringValue((String)object);
        }
        if (object instanceof Boolean) {
            return new BooleanValue((Boolean)object);
        }
        if (object instanceof Double) {
            return new NumericValue((Double)object);
        }
        if (object instanceof Float) {
            return new NumericValue(((Float)object).floatValue());
        }
        if (object instanceof Short) {
            return new NumericValue(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return new NumericValue(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new NumericValue(((Long)object).longValue());
        }
        if (object instanceof Character) {
            return new NumericValue(((Character)object).charValue());
        }
        if (object instanceof Byte) {
            return new NumericValue(((Byte)object).byteValue());
        }
        if (object instanceof Value) {
            return (Value)object;
        }
        if (object instanceof NodeInfo) {
            return new SingletonNodeSet((NodeInfo)object);
        }
        if (object instanceof NodeEnumeration) {
            return new NodeSetExtent((NodeEnumeration)object, (NodeOrderComparer)controller);
        }
        if (object instanceof NodeList) {
            NodeList nodeList = (NodeList)object;
            NodeInfo[] nodeInfoArray = new NodeInfo[nodeList.getLength()];
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!(nodeList.item(i) instanceof NodeInfo)) {
                    throw new XPathException("Supplied NodeList contains non-Saxon DOM Nodes");
                }
                nodeInfoArray[i] = (NodeInfo)((Object)nodeList.item(i));
            }
            return new NodeSetExtent(nodeInfoArray, (NodeOrderComparer)controller);
        }
        if (object instanceof Node) {
            throw new XPathException("Result is a non-Saxon DOM Node");
        }
        return new ObjectValue(object);
    }

    private int[] getConversionPreferences(Value[] valueArray, Object object) {
        Class<?>[] classArray;
        int n;
        if (object instanceof Constructor) {
            n = 0;
            classArray = ((Constructor)object).getParameterTypes();
        } else {
            boolean bl = Modifier.isStatic(((Method)object).getModifiers());
            n = bl ? 0 : 1;
            classArray = ((Method)object).getParameterTypes();
        }
        int[] nArray = new int[valueArray.length];
        if (n == 1) {
            nArray[0] = valueArray[0] instanceof ObjectValue ? 0 : 20;
        }
        int n2 = 0;
        if (classArray[0] == Context.class || classArray[0] == XSLTContext.class) {
            n2 = 1;
        }
        for (int i = n; i < valueArray.length; ++i) {
            nArray[i] = valueArray[i - n].conversionPreference(classArray[i + n2 - n]);
        }
        return nArray;
    }

    private void setupParams(Value[] valueArray, Object[] objectArray, Class[] classArray, int n, int n2) throws XPathException {
        int n3 = n;
        for (int i = n2; i < this.getNumberOfArguments(); ++i) {
            objectArray[n3] = valueArray[i].convertToJava(classArray[n3]);
            ++n3;
        }
    }
}

