/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;

public final class BooleanValue
extends Value {
    private boolean value;

    public BooleanValue(boolean bl) {
        this.value = bl;
    }

    @Override
    public String asString() {
        return this.value ? "true" : "false";
    }

    @Override
    public double asNumber() {
        return this.value ? 1 : 0;
    }

    @Override
    public boolean asBoolean() {
        return this.value;
    }

    @Override
    public int getDataType() {
        return 1;
    }

    @Override
    public int conversionPreference(Class clazz) {
        if (clazz == Object.class) {
            return 50;
        }
        if (clazz.isAssignableFrom(BooleanValue.class)) {
            return 0;
        }
        if (clazz == Boolean.TYPE) {
            return 0;
        }
        if (clazz == Boolean.class) {
            return 0;
        }
        if (clazz == Byte.TYPE) {
            return 3;
        }
        if (clazz == Byte.class) {
            return 4;
        }
        if (clazz == Character.TYPE) {
            return Integer.MAX_VALUE;
        }
        if (clazz == Character.class) {
            return Integer.MAX_VALUE;
        }
        if (clazz == Double.TYPE) {
            return 3;
        }
        if (clazz == Double.class) {
            return 4;
        }
        if (clazz == Float.TYPE) {
            return 3;
        }
        if (clazz == Float.class) {
            return 4;
        }
        if (clazz == Integer.TYPE) {
            return 3;
        }
        if (clazz == Integer.class) {
            return 4;
        }
        if (clazz == Long.TYPE) {
            return 3;
        }
        if (clazz == Long.class) {
            return 4;
        }
        if (clazz == Short.TYPE) {
            return 3;
        }
        if (clazz == Short.class) {
            return 4;
        }
        if (clazz == String.class) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == Object.class) {
            return new Boolean(this.value);
        }
        if (clazz.isAssignableFrom(BooleanValue.class)) {
            return this;
        }
        if (clazz == Boolean.TYPE) {
            return new Boolean(this.value);
        }
        if (clazz == Boolean.class) {
            return new Boolean(this.value);
        }
        if (clazz == Object.class) {
            return new Boolean(this.value);
        }
        if (clazz == String.class) {
            return this.asString();
        }
        if (clazz == Double.TYPE) {
            return new Double(this.asNumber());
        }
        if (clazz == Double.class) {
            return new Double(this.asNumber());
        }
        if (clazz == Float.TYPE) {
            return new Float(this.asNumber());
        }
        if (clazz == Float.class) {
            return new Float(this.asNumber());
        }
        if (clazz == Long.TYPE) {
            return new Long(this.value ? 1 : 0);
        }
        if (clazz == Long.class) {
            return new Long(this.value ? 1 : 0);
        }
        if (clazz == Integer.TYPE) {
            return new Integer(this.value ? 1 : 0);
        }
        if (clazz == Integer.class) {
            return new Integer(this.value ? 1 : 0);
        }
        if (clazz == Short.TYPE) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (clazz == Short.class) {
            return new Short((short)(this.value ? 1 : 0));
        }
        if (clazz == Byte.TYPE) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        if (clazz == Byte.class) {
            return new Byte((byte)(this.value ? 1 : 0));
        }
        throw new XPathException("Conversion of boolean to " + clazz.getName() + " is not supported");
    }

    @Override
    public void display(int n) {
        System.err.println(BooleanValue.indent(n) + "boolean (" + this.asString() + ")");
    }
}

