/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon;

import com.icl.saxon.DOMDriver;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.output.GeneralOutputter;
import com.icl.saxon.output.Outputter;
import java.util.Properties;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TreeDriver
extends DOMDriver {
    private Outputter outputter;

    public void setDocument(Document document) {
        this.root = document;
        if (!(document instanceof DocumentInfo)) {
            throw new IllegalArgumentException("TreeDriver can only be used with a Saxon tree");
        }
    }

    @Override
    public void parse() throws SAXException {
        if (this.root == null) {
            throw new SAXException("TreeDriver: no start node defined");
        }
        if (this.contentHandler == null) {
            throw new SAXException("DOMDriver: no content handler defined");
        }
        this.contentHandler.setDocumentLocator(this);
        DocumentInfo documentInfo = (DocumentInfo)((Object)this.root);
        try {
            GeneralOutputter generalOutputter = new GeneralOutputter(documentInfo.getNamePool());
            SAXResult sAXResult = new SAXResult(this.contentHandler);
            sAXResult.setSystemId(this.systemId);
            generalOutputter.setOutputDestination(new Properties(), sAXResult);
            documentInfo.copy(generalOutputter);
            generalOutputter.close();
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
    }
}

