/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.position;

import org.osgi.util.measurement.Measurement;
import org.osgi.util.measurement.Unit;

public class Position {
    private final Measurement altitude;
    private final Measurement longitude;
    private final Measurement latitude;
    private final Measurement speed;
    private final Measurement track;
    private static final double LON_RANGE = Math.PI;
    private static final double LAT_RANGE = 1.5707963267948966;
    private static final double TRACK_RANGE = Math.PI * 2;

    public Position(Measurement measurement, Measurement measurement2, Measurement measurement3, Measurement measurement4, Measurement measurement5) {
        double d;
        if (measurement != null && !Unit.rad.equals(measurement.getUnit())) {
            throw new IllegalArgumentException("Invalid Latitude");
        }
        if (measurement2 != null && !Unit.rad.equals(measurement2.getUnit())) {
            throw new IllegalArgumentException("Invalid Longitude");
        }
        if (measurement3 != null && !Unit.m.equals(measurement3.getUnit())) {
            throw new IllegalArgumentException("Invalid Altitude");
        }
        if (measurement4 != null && !Unit.m_s.equals(measurement4.getUnit())) {
            throw new IllegalArgumentException("Invalid Speed");
        }
        if (measurement5 != null && !Unit.rad.equals(measurement5.getUnit())) {
            throw new IllegalArgumentException("Invalid Track");
        }
        if (measurement != null && measurement2 != null) {
            d = measurement.getValue();
            double d2 = measurement2.getValue();
            if (!(d2 >= -Math.PI && d2 < Math.PI && d >= -1.5707963267948966 && d <= 1.5707963267948966)) {
                d2 = Position.normalize(d2, Math.PI);
                if ((d = Position.normalize(d, Math.PI)) > 1.5707963267948966 || d < -1.5707963267948966) {
                    d2 = Position.normalize(d2 - Math.PI, Math.PI);
                    d = Position.normalize(Math.PI - d, 1.5707963267948966);
                }
                measurement2 = new Measurement(d2, measurement2.getError(), measurement2.getUnit(), measurement2.getTime());
                measurement = new Measurement(d, measurement.getError(), measurement.getUnit(), measurement.getTime());
            }
        }
        if (!(measurement5 == null || 0.0 <= (d = measurement5.getValue()) && d < Math.PI * 2)) {
            if ((d %= Math.PI * 2) < 0.0) {
                d += Math.PI * 2;
            }
            measurement5 = new Measurement(d, measurement5.getError(), measurement5.getUnit(), measurement5.getTime());
        }
        this.latitude = measurement;
        this.longitude = measurement2;
        this.altitude = measurement3;
        this.speed = measurement4;
        this.track = measurement5;
    }

    public Measurement getAltitude() {
        return this.altitude;
    }

    public Measurement getLongitude() {
        return this.longitude;
    }

    public Measurement getLatitude() {
        return this.latitude;
    }

    public Measurement getSpeed() {
        return this.speed;
    }

    public Measurement getTrack() {
        return this.track;
    }

    private static double normalize(double d, double d2) {
        double d3 = 2.0 * d2;
        while (d >= d2) {
            d -= d3;
        }
        while (d < -d2) {
            d += d3;
        }
        return d;
    }
}

