/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.dmt.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import org.osgi.service.dmt.security.DmtPermission;

final class DmtPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = -4172481774562012941L;
    private ArrayList perms = new ArrayList();

    @Override
    public void add(Permission permission) {
        if (!(permission instanceof DmtPermission)) {
            throw new IllegalArgumentException("Cannot add permission, invalid permission type: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("Cannot add permission, collection is marked read-only.");
        }
        this.perms.add(permission);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof DmtPermission)) {
            return false;
        }
        DmtPermission dmtPermission = (DmtPermission)permission;
        int n = dmtPermission.getMask();
        int n2 = 0;
        int n3 = n;
        for (DmtPermission dmtPermission2 : this.perms) {
            if ((n3 & dmtPermission2.getMask()) == 0 || !dmtPermission2.impliesPath(dmtPermission)) continue;
            if (((n2 |= dmtPermission2.getMask()) & n) == n) {
                return true;
            }
            n3 = n ^ n2;
        }
        return false;
    }

    public Enumeration elements() {
        return Collections.enumeration(this.perms);
    }
}

