/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.mockito.internal.util.reflection.AccessibilityChanger;
import org.mockito.internal.util.reflection.FieldCopier;

public class LenientCopyTool {
    FieldCopier fieldCopier = new FieldCopier();

    public <T> void copyToMock(T t, T t2) {
        this.copy(t, t2, t.getClass(), t2.getClass().getSuperclass());
    }

    public <T> void copyToRealObject(T t, T t2) {
        this.copy(t, t2, t.getClass(), t2.getClass());
    }

    private <T> void copy(T t, T t2, Class clazz, Class clazz2) {
        while (clazz != Object.class) {
            this.copyValues(t, t2, clazz);
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void copyValues(T t, T t2, Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            if (Modifier.isStatic(field.getModifiers())) continue;
            AccessibilityChanger accessibilityChanger = new AccessibilityChanger();
            try {
                accessibilityChanger.enableAccess(field);
                this.fieldCopier.copyValue(t, t2, field);
                continue;
            }
            catch (Throwable throwable) {
                continue;
            }
            finally {
                accessibilityChanger.safelyDisableAccess(field);
            }
        }
    }
}

