/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.matchers;

import java.io.Serializable;
import org.hamcrest.Description;
import org.hamcrest.SelfDescribing;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.matchers.ContainsExtraTypeInformation;
import org.mockito.internal.matchers.Equality;

public class Equals
extends ArgumentMatcher<Object>
implements ContainsExtraTypeInformation,
Serializable {
    private static final long serialVersionUID = -3395637450058086891L;
    private final Object wanted;

    public Equals(Object object) {
        this.wanted = object;
    }

    @Override
    public boolean matches(Object object) {
        return Equality.areEqual(this.wanted, object);
    }

    @Override
    public void describeTo(Description description) {
        description.appendText(this.describe(this.wanted));
    }

    public String describe(Object object) {
        return this.quoting() + object + this.quoting();
    }

    private String quoting() {
        if (this.wanted instanceof String) {
            return "\"";
        }
        if (this.wanted instanceof Character) {
            return "'";
        }
        return "";
    }

    protected final Object getWanted() {
        return this.wanted;
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Equals equals = (Equals)object;
        return this.wanted == null && equals.wanted == null || this.wanted != null && this.wanted.equals(equals.wanted);
    }

    public int hashCode() {
        return 1;
    }

    @Override
    public SelfDescribing withExtraTypeInfo() {
        return new SelfDescribing(){

            public void describeTo(Description description) {
                description.appendText(Equals.this.describe("(" + Equals.this.wanted.getClass().getSimpleName() + ") " + Equals.this.wanted));
            }
        };
    }

    @Override
    public boolean typeMatches(Object object) {
        return this.wanted != null && object != null && object.getClass() == this.wanted.getClass();
    }
}

