/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mockito.listeners.InvocationListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.mock.SerializableMode;
import org.mockito.stubbing.Answer;

public class CreationSettings<T>
implements MockCreationSettings<T>,
Serializable {
    private static final long serialVersionUID = -6789800638070123629L;
    protected Class<T> typeToMock;
    protected Set<Class> extraInterfaces = new LinkedHashSet<Class>();
    protected String name;
    protected Object spiedInstance;
    protected Answer<Object> defaultAnswer;
    protected MockName mockName;
    protected SerializableMode serializableMode = SerializableMode.NONE;
    protected List<InvocationListener> invocationListeners = new ArrayList<InvocationListener>();
    protected boolean stubOnly;
    private boolean useConstructor;
    private Object outerClassInstance;

    public CreationSettings() {
    }

    public CreationSettings(CreationSettings creationSettings) {
        this.typeToMock = creationSettings.typeToMock;
        this.extraInterfaces = creationSettings.extraInterfaces;
        this.name = creationSettings.name;
        this.spiedInstance = creationSettings.spiedInstance;
        this.defaultAnswer = creationSettings.defaultAnswer;
        this.mockName = creationSettings.mockName;
        this.serializableMode = creationSettings.serializableMode;
        this.invocationListeners = creationSettings.invocationListeners;
        this.stubOnly = creationSettings.stubOnly;
        this.useConstructor = creationSettings.isUsingConstructor();
        this.outerClassInstance = creationSettings.getOuterClassInstance();
    }

    @Override
    public Class<T> getTypeToMock() {
        return this.typeToMock;
    }

    public CreationSettings<T> setTypeToMock(Class<T> clazz) {
        this.typeToMock = clazz;
        return this;
    }

    @Override
    public Set<Class> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    public CreationSettings<T> setExtraInterfaces(Set<Class> set) {
        this.extraInterfaces = set;
        return this;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object getSpiedInstance() {
        return this.spiedInstance;
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return this.defaultAnswer;
    }

    @Override
    public MockName getMockName() {
        return this.mockName;
    }

    public CreationSettings<T> setMockName(MockName mockName) {
        this.mockName = mockName;
        return this;
    }

    @Override
    public boolean isSerializable() {
        return this.serializableMode != SerializableMode.NONE;
    }

    @Override
    public SerializableMode getSerializableMode() {
        return this.serializableMode;
    }

    @Override
    public List<InvocationListener> getInvocationListeners() {
        return this.invocationListeners;
    }

    @Override
    public boolean isUsingConstructor() {
        return this.useConstructor;
    }

    @Override
    public Object getOuterClassInstance() {
        return this.outerClassInstance;
    }

    @Override
    public boolean isStubOnly() {
        return this.stubOnly;
    }
}

