/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockito.MockSettings;
import org.mockito.exceptions.Reporter;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.debugging.VerboseMockInvocationLogger;
import org.mockito.internal.util.MockCreationValidator;
import org.mockito.internal.util.MockNameImpl;
import org.mockito.internal.util.collections.Sets;
import org.mockito.listeners.InvocationListener;
import org.mockito.mock.MockCreationSettings;
import org.mockito.mock.MockName;
import org.mockito.mock.SerializableMode;
import org.mockito.stubbing.Answer;

public class MockSettingsImpl<T>
extends CreationSettings<T>
implements MockSettings,
MockCreationSettings<T> {
    private static final long serialVersionUID = 4475297236197939569L;
    private boolean useConstructor;
    private Object outerClassInstance;

    @Override
    public MockSettings serializable() {
        return this.serializable(SerializableMode.BASIC);
    }

    @Override
    public MockSettings serializable(SerializableMode serializableMode) {
        this.serializableMode = serializableMode;
        return this;
    }

    public MockSettings extraInterfaces(Class ... classArray) {
        if (classArray == null || classArray.length == 0) {
            new Reporter().extraInterfacesRequiresAtLeastOneInterface();
        }
        for (Class clazz : classArray) {
            if (clazz == null) {
                new Reporter().extraInterfacesDoesNotAcceptNullParameters();
                continue;
            }
            if (clazz.isInterface()) continue;
            new Reporter().extraInterfacesAcceptsOnlyInterfaces(clazz);
        }
        this.extraInterfaces = Sets.newSet(classArray);
        return this;
    }

    @Override
    public MockName getMockName() {
        return this.mockName;
    }

    @Override
    public Set<Class> getExtraInterfaces() {
        return this.extraInterfaces;
    }

    @Override
    public Object getSpiedInstance() {
        return this.spiedInstance;
    }

    @Override
    public MockSettings name(String string) {
        this.name = string;
        return this;
    }

    @Override
    public MockSettings spiedInstance(Object object) {
        this.spiedInstance = object;
        return this;
    }

    @Override
    public MockSettings defaultAnswer(Answer answer) {
        this.defaultAnswer = answer;
        if (answer == null) {
            new Reporter().defaultAnswerDoesNotAcceptNullParameter();
        }
        return this;
    }

    @Override
    public Answer<Object> getDefaultAnswer() {
        return this.defaultAnswer;
    }

    @Override
    public MockSettingsImpl stubOnly() {
        this.stubOnly = true;
        return this;
    }

    @Override
    public MockSettings useConstructor() {
        this.useConstructor = true;
        return this;
    }

    @Override
    public MockSettings outerInstance(Object object) {
        this.outerClassInstance = object;
        return this;
    }

    @Override
    public boolean isUsingConstructor() {
        return this.useConstructor;
    }

    @Override
    public Object getOuterClassInstance() {
        return this.outerClassInstance;
    }

    @Override
    public boolean isStubOnly() {
        return this.stubOnly;
    }

    @Override
    public MockSettings verboseLogging() {
        if (!this.invocationListenersContainsType(VerboseMockInvocationLogger.class)) {
            this.invocationListeners(new VerboseMockInvocationLogger());
        }
        return this;
    }

    @Override
    public MockSettings invocationListeners(InvocationListener ... invocationListenerArray) {
        if (invocationListenerArray == null || invocationListenerArray.length == 0) {
            new Reporter().invocationListenersRequiresAtLeastOneListener();
        }
        for (InvocationListener invocationListener : invocationListenerArray) {
            if (invocationListener == null) {
                new Reporter().invocationListenerDoesNotAcceptNullParameters();
            }
            this.invocationListeners.add(invocationListener);
        }
        return this;
    }

    private boolean invocationListenersContainsType(Class<?> clazz) {
        for (InvocationListener invocationListener : this.invocationListeners) {
            if (!invocationListener.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<InvocationListener> getInvocationListeners() {
        return this.invocationListeners;
    }

    public boolean hasInvocationListeners() {
        return !this.invocationListeners.isEmpty();
    }

    @Override
    public Class<T> getTypeToMock() {
        return this.typeToMock;
    }

    public MockCreationSettings<T> confirm(Class<T> clazz) {
        return MockSettingsImpl.validatedSettings(clazz, this);
    }

    private static <T> CreationSettings<T> validatedSettings(Class<T> clazz, CreationSettings<T> creationSettings) {
        MockCreationValidator mockCreationValidator = new MockCreationValidator();
        mockCreationValidator.validateType(clazz);
        mockCreationValidator.validateExtraInterfaces(clazz, creationSettings.getExtraInterfaces());
        mockCreationValidator.validateMockedType(clazz, creationSettings.getSpiedInstance());
        mockCreationValidator.validateSerializable(clazz, creationSettings.isSerializable());
        mockCreationValidator.validateConstructorUse(creationSettings.isUsingConstructor(), creationSettings.getSerializableMode());
        CreationSettings<T> creationSettings2 = new CreationSettings<T>(creationSettings);
        creationSettings2.setMockName(new MockNameImpl(creationSettings.getName(), clazz));
        creationSettings2.setTypeToMock(clazz);
        creationSettings2.setExtraInterfaces(MockSettingsImpl.prepareExtraInterfaces(creationSettings));
        return creationSettings2;
    }

    private static Set<Class> prepareExtraInterfaces(CreationSettings creationSettings) {
        HashSet<Class> hashSet = new HashSet<Class>(creationSettings.getExtraInterfaces());
        if (creationSettings.isSerializable()) {
            hashSet.add(Serializable.class);
        }
        return hashSet;
    }
}

