/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.functors;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public final class MapTransformer<I, O>
implements Transformer<I, O>,
Serializable {
    static final long serialVersionUID = 862391807045468939L;
    private final Map<I, O> iMap;

    public static <I, O> Transformer<I, O> getInstance(Map<I, O> map) {
        if (map == null) {
            return ConstantTransformer.NULL_INSTANCE;
        }
        return new MapTransformer<I, O>(map);
    }

    private MapTransformer(Map<I, O> map) {
        this.iMap = map;
    }

    @Override
    public O transform(I input) {
        return this.iMap.get(input);
    }

    public Map<I, O> getMap() {
        return this.iMap;
    }
}

