/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.bidimap;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.MapIterator;
import org.apache.commons.collections15.Unmodifiable;
import org.apache.commons.collections15.bidimap.AbstractBidiMapDecorator;
import org.apache.commons.collections15.iterators.UnmodifiableMapIterator;
import org.apache.commons.collections15.map.UnmodifiableEntrySet;
import org.apache.commons.collections15.set.UnmodifiableSet;

public final class UnmodifiableBidiMap<K, V>
extends AbstractBidiMapDecorator<K, V>
implements Unmodifiable {
    private UnmodifiableBidiMap<V, K> inverse;

    public static <K, V> BidiMap<K, V> decorate(BidiMap<K, V> map) {
        if (map instanceof Unmodifiable) {
            return map;
        }
        return new UnmodifiableBidiMap<K, V>(map);
    }

    private UnmodifiableBidiMap(BidiMap<K, V> map) {
        super(map);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> mapToCopy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set set = super.entrySet();
        return UnmodifiableEntrySet.decorate(set);
    }

    @Override
    public Set<K> keySet() {
        Set set = super.keySet();
        return UnmodifiableSet.decorate(set);
    }

    @Override
    public Set<V> values() {
        Collection coll = super.values();
        return UnmodifiableSet.decorate(coll);
    }

    @Override
    public K removeValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        MapIterator it = this.getBidiMap().mapIterator();
        return UnmodifiableMapIterator.decorate(it);
    }

    @Override
    public BidiMap<V, K> inverseBidiMap() {
        if (this.inverse == null) {
            this.inverse = new UnmodifiableBidiMap<K, V>(this.getBidiMap().inverseBidiMap());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }
}

