/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import java.util.Collection;
import java.util.Comparator;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.comparators.BooleanComparator;
import org.apache.commons.collections15.comparators.ComparableComparator;
import org.apache.commons.collections15.comparators.ComparatorChain;
import org.apache.commons.collections15.comparators.NullComparator;
import org.apache.commons.collections15.comparators.ReverseComparator;
import org.apache.commons.collections15.comparators.TransformingComparator;

public class ComparatorUtils {
    public static final Comparator NATURAL_COMPARATOR = ComparableComparator.getInstance();

    public static Comparator naturalComparator() {
        return NATURAL_COMPARATOR;
    }

    public static <T> Comparator<T> chainedComparator(Comparator<T> comparator1, Comparator<T> comparator2) {
        return ComparatorUtils.chainedComparator(new Comparator[]{comparator1, comparator2});
    }

    public static <T> Comparator<T> chainedComparator(Comparator<T>[] comparators) {
        ComparatorChain<T> chain = new ComparatorChain<T>();
        for (int i = 0; i < comparators.length; ++i) {
            if (comparators[i] == null) {
                throw new NullPointerException("Comparator cannot be null");
            }
            chain.addComparator(comparators[i]);
        }
        return chain;
    }

    public static <T> Comparator<T> chainedComparator(Collection<T> comparators) {
        return ComparatorUtils.chainedComparator(comparators.toArray(new Comparator[comparators.size()]));
    }

    public static <T> Comparator<T> reversedComparator(Comparator<T> comparator) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new ReverseComparator(comparator);
    }

    public static Comparator<Boolean> booleanComparator(boolean trueFirst) {
        return BooleanComparator.getBooleanComparator(trueFirst);
    }

    public static <T> Comparator<T> nullLowComparator(Comparator<T> comparator) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new NullComparator(comparator, false);
    }

    public static <T> Comparator<T> nullHighComparator(Comparator<T> comparator) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new NullComparator(comparator, true);
    }

    public static <I, O> Comparator<O> transformedComparator(Comparator<I> comparator, Transformer<I, O> transformer) {
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return new TransformingComparator<I, O>(transformer, comparator);
    }

    public static <T> T min(T o1, T o2, Comparator<T> comparator) {
        int c;
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return (c = comparator.compare(o1, o2)) < 0 ? o1 : o2;
    }

    public static <T> T max(T o1, T o2, Comparator<T> comparator) {
        int c;
        if (comparator == null) {
            comparator = NATURAL_COMPARATOR;
        }
        return (c = comparator.compare(o1, o2)) > 0 ? o1 : o2;
    }
}

