/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTree;
import lcmc.Exceptions;
import lcmc.configs.AppDefaults;
import lcmc.data.Cluster;
import lcmc.data.Host;
import lcmc.gui.CRMGraph;
import lcmc.gui.DrbdGraph;
import lcmc.gui.resources.Info;
import lcmc.gui.widget.Widget;
import lcmc.utilities.Tools;

public final class RoboTest {
    private static final GraphicsDevice SCREEN_DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private static final boolean MOVE_MOUSE_FAST = false;
    private static final boolean CONFIRM_REMOVE = true;
    private static volatile Point2D prevP = null;
    private static volatile boolean aborted = false;
    private static float slowFactor = 1.0f;
    private static Robot robot;
    private static Cluster cluster;
    private static boolean PROXY;

    private RoboTest() {
    }

    private static boolean abortWithMouseMovement() {
        if (MouseInfo.getPointerInfo() == null) {
            return false;
        }
        Point2D p = RoboTest.getAppPosition();
        double x = p.getX();
        if (x > 1536.0 || x < -100.0) {
            int i = 0;
            while (x > 1536.0 || x < -100.0) {
                if (i % 10 == 0) {
                    RoboTest.info("sleep: " + x);
                }
                Tools.sleep(500);
                if (MouseInfo.getPointerInfo() != null) {
                    p = RoboTest.getAppPosition();
                    x = p.getX();
                }
                ++i;
            }
            prevP = p;
            return false;
        }
        if (prevP != null && prevP.getX() - p.getX() > 200.0 && p.getY() - prevP.getY() > 200.0) {
            prevP = null;
            RoboTest.info("test aborted");
            aborted = true;
            return true;
        }
        prevP = p;
        return false;
    }

    public static void restoreMouse() {
        try {
            robot = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            robot = null;
            Tools.appWarning("Robot error");
        }
        if (robot == null) {
            return;
        }
        RoboTest.leftClick();
        RoboTest.rightClick();
    }

    public static void startClicker(int duration, boolean lazy) {
        RoboTest.startClicker0(duration, lazy, 16, 10, 10, 500, 100);
    }

    public static void startRightClicker(int duration, boolean lazy) {
        RoboTest.startClicker0(duration, lazy, 4, 10, 500, 500, 5000);
    }

    private static void startClicker0(final int duration, final boolean lazy, final int buttonMask, final int timeAfterClick, final int timeAfterRelase, final int timeAfterClickLazy, final int timeAfterRelaseLazy) {
        RoboTest.info("start click test in 10 seconds");
        prevP = null;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                RoboTest.sleepNoFactor(10000.0);
                Robot rbt = null;
                try {
                    rbt = new Robot(SCREEN_DEVICE);
                }
                catch (AWTException e) {
                    Tools.appWarning("Robot error");
                }
                if (rbt == null) {
                    return;
                }
                robot = rbt;
                long startTime = System.currentTimeMillis();
                while (true) {
                    long current;
                    robot.mousePress(buttonMask);
                    if (lazy) {
                        RoboTest.sleepNoFactor(timeAfterClickLazy);
                    } else {
                        RoboTest.sleepNoFactor(timeAfterClick);
                    }
                    robot.mouseRelease(buttonMask);
                    if (lazy) {
                        RoboTest.sleepNoFactor(timeAfterRelaseLazy);
                    } else {
                        RoboTest.sleepNoFactor(timeAfterRelase);
                    }
                    robot.keyPress(27);
                    RoboTest.sleepNoFactor(100.0);
                    robot.keyRelease(27);
                    if (RoboTest.abortWithMouseMovement() || (current = System.currentTimeMillis()) - startTime > (long)(duration * 60 * 1000)) break;
                    RoboTest.sleepNoFactor(500.0);
                }
                RoboTest.info("click test done");
            }
        });
        thread.start();
    }

    public static void startMover(int duration, final boolean withClicks) {
        aborted = false;
        slowFactor = 0.3f;
        RoboTest.info("start mouse move test in 10 seconds");
        prevP = null;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                RoboTest.sleepNoFactor(10000.0);
                Robot rbt = null;
                try {
                    rbt = new Robot(SCREEN_DEVICE);
                }
                catch (AWTException e) {
                    Tools.appWarning("Robot error");
                }
                if (rbt == null) {
                    return;
                }
                robot = rbt;
                int xOffset = RoboTest.getOffset();
                Point2D pos = RoboTest.getAppPosition();
                int origX = (int)pos.getX();
                int origY = (int)pos.getY();
                RoboTest.info("move mouse to the end position");
                RoboTest.sleepNoFactor(5000.0);
                Point2D endP = RoboTest.getAppPosition();
                int endX = (int)endP.getX();
                int endY = (int)endP.getY();
                int destX = origX;
                int destY = origY;
                RoboTest.info("test started");
                long startTime = System.currentTimeMillis();
                int i = 1;
                while (!aborted) {
                    RoboTest.moveTo(destX, destY);
                    if (RoboTest.abortWithMouseMovement()) break;
                    if (withClicks) {
                        RoboTest.leftClick();
                        RoboTest.sleepNoFactor(1000.0);
                    }
                    RoboTest.moveTo(endX, endY);
                    if (RoboTest.abortWithMouseMovement()) break;
                    if (withClicks) {
                        RoboTest.leftClick();
                        RoboTest.sleepNoFactor(1000.0);
                    }
                    System.out.println("mouse move test: " + i);
                    ++i;
                }
                RoboTest.info("mouse move test done");
            }
        });
        thread.start();
    }

    private static int getOffset() {
        int x2;
        int x1;
        Point p = MouseInfo.getPointerInfo().getLocation();
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int xOffset = 0;
        if (devices.length >= 2 && (x1 = devices[0].getDefaultConfiguration().getBounds().x) > (x2 = devices[1].getDefaultConfiguration().getBounds().x)) {
            xOffset = -x1;
        }
        return xOffset;
    }

    public static void startTest(final String index, Cluster c) {
        cluster = c;
        aborted = false;
        RoboTest.info("start test " + index + " in 3 seconds");
        if (cluster != null) {
            for (Host host : cluster.getHosts()) {
                host.getSSH().installTestFiles();
            }
        }
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String selected;
                block107: {
                    RoboTest.sleepNoFactor(3000.0);
                    robot = null;
                    try {
                        robot = new Robot(SCREEN_DEVICE);
                    }
                    catch (AWTException e) {
                        robot = null;
                        Tools.appWarning("Robot error");
                    }
                    if (robot == null) {
                        return;
                    }
                    selected = null;
                    if (cluster != null) {
                        selected = cluster.getBrowser().getTree().getLastSelectedPathComponent().toString();
                    }
                    if (selected == null) {
                        int count = 200;
                        if ("1".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startGUITest1(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("2".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startGUITest2(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        }
                    } else if ("Services".equals(selected) || Tools.getString("ClusterBrowser.ClusterManager").equals(selected)) {
                        int count = 200;
                        if ("0".equals(index)) {
                            int i = 1;
                            while (true) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startTest1();
                                if (aborted) break block107;
                                RoboTest.startTest2();
                                if (aborted) break block107;
                                RoboTest.startTest3(4);
                                if (aborted) break block107;
                                RoboTest.startTest4();
                                if (!aborted) {
                                    RoboTest.startTest5(5);
                                    if (!aborted) {
                                        RoboTest.startTest6(5);
                                        if (!aborted) {
                                            RoboTest.startTest7(5);
                                            if (!aborted) {
                                                RoboTest.startTest8(10);
                                                if (!aborted && !aborted) {
                                                    RoboTest.startTestA(5);
                                                    if (!aborted) {
                                                        RoboTest.startTestB(5);
                                                        if (!aborted) {
                                                            RoboTest.startTestC(5);
                                                            if (!aborted) {
                                                                RoboTest.startTestD(5);
                                                                if (!aborted) {
                                                                    RoboTest.startTestE(5);
                                                                    if (!aborted) {
                                                                        RoboTest.startTestF(2);
                                                                        if (!aborted) {
                                                                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                                                            RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                                                            ++i;
                                                                            continue;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                                break block107;
                                break;
                            }
                        }
                        if ("1".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startTest1();
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                            }
                        } else if ("2".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startTest2();
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                            }
                        } else if ("3".equals(index)) {
                            boolean i = true;
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index + " no " + 1);
                            RoboTest.startTest3(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + " no " + 1 + ", secs: " + secs);
                        } else if ("4".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startTest4();
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                ++i;
                            }
                        } else if ("5".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startTest5(10);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                ++i;
                            }
                        } else if ("6".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startTest6(10);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                ++i;
                            }
                        } else if ("7".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startTest7(100);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("8".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startTest8(30);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("a".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startTestA(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("b".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startTestB(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("c".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startTestC(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("d".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startTestD(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("e".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startTestE(200);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                        } else if ("f".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startTestF(2);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                ++i;
                            }
                        }
                    } else if ("Storage (DRBD, LVM)".equals(selected)) {
                        Tools.getGUIData().expandTerminalSplitPane(1);
                        if ("0".equals(index)) {
                            int i = 1;
                            int blockDevY = RoboTest.getBlockDevY();
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startDRBDTest1(blockDevY);
                                if (aborted) break;
                                RoboTest.startDRBDTest2(blockDevY);
                                if (aborted) break;
                                RoboTest.startDRBDTest3(blockDevY);
                                if (aborted) break;
                                if (cluster.getHostsArray()[0].hasVolumes()) {
                                    RoboTest.startDRBDTest4(blockDevY);
                                    if (aborted) break;
                                }
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                                if (!cluster.getHostsArray()[0].hasVolumes()) continue;
                                Tools.getConfigData().setBigDRBDConf(!Tools.getConfigData().getBigDRBDConf());
                            }
                        } else if ("1".equals(index)) {
                            int i = 1;
                            int blockDevY = RoboTest.getBlockDevY();
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startDRBDTest1(blockDevY);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                                if (!cluster.getHostsArray()[0].hasVolumes()) continue;
                                Tools.getConfigData().setBigDRBDConf(!Tools.getConfigData().getBigDRBDConf());
                            }
                        } else if ("2".equals(index)) {
                            int i = 1;
                            int blockDevY = RoboTest.getBlockDevY();
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startDRBDTest2(blockDevY);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                            }
                        } else if ("3".equals(index)) {
                            int i = 1;
                            int blockDevY = RoboTest.getBlockDevY();
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startDRBDTest3(blockDevY);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                                if (!cluster.getHostsArray()[0].hasVolumes()) continue;
                                Tools.getConfigData().setBigDRBDConf(!Tools.getConfigData().getBigDRBDConf());
                            }
                        } else if ("4".equals(index)) {
                            int i = 1;
                            int blockDevY = RoboTest.getBlockDevY();
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startDRBDTest4(blockDevY);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                                if (!cluster.getHostsArray()[0].hasVolumes()) continue;
                                Tools.getConfigData().setBigDRBDConf(!Tools.getConfigData().getBigDRBDConf());
                            }
                        } else if ("5".equals(index)) {
                            int blockDevY = RoboTest.getBlockDevY();
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startDRBDTest5(blockDevY);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                            RoboTest.resetTerminalAreas();
                        } else if ("6".equals(index)) {
                            int blockDevY = RoboTest.getBlockDevY();
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startDRBDTest6(blockDevY);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                            RoboTest.resetTerminalAreas();
                        } else if ("7".equals(index)) {
                            int i = 1;
                            int blockDevY = RoboTest.getBlockDevY();
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startDRBDTest5(blockDevY);
                                if (!aborted) {
                                    RoboTest.startDRBDTest6(blockDevY);
                                    int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                    RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                    RoboTest.resetTerminalAreas();
                                    ++i;
                                    continue;
                                }
                                break;
                            }
                        } else if ("8".equals(index)) {
                            int i = 1;
                            int blockDevY = RoboTest.getBlockDevY();
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startDRBDTest8(blockDevY);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                                if (!cluster.getHostsArray()[0].hasVolumes()) continue;
                                Tools.getConfigData().setBigDRBDConf(!Tools.getConfigData().getBigDRBDConf());
                            }
                        }
                    } else if ("VMs (KVM, Xen)".equals(selected)) {
                        if ("1".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startVMTest1("vm-test" + index, 2);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                            }
                        } else if ("2".equals(index)) {
                            int i = 1;
                            String testIndex = "1";
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startVMTest1("vm-test" + testIndex, 10);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                            }
                        } else if ("3".equals(index) || "x3".equals(index)) {
                            int i = 1;
                            String testIndex = "1";
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startVMTest1("vm-test" + testIndex, 30);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                            }
                        } else if ("4".equals(index)) {
                            long startTime = System.currentTimeMillis();
                            RoboTest.info("test" + index);
                            RoboTest.startVMTest4("vm-test" + index, 100);
                            int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                            RoboTest.info("test" + index + ", secs: " + secs);
                            RoboTest.resetTerminalAreas();
                        } else if ("5".equals(index)) {
                            int i = 1;
                            while (!aborted) {
                                long startTime = System.currentTimeMillis();
                                RoboTest.info("test" + index + " no " + i);
                                RoboTest.startVMTest5("vm-test" + index, 2);
                                int secs = (int)(System.currentTimeMillis() - startTime) / 1000;
                                RoboTest.info("test" + index + " no " + i + ", secs: " + secs);
                                RoboTest.resetTerminalAreas();
                                ++i;
                            }
                        }
                    }
                }
                RoboTest.info(selected + " test " + index + " done");
            }
        });
        thread.start();
    }

    private static void checkTest(String test, double no) {
        for (Host host : cluster.getHosts()) {
            if (RoboTest.abortWithMouseMovement()) {
                return;
            }
            if (aborted) continue;
            host.checkPCMKTest(test, no);
        }
    }

    private static void checkDRBDTest(String test, double no) {
        int h = 1;
        for (Host host : cluster.getHosts()) {
            if (RoboTest.abortWithMouseMovement()) {
                return;
            }
            if (!aborted) {
                host.checkDRBDTest(test, no);
            }
            if (h == 2) break;
            ++h;
        }
    }

    private static void checkVMTest(Host host, String test, double no, String name) {
        if (RoboTest.abortWithMouseMovement()) {
            return;
        }
        if (!aborted) {
            host.checkVMTest(test, no, name);
        }
    }

    private static void checkVMTest(String test, double no, String name) {
        for (Host host : cluster.getHosts()) {
            if (RoboTest.abortWithMouseMovement()) {
                return;
            }
            if (aborted) continue;
            host.checkVMTest(test, no, name);
        }
    }

    private static void startTest1() {
        int i;
        slowFactor = 0.4f;
        aborted = false;
        int ipX = 235;
        int ipY = 207;
        int gx = 230;
        int gy = 305;
        int popX = 340;
        int popY = 257;
        int statefulX = 500;
        int statefulY = 207;
        String testName = "test1";
        String pmV = cluster.getHostsArray()[0].getPacemakerVersion();
        try {
            if (pmV != null && Tools.compareVersions(pmV, "1.1.6") < 0) {
                testName = "test1-1.0";
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        RoboTest.disableStonith();
        RoboTest.checkTest(testName, 1.0);
        RoboTest.enableStonith();
        RoboTest.checkTest(testName, 1.1);
        RoboTest.disableStonith();
        RoboTest.checkTest(testName, 1.0);
        RoboTest.moveTo(235, 207);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Filesystem + Linbit:DRBD");
        RoboTest.moveTo("IPaddr2");
        RoboTest.leftClick();
        RoboTest.removeResource(235, 207, false);
        RoboTest.moveTo(235, 207);
        RoboTest.rightClick();
        RoboTest.moveTo("Add Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Filesystem + Linbit:DRBD");
        RoboTest.moveTo("IPaddr2");
        RoboTest.leftClick();
        RoboTest.moveTo("IPv4 address", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.press(10);
        RoboTest.press(49);
        RoboTest.press(48);
        RoboTest.press(48);
        RoboTest.sleep(1000.0);
        RoboTest.setTimeouts(false);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.moveTo("CIDR netmask", Widget.MTextField.class);
        RoboTest.sleep(3000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(50);
        RoboTest.sleep(200.0);
        RoboTest.press(52);
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.checkTest(testName, 2.0);
        RoboTest.moveScrollBar(true);
        RoboTest.moveTo("pingd", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(200.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.checkTest(testName, 2.1);
        RoboTest.moveTo("pingd", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(500.0);
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(200.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveScrollBar(false);
        RoboTest.moveTo(230, 305);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.moveTo(276, 316);
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.removeResource(230, 305, false);
        RoboTest.moveTo(230, 305);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group");
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("OCF Resource Agents");
        RoboTest.sleep(1000.0);
        RoboTest.typeDummy();
        RoboTest.sleep(1000.0);
        RoboTest.removeResource(230, 305, false);
        RoboTest.moveTo(230, 305);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group");
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("OCF Resource Agents");
        RoboTest.sleep(1000.0);
        RoboTest.typeDummy();
        RoboTest.sleep(1000.0);
        RoboTest.moveToMenu("Dummy (1)");
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove Service");
        RoboTest.leftClick();
        RoboTest.removeResource(230, 305, false);
        RoboTest.moveTo(230, 305);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group");
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("OCF Resource Agents");
        RoboTest.sleep(1000.0);
        RoboTest.typeDummy();
        RoboTest.sleep(1000.0);
        RoboTest.removeResource(230, 305, false);
        RoboTest.moveTo(230, 305);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group");
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 2.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("OCF Resource Agents");
        RoboTest.sleep(1000.0);
        RoboTest.typeDummy();
        RoboTest.sleep(1000.0);
        RoboTest.setTimeouts(true);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        for (i = 0; i < 2; ++i) {
            RoboTest.moveTo(240, 280);
            RoboTest.rightClick();
            RoboTest.sleep(10000.0);
            RoboTest.moveTo("Add Group Service");
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("OCF Resource Agents");
            RoboTest.sleep(1000.0);
            RoboTest.typeDummy();
            RoboTest.sleep(i * 300);
            RoboTest.setTimeouts(true);
            RoboTest.moveTo("Apply");
            RoboTest.sleep(6000.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
        }
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 3.0);
        RoboTest.moveTo(240, 280);
        RoboTest.addConstraint(1);
        RoboTest.checkTest(testName, 3.1);
        try {
            if (pmV != null && Tools.compareVersions(pmV, "1.0.8") > 0) {
                for (i = 0; i < 2; ++i) {
                    RoboTest.moveToMenu("Dummy (3)");
                    RoboTest.rightClick();
                    RoboTest.sleep(1000.0);
                    RoboTest.moveTo("Move Up");
                    RoboTest.leftClick();
                    RoboTest.sleepNoFactor(2000.0);
                    RoboTest.checkTest(testName, 3.11);
                    RoboTest.moveToMenu("Dummy (3)");
                    RoboTest.rightClick();
                    RoboTest.moveTo("Move Down");
                    RoboTest.leftClick();
                    RoboTest.sleepNoFactor(2000.0);
                    RoboTest.checkTest(testName, 3.12);
                }
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        RoboTest.moveToMenu("Dummy (3)");
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        RoboTest.moveScrollBar(true);
        for (int i2 = 0; i2 < 2; ++i2) {
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Same As", 2, Widget.MComboBox.class);
            RoboTest.sleep(2000.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
            RoboTest.press(40);
            RoboTest.sleep(20000.0);
            RoboTest.press(40);
            RoboTest.sleep(20000.0);
            RoboTest.press(10);
            RoboTest.sleep(10000.0);
            RoboTest.moveTo("Apply");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.sleep(4000.0);
            RoboTest.checkTest(testName, 3.2);
            RoboTest.moveTo("Same As", 2, Widget.MComboBox.class);
            RoboTest.sleep(2000.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
            RoboTest.press(33);
            RoboTest.sleep(10000.0);
            RoboTest.press(10);
            RoboTest.sleep(10000.0);
            RoboTest.moveTo("Apply");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.sleep(9000.0);
            RoboTest.checkTest(testName, 4.0);
            RoboTest.sleep(2000.0);
        }
        RoboTest.moveScrollBar(false);
        RoboTest.moveTo(255, 207);
        RoboTest.leftClick();
        RoboTest.setLocation(new Integer[]{73});
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 4.1);
        RoboTest.setLocation(new Integer[]{35, 8, 8, 8, 8, 8, 8, 8, 8, 45, 73});
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 4.2);
        RoboTest.setLocation(new Integer[]{35, 8, 8, 8, 8, 8, 8, 8, 8, 8, 521});
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 4.3);
        RoboTest.setLocation(new Integer[]{35, 8, 8, 8, 8, 8, 8, 8, 8, 8});
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 4.4);
        RoboTest.removeConstraint(340, 257);
        RoboTest.checkTest(testName, 5.0);
        RoboTest.moveTo(240, 280);
        RoboTest.addConstraint(1);
        RoboTest.checkTest(testName, 5.1);
        RoboTest.removeConstraint(340, 257);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 5.2);
        RoboTest.sleep(1000.0);
        RoboTest.moveTo(240, 280);
        RoboTest.addConstraint(1);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 6.0);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 7.0);
        RoboTest.addOrder(340, 257);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 8.0);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 9.0);
        RoboTest.addColocation(340, 257);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 10.0);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.1);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.2);
        RoboTest.addConstraintOrderOnly(230, 275, 2);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 10.3);
        RoboTest.addColocation(340, 257);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 10.4);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.5);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.6);
        RoboTest.addConstraintColocationOnly(230, 275, 2);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 10.7);
        RoboTest.addOrder(340, 257);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 10.8);
        RoboTest.removeConstraint(340, 257);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest(testName, 10.9);
        RoboTest.moveTo(235, 207);
        RoboTest.addConstraint(1);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.91);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.92);
        RoboTest.addOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.93);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.94);
        RoboTest.addColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.95);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.96);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.97);
        RoboTest.addConstraintColocationOnly(235, 207, 1);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.98);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 10.99);
        RoboTest.addConstraintOrderOnly(235, 207, 1);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.0);
        RoboTest.addColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.1);
        RoboTest.removeConstraint(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.2);
        RoboTest.moveTo(235, 207);
        RoboTest.addConstraint(3);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.3);
        RoboTest.stopResource(235, 207);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.4);
        RoboTest.resetStartStopResource(235, 207);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.5);
        RoboTest.moveTo(255, 217);
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.moveTo("Menu");
        RoboTest.sleep(2000.0);
        RoboTest.rightClick();
        RoboTest.moveTo("Stop");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.501);
        RoboTest.moveTo(255, 217);
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.moveTo("Menu");
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("tart");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.502);
        RoboTest.resetStartStopResource(235, 207);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.5);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.51);
        RoboTest.addColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.52);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.53);
        RoboTest.addOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.54);
        RoboTest.removeColocation(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.55);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.56);
        RoboTest.addConstraintOrderOnly(235, 207, 3);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.57);
        RoboTest.removeOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.58);
        RoboTest.addConstraintColocationOnly(235, 207, 3);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.59);
        RoboTest.addOrder(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.6);
        RoboTest.removeConstraint(340, 257);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.7);
        RoboTest.moveTo(240, 280);
        RoboTest.addConstraint(1);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 11.8);
        RoboTest.moveTo(500, 207);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Filesystem + Linbit:DRBD");
        RoboTest.moveTo("OCF Resource Agents");
        RoboTest.sleep(1000.0);
        RoboTest.press(83);
        RoboTest.sleep(200.0);
        RoboTest.press(84);
        RoboTest.sleep(200.0);
        RoboTest.press(65);
        RoboTest.sleep(200.0);
        RoboTest.press(84);
        RoboTest.sleep(200.0);
        RoboTest.press(69);
        RoboTest.sleep(200.0);
        RoboTest.press(70);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(5000.0);
        RoboTest.leftClick();
        RoboTest.checkTest(testName, 11.9);
        RoboTest.sleep(3000.0);
        RoboTest.moveTo("Clone Max", Widget.MComboBox.class);
        RoboTest.sleep(3000.0);
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.press(8);
        RoboTest.sleep(3000.0);
        RoboTest.press(49);
        RoboTest.sleep(3000.0);
        RoboTest.setTimeouts(false);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(3000.0);
        RoboTest.leftClick();
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 12.0);
        RoboTest.stopResource(500, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 13.0);
        RoboTest.startResource(500, 207);
        RoboTest.sleep(10000.0);
        RoboTest.checkTest(testName, 14.0);
        RoboTest.unmanageResource(500, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 15.0);
        RoboTest.manageResource(500, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 16.0);
        RoboTest.stopResource(235, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 17.0);
        RoboTest.startResource(235, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 18.0);
        RoboTest.unmanageResource(235, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 19.0);
        RoboTest.manageResource(235, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 20.0);
        RoboTest.migrateResource(235, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 21.0);
        RoboTest.unmigrateResource(235, 207);
        RoboTest.sleep(3000.0);
        RoboTest.checkTest(testName, 22.0);
        RoboTest.stopResource(230, 275);
        RoboTest.sleep(10000.0);
        RoboTest.checkTest(testName, 23.0);
        RoboTest.startResource(230, 275);
        RoboTest.sleep(8000.0);
        RoboTest.checkTest(testName, 24.0);
        RoboTest.unmanageResource(230, 275);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 25.0);
        RoboTest.manageResource(230, 275);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 26.0);
        RoboTest.migrateResource(230, 275);
        RoboTest.sleep(5000.0);
        RoboTest.moveTo(230, 305);
        RoboTest.leftClick();
        RoboTest.checkTest(testName, 27.0);
        RoboTest.moveTo("Menu");
        RoboTest.sleep(6000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove Migration Constraint");
        RoboTest.sleep(12000.0);
        RoboTest.leftClick();
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 28.0);
        RoboTest.moveTo(700, 450);
        RoboTest.leftPress();
        RoboTest.moveTo(220, 115);
        RoboTest.leftRelease();
        RoboTest.moveTo(235, 207);
        RoboTest.rightClick();
        RoboTest.sleep(500.0);
        RoboTest.moveTo(265, 207);
        RoboTest.moveToSlowly(265, 557);
        RoboTest.moveTo(235, 207);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(10);
        RoboTest.checkTest(testName, 28.1);
        RoboTest.moveTo(700, 450);
        RoboTest.leftPress();
        RoboTest.moveTo(220, 115);
        RoboTest.leftRelease();
        RoboTest.moveTo(235, 207);
        RoboTest.rightClick();
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(10);
        RoboTest.checkTest(testName, 28.2);
        RoboTest.moveTo(700, 450);
        RoboTest.leftPress();
        RoboTest.moveTo(220, 115);
        RoboTest.leftRelease();
        RoboTest.moveTo(235, 207);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Stop Selected Services");
        RoboTest.leftClick();
        RoboTest.checkTest(testName, 28.3);
        RoboTest.moveTo(700, 450);
        RoboTest.leftPress();
        RoboTest.moveTo(220, 115);
        RoboTest.leftRelease();
        RoboTest.moveTo(235, 207);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Start Selected Services");
        RoboTest.leftClick();
        RoboTest.checkTest(testName, 28.4);
        RoboTest.sleep(10000.0);
        RoboTest.moveTo(700, 520);
        RoboTest.leftClick();
        RoboTest.stopResource(235, 207);
        RoboTest.sleep(5000.0);
        RoboTest.moveTo(230, 305);
        RoboTest.leftClick();
        RoboTest.moveTo("Menu");
        RoboTest.stopGroup();
        RoboTest.sleep(5000.0);
        RoboTest.moveTo(500, 207);
        RoboTest.stopGroup();
        RoboTest.sleep(5000.0);
        RoboTest.checkTest(testName, 29.0);
        RoboTest.removeResource(235, 207, true);
        RoboTest.sleep(5000.0);
        RoboTest.removeGroup(230, 285);
        RoboTest.sleep(5000.0);
        RoboTest.removeGroup(500, 207);
        if (!aborted) {
            RoboTest.sleepNoFactor(20000.0);
        }
        RoboTest.checkTest(testName, 1.0);
    }

    private static void stopEverything() {
        RoboTest.sleep(10000.0);
        RoboTest.moveTo("Advanced");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo(700, 520);
        RoboTest.rightClick();
        RoboTest.sleep(3000.0);
        RoboTest.moveTo("Stop All Services");
        RoboTest.sleep(3000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Advanced");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
    }

    private static void removeEverything() {
        RoboTest.sleep(10000.0);
        RoboTest.moveTo("Advanced");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo(700, 520);
        RoboTest.rightClick();
        RoboTest.sleep(3000.0);
        RoboTest.moveTo("Remove All Services");
        RoboTest.sleep(3000.0);
        RoboTest.leftClick();
        RoboTest.dialogColorTest("remove everything");
        RoboTest.confirmRemove();
        RoboTest.sleep(3000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Advanced");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
    }

    private static void enableStonith() {
        RoboTest.moveTo(265, 202);
        RoboTest.leftClick();
        String stonith = cluster.getBrowser().getClusterStatus().getGlobalParam("stonith-enabled");
        if (stonith != null && "false".equals(stonith)) {
            RoboTest.moveTo("Stonith Enabled", JCheckBox.class);
            RoboTest.leftClick();
            RoboTest.moveTo("Apply All");
        }
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
    }

    private static void disableStonith() {
        String quorum;
        RoboTest.moveTo(265, 202);
        RoboTest.leftClick();
        boolean apply = false;
        String stonith = cluster.getBrowser().getClusterStatus().getGlobalParam("stonith-enabled");
        if (stonith == null || "true".equals(stonith)) {
            RoboTest.moveTo("Stonith Enabled", JCheckBox.class);
            RoboTest.leftClick();
            apply = true;
        }
        if (!"ignore".equals(quorum = cluster.getBrowser().getClusterStatus().getGlobalParam("no-quorum-policy"))) {
            RoboTest.moveTo("No Quorum Policy", Widget.MComboBox.class);
            RoboTest.leftClick();
            RoboTest.press(40);
            RoboTest.press(38);
            RoboTest.press(38);
            RoboTest.press(10);
            apply = true;
        }
        if (apply) {
            RoboTest.moveTo("Apply All");
            RoboTest.sleep(2000.0);
            RoboTest.leftClick();
        }
    }

    private static void startTest2() {
        slowFactor = 0.6f;
        aborted = false;
        int dummy1X = 235;
        int dummy1Y = 207;
        int dummy2X = 545;
        int dummy2Y = 207;
        int dummy3X = 235;
        int dummy3Y = 342;
        int dummy4X = 545;
        int dummy4Y = 342;
        int phX = 445;
        int phY = 342;
        RoboTest.disableStonith();
        RoboTest.checkTest("test2", 1.0);
        RoboTest.chooseDummy(235, 207, false, true);
        RoboTest.chooseDummy(545, 207, false, true);
        RoboTest.chooseDummy(235, 342, false, true);
        RoboTest.chooseDummy(545, 342, false, true);
        RoboTest.checkTest("test2", 2.0);
        RoboTest.moveTo(445, 342);
        RoboTest.rightClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Placeholder (AND)");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkTest("test2", 3.0);
        RoboTest.moveTo(445, 342);
        RoboTest.addConstraint(1);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(5000.0);
        RoboTest.checkTest("test2", 4.0);
        int dum1PopX = 365;
        int dum1PopY = 257;
        for (int i = 0; i < 1; ++i) {
            RoboTest.removeOrder(365, 257);
            RoboTest.sleep(4000.0);
            RoboTest.checkTest("test2", 5.0);
            RoboTest.addOrder(365, 257);
            RoboTest.sleep(4000.0);
            RoboTest.checkTest("test2", 6.0);
            RoboTest.removeColocation(365, 257);
            RoboTest.sleep(5000.0);
            RoboTest.checkTest("test2", 7.0);
            RoboTest.addColocation(365, 257);
            RoboTest.sleep(4000.0);
            RoboTest.checkTest("test2", 8.0);
        }
        RoboTest.moveTo(235, 342);
        RoboTest.addConstraint(5);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest("test2", 9.0);
        int dum3PopX = 400;
        int dum3PopY = 332;
        for (int i = 0; i < 2; ++i) {
            RoboTest.removeColocation(400, 332);
            RoboTest.sleep(4000.0);
            RoboTest.checkTest("test2", 9.1);
            RoboTest.addColocation(400, 332);
            RoboTest.sleep(4000.0);
            RoboTest.checkTest("test2", 9.2);
            RoboTest.removeOrder(400, 332);
            RoboTest.sleep(5000.0);
            RoboTest.checkTest("test2", 9.3);
            RoboTest.addOrder(400, 332);
            RoboTest.sleep(4000.0);
            RoboTest.checkTest("test2", 9.4);
        }
        RoboTest.moveTo(445, 342);
        RoboTest.addConstraint(1);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest("test2", 10.0);
        RoboTest.moveTo(545, 342);
        RoboTest.addConstraint(5);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest("test2", 11.0);
        int dum2PopX = 535;
        int dum2PopY = 277;
        RoboTest.removeConstraint(535, 277);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.1);
        RoboTest.addConstraintOrderOnly(445, 342, 2);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.2);
        RoboTest.removeOrder(535, 277);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.3);
        RoboTest.addConstraintColocationOnly(445, 342, 2);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.4);
        RoboTest.addOrder(535, 277);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.5);
        int dum4PopX = 505;
        int dum4PopY = 332;
        RoboTest.removeConstraint(505, 332);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.6);
        RoboTest.moveTo(565, 347);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.addConstraintColocationOnly(545, 342, 5);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.7);
        RoboTest.removeColocation(505, 332);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.8);
        RoboTest.moveTo(565, 347);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.addConstraintOrderOnly(545, 342, 5);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.9);
        RoboTest.addColocation(505, 332);
        RoboTest.sleep(4000.0);
        RoboTest.checkTest("test2", 11.91);
        RoboTest.stopResource(235, 207);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest("test2", 11.92);
        RoboTest.removeResource(235, 207, true);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest("test2", 12.0);
        RoboTest.stopResource(545, 207);
        RoboTest.sleep(10000.0);
        RoboTest.stopResource(235, 342);
        RoboTest.sleep(10000.0);
        RoboTest.stopResource(235, 342);
        RoboTest.sleep(10000.0);
        RoboTest.stopResource(545, 342);
        RoboTest.stopEverything();
        RoboTest.sleep(10000.0);
        RoboTest.checkTest("test2", 12.5);
        if (RoboTest.maybe()) {
            RoboTest.moveTo(445, 342);
            RoboTest.rightClick();
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Remove");
            RoboTest.leftClick();
            RoboTest.confirmRemove();
            RoboTest.sleep(5000.0);
            RoboTest.removeResource(545, 207, true);
            RoboTest.sleep(5000.0);
            RoboTest.checkTest("test2", 14.0);
            RoboTest.removeResource(235, 342, true);
            RoboTest.sleep(5000.0);
            RoboTest.checkTest("test2", 15.0);
            RoboTest.removeResource(545, 342, true);
            RoboTest.sleep(5000.0);
        } else {
            RoboTest.removeEverything();
        }
        if (!aborted) {
            RoboTest.sleepNoFactor(20000.0);
        }
        RoboTest.checkTest("test2", 16.0);
    }

    private static void startTest4() {
        slowFactor = 0.6f;
        aborted = false;
        int dummy1X = 235;
        int dummy1Y = 207;
        int dummy2X = 545;
        int dummy2Y = 207;
        int dummy3X = 235;
        int dummy3Y = 346;
        int dummy4X = 545;
        int dummy4Y = 346;
        int dummy5X = 235;
        int dummy5Y = 505;
        int dummy6X = 545;
        int dummy6Y = 505;
        int ph1X = 445;
        int ph1Y = 266;
        int ph2X = 445;
        int ph2Y = 425;
        RoboTest.disableStonith();
        RoboTest.checkTest("test4", 1.0);
        RoboTest.chooseDummy(235, 207, false, true);
        RoboTest.chooseDummy(545, 207, false, true);
        RoboTest.chooseDummy(235, 346, false, true);
        RoboTest.chooseDummy(545, 346, false, true);
        RoboTest.chooseDummy(235, 505, false, true);
        RoboTest.chooseDummy(545, 505, false, true);
        RoboTest.checkTest("test4", 2.0);
        boolean count = true;
        for (int i = 0; i < 1; ++i) {
            RoboTest.moveTo(445, 266);
            RoboTest.rightClick();
            RoboTest.sleep(2000.0);
            RoboTest.moveTo("Placeholder (AND)");
            RoboTest.sleep(2000.0);
            RoboTest.leftClick();
            RoboTest.moveTo(445, 425);
            RoboTest.rightClick();
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Placeholder (AND)");
            RoboTest.sleep(1000.0);
            RoboTest.leftClick();
            RoboTest.checkTest("test4", 2.0);
            RoboTest.moveToMenu("Dummy (5)");
            RoboTest.addConstraint(7);
            RoboTest.moveToMenu("Dummy (6)");
            RoboTest.addConstraint(7);
            RoboTest.moveTo(445, 425);
            RoboTest.addConstraint(3);
            RoboTest.moveTo(445, 425);
            RoboTest.addConstraint(3);
            RoboTest.moveTo(235, 346);
            RoboTest.addConstraint(4);
            RoboTest.moveTo(545, 346);
            RoboTest.addConstraint(4);
            RoboTest.moveTo(445, 266);
            RoboTest.addConstraint(1);
            RoboTest.moveTo(445, 266);
            RoboTest.addConstraint(1);
            RoboTest.checkTest("test4", 2.0);
            if (i >= 0) continue;
            RoboTest.removePlaceHolder(445, 266, true);
            RoboTest.removePlaceHolder(445, 425, true);
        }
        RoboTest.moveTo("Apply");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkTest("test4", 3.0);
        RoboTest.stopEverything();
        RoboTest.checkTest("test4", 4.0);
        RoboTest.removeEverything();
        RoboTest.sleep(40000.0);
    }

    private static void startTest5(int count) {
        slowFactor = 0.2f;
        aborted = false;
        int dummy1X = 235;
        int dummy1Y = 207;
        int dummy2X = 500;
        int dummy2Y = 207;
        int ph1X = 380;
        int ph1Y = 452;
        RoboTest.disableStonith();
        RoboTest.checkTest("test5", 1.0);
        RoboTest.moveTo(380, 452);
        RoboTest.rightClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Placeholder (AND)");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.chooseDummy(235, 207, false, true);
        RoboTest.chooseDummy(500, 207, false, true);
        RoboTest.checkTest("test5", 2.0);
        RoboTest.moveTo(500, 207);
        RoboTest.addConstraint(2);
        RoboTest.sleep(20000.0);
        RoboTest.checkTest("test5", 2.0);
        RoboTest.moveTo(380, 452);
        RoboTest.addConstraint(1);
        RoboTest.moveTo(380, 452);
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkTest("test5", 2.1);
        int dum1PopX = 315;
        int dum1PopY = 267;
        RoboTest.removeConstraint(315, 267);
        RoboTest.checkTest("test5", 2.5);
        for (int i = 1; i <= count; ++i) {
            RoboTest.moveTo(235, 207);
            RoboTest.addConstraint(2);
            RoboTest.checkTest("test5", 3.0);
            RoboTest.removeConstraint(315, 267);
            RoboTest.checkTest("test5", 2.5);
            RoboTest.moveTo(380, 452);
            RoboTest.addConstraint(1);
            RoboTest.checkTest("test5", 3.5);
            RoboTest.removeConstraint(315, 267);
            RoboTest.checkTest("test5", 2.5);
            RoboTest.info("i: " + i);
        }
        RoboTest.stopEverything();
        RoboTest.checkTest("test5", 3.1);
        RoboTest.removeResource(235, 207, true);
        RoboTest.removeResource(500, 207, true);
        RoboTest.removePlaceHolder(380, 452, false);
        RoboTest.sleep(5000.0);
        RoboTest.checkTest("test5", 1.0);
    }

    private static void startTest6(int count) {
        slowFactor = 0.2f;
        aborted = false;
        int dummy1X = 235;
        int dummy1Y = 207;
        int ph1X = 315;
        int ph1Y = 346;
        RoboTest.moveTo(315, 346);
        RoboTest.rightClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Placeholder (AND)");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.chooseDummy(235, 207, false, true);
        int dum1PopX = 305;
        int dum1PopY = 267;
        for (int i = 0; i < count; ++i) {
            if (i % 5 == 0) {
                RoboTest.info("test6 i: " + i);
            }
            RoboTest.moveTo(315, 346);
            RoboTest.addConstraint(1);
            if (!aborted) {
                RoboTest.sleepNoFactor(2000.0);
            }
            RoboTest.removeConstraint(305, 267);
        }
        RoboTest.stopEverything();
        RoboTest.sleepNoFactor(20000.0);
        RoboTest.removeEverything();
        RoboTest.sleepNoFactor(20000.0);
        RoboTest.resetTerminalAreas();
    }

    private static void startTest7(int count) {
        slowFactor = 0.5f;
        aborted = false;
        int dummy1X = 235;
        int dummy1Y = 207;
        RoboTest.disableStonith();
        for (int i = count; i > 0; --i) {
            if (i % 5 == 0) {
                RoboTest.info("test7 I: " + i);
            }
            RoboTest.checkTest("test7", 1.0);
            RoboTest.sleep(5000.0);
            RoboTest.chooseDummy(235, 207, false, true);
            RoboTest.checkTest("test7", 2.0);
            RoboTest.sleep(5000.0);
            RoboTest.stopResource(235, 207);
            RoboTest.checkTest("test7", 3.0);
            RoboTest.sleep(5000.0);
            RoboTest.moveTo(245, 217);
            RoboTest.leftClick();
            robot.keyPress(17);
            RoboTest.press(67);
            RoboTest.press(86);
            robot.keyRelease(17);
            RoboTest.moveTo(245, 297);
            RoboTest.leftClick();
            RoboTest.moveTo("Apply");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.checkTest("test7", 4.0);
            RoboTest.removeResource(235, 207, true);
            RoboTest.removeResource(235, 297, true);
        }
        System.gc();
    }

    private static void startTest8(int count) {
        slowFactor = 0.2f;
        aborted = false;
        int dummy1X = 540;
        int dummy1Y = 202;
        RoboTest.disableStonith();
        RoboTest.checkTest("test8", 1.0);
        for (int i = count; i > 0; --i) {
            if (i % 5 == 0) {
                RoboTest.info("test8 i: " + i);
            }
            RoboTest.sleep(5000.0);
            RoboTest.chooseDummy(540, 202, false, true);
            RoboTest.sleep(5000.0);
            RoboTest.moveTo(550, 202);
            RoboTest.leftPress();
            RoboTest.moveTo(300, 202);
            RoboTest.leftRelease();
        }
        RoboTest.checkTest("test8-" + count, 2.0);
        RoboTest.stopEverything();
        RoboTest.checkTest("test8-" + count, 3.0);
        RoboTest.removeEverything();
        RoboTest.checkTest("test8", 4.0);
        RoboTest.resetTerminalAreas();
    }

    private static void startTestA(int count) {
        slowFactor = 0.5f;
        aborted = false;
        int gx = 235;
        int gy = 207;
        RoboTest.disableStonith();
        for (int i = count; i > 0; --i) {
            if (i % 5 == 0) {
                RoboTest.info("testA I: " + i);
            }
            RoboTest.checkTest("testA", 1.0);
            RoboTest.moveTo(235, 207);
            RoboTest.sleep(1000.0);
            RoboTest.rightClick();
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Add Group");
            RoboTest.leftClick();
            RoboTest.sleep(3000.0);
            RoboTest.moveTo(281, 218);
            RoboTest.rightClick();
            RoboTest.sleep(2000.0);
            RoboTest.moveTo("Add Group Service");
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("OCF Resource Agents");
            RoboTest.sleep(1000.0);
            RoboTest.typeDummy();
            RoboTest.sleep(300.0);
            RoboTest.setTimeouts(true);
            RoboTest.moveTo("Apply");
            RoboTest.sleep(6000.0);
            RoboTest.leftClick();
            RoboTest.sleep(6000.0);
            RoboTest.checkTest("testA", 2.0);
            RoboTest.stopResource(235, 207);
            RoboTest.sleep(6000.0);
            RoboTest.checkTest("testA", 3.0);
            RoboTest.moveTo(245, 217);
            RoboTest.leftClick();
            robot.keyPress(17);
            RoboTest.press(67);
            RoboTest.press(86);
            robot.keyRelease(17);
            RoboTest.moveTo(245, 297);
            RoboTest.leftClick();
            RoboTest.moveTo("Apply");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.checkTest("testA", 4.0);
            RoboTest.removeResource(235, 207, true);
            RoboTest.removeResource(235, 297, true);
            RoboTest.resetTerminalAreas();
        }
        System.gc();
    }

    private static void startTestB(int count) {
        slowFactor = 0.5f;
        aborted = false;
        int dummy1X = 235;
        int dummy1Y = 207;
        RoboTest.disableStonith();
        String testName = "testB";
        for (int i = count; i > 0; --i) {
            if (i % 5 == 0) {
                RoboTest.info(testName + " I: " + i);
            }
            RoboTest.checkTest(testName, 1.0);
            RoboTest.sleep(5000.0);
            RoboTest.chooseDummy(235, 207, true, true);
            RoboTest.checkTest(testName, 2.0);
            RoboTest.sleep(5000.0);
            RoboTest.stopResource(235, 207);
            RoboTest.checkTest(testName, 3.0);
            RoboTest.sleep(5000.0);
            RoboTest.moveTo(245, 217);
            RoboTest.leftClick();
            robot.keyPress(17);
            RoboTest.press(67);
            RoboTest.press(86);
            robot.keyRelease(17);
            RoboTest.moveTo(245, 297);
            RoboTest.leftClick();
            RoboTest.moveTo("Apply");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.checkTest("testB", 4.0);
            RoboTest.removeResource(235, 297, true);
            RoboTest.removeResource(235, 207, true);
            RoboTest.resetTerminalAreas();
        }
        System.gc();
    }

    private static void startTestC(int count) {
        slowFactor = 0.5f;
        int statefulX = 500;
        int statefulY = 207;
        RoboTest.disableStonith();
        String testName = "testC";
        for (int i = count; i > 0; --i) {
            if (i % 5 == 0) {
                RoboTest.info(testName + " I: " + i);
            }
            RoboTest.checkTest(testName, 1.0);
            RoboTest.moveTo(500, 207);
            RoboTest.rightClick();
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Add Service");
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Filesystem + Linbit:DRBD");
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("OCF Resource Agents");
            RoboTest.sleep(1000.0);
            RoboTest.press(83);
            RoboTest.sleep(200.0);
            RoboTest.press(84);
            RoboTest.sleep(200.0);
            RoboTest.press(65);
            RoboTest.sleep(200.0);
            RoboTest.press(84);
            RoboTest.sleep(200.0);
            RoboTest.press(69);
            RoboTest.sleep(200.0);
            RoboTest.press(70);
            RoboTest.sleep(200.0);
            RoboTest.press(10);
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Apply");
            RoboTest.sleep(1000.0);
            RoboTest.leftClick();
            RoboTest.sleep(4000.0);
            RoboTest.stopResource(500, 207);
            RoboTest.checkTest(testName, 2.0);
            RoboTest.sleep(5000.0);
            RoboTest.moveTo(500, 207);
            RoboTest.leftClick();
            robot.keyPress(17);
            RoboTest.press(67);
            RoboTest.press(86);
            robot.keyRelease(17);
            RoboTest.moveTo(245, 297);
            RoboTest.leftClick();
            RoboTest.moveTo("Apply");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.checkTest(testName, 4.0);
            RoboTest.removeResource(500, 207, true);
            RoboTest.removeResource(245, 297, true);
            RoboTest.resetTerminalAreas();
        }
    }

    private static void startTestD(int count) {
        slowFactor = 0.2f;
        aborted = false;
        int dummy1X = 540;
        int dummy1Y = 202;
        for (int i = count; i > 0; --i) {
            if (i % 5 == 0) {
                RoboTest.info("testD 1 I: " + i);
            }
            RoboTest.chooseDummy(540, 202, false, false);
            RoboTest.removeResource(540, 202, false);
        }
        RoboTest.chooseDummy(540, 202, false, false);
        int pos = 0;
        for (int i = count; i > 0; --i) {
            double rand;
            if (i % 5 == 0) {
                RoboTest.info("testD 2 I: " + i);
            }
            if ((rand = Math.random()) < 0.33) {
                if (pos == 1) continue;
                pos = 1;
                RoboTest.moveTo(796, 199);
                RoboTest.leftClick();
                continue;
            }
            if (rand < 0.66) {
                if (pos == 2) continue;
                pos = 2;
                RoboTest.moveTo(894, 200);
                RoboTest.leftClick();
                continue;
            }
            if (pos == 3) continue;
            pos = 3;
            RoboTest.moveTo(994, 200);
            RoboTest.leftClick();
        }
        RoboTest.removeResource(540, 202, false);
    }

    private static void startTestE(int count) {
        slowFactor = 0.2f;
        aborted = false;
        for (int i = count; i > 0; --i) {
            if (i % 10 == 0) {
                RoboTest.info("testE I: " + i);
            }
            RoboTest.moveTo(300, 152);
            RoboTest.sleep(2000.0);
            RoboTest.rightClick();
            RoboTest.sleep(9000.0);
            RoboTest.moveTo("Host Wizard");
            RoboTest.sleep(2000.0);
            RoboTest.leftClick();
            RoboTest.sleep(30000.0);
            RoboTest.moveTo("Cancel");
            RoboTest.sleep(2000.0);
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
        }
    }

    private static void startTestF(int count) {
        slowFactor = 0.2f;
        aborted = false;
        int gx = 235;
        int gy = 207;
        RoboTest.disableStonith();
        String testName = "testF";
        String distro = cluster.getHostsArray()[0].getDist();
        RoboTest.checkTest(testName, 1.0);
        RoboTest.moveTo(235, 207);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Group");
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Clone");
        RoboTest.leftClick();
        boolean type = true;
        for (int i = count; i > 0; --i) {
            RoboTest.info("I: " + i);
            RoboTest.moveToMenu("Group (1)");
            RoboTest.rightClick();
            RoboTest.sleep(2000.0);
            RoboTest.moveTo("Add Group Service");
            RoboTest.moveTo("OCF Resource Agents");
            RoboTest.sleep(1000.0);
            RoboTest.typeDummy();
            RoboTest.sleep(300.0);
            RoboTest.setTimeouts(true);
            RoboTest.moveTo("Apply");
            RoboTest.sleep(6000.0);
            RoboTest.leftClick();
            RoboTest.sleep(6000.0);
        }
        RoboTest.checkTest(testName, 2.0);
        RoboTest.moveTo("Resource Stickiness", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(8);
        RoboTest.sleep(200.0);
        RoboTest.press(50);
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(6000.0);
        RoboTest.checkTest(testName, 3.0);
        RoboTest.stopResource(235, 207);
        RoboTest.sleep(6000.0);
        RoboTest.checkTest(testName, 4.0);
        RoboTest.removeResource(235, 207, true);
        RoboTest.resetTerminalAreas();
        System.gc();
    }

    private static void startGUITest1(int count) {
        slowFactor = 0.2f;
        aborted = false;
        for (int i = count; i > 0; --i) {
            if (i % 10 == 0) {
                RoboTest.info("gui-test1 I: " + i);
            }
            RoboTest.moveTo("Add Host / Wizard");
            RoboTest.sleep(500.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
            if (!RoboTest.isColor(360, 442, new Color(255, 100, 100), true)) {
                RoboTest.info("gui-test1 1: error");
                break;
            }
            boolean ok = false;
            for (int error = 0; error < 5; ++error) {
                RoboTest.sleep(100.0);
                RoboTest.press(88);
                if (RoboTest.isColor(360, 442, new Color(255, 100, 100), false)) continue;
                RoboTest.sleepNoFactor(1000.0);
                ok = true;
                break;
            }
            if (!ok) {
                RoboTest.info("gui-test1 2: failed");
                break;
            }
            RoboTest.moveTo(910, 517);
            RoboTest.sleep(500.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
        }
    }

    private static void startGUITest2(int count) {
        slowFactor = 0.2f;
        aborted = false;
        for (int i = count; i > 0; --i) {
            if (i % 10 == 0) {
                RoboTest.info("gui-test2 " + i);
            }
            RoboTest.moveTo("Add Cluster / Wizard");
            RoboTest.sleep(500.0);
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
            if (!RoboTest.isColor(336, 472, new Color(184, 207, 229), true)) {
                RoboTest.info("gui-test2: error");
                break;
            }
            RoboTest.moveTo("Cancel");
            RoboTest.sleep(500.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
        }
    }

    private static void setLocation(Integer[] events) {
        RoboTest.moveScrollBar(true);
        RoboTest.moveTo("on ", Widget.MComboBox.class);
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        Integer[] arr$ = events;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int ev = arr$[i$];
            if (ev == 521) {
                robot.keyPress(16);
                RoboTest.sleep(400.0);
            }
            RoboTest.press(ev);
            RoboTest.sleep(400.0);
            if (ev != 521) continue;
            robot.keyRelease(16);
            RoboTest.sleep(400.0);
        }
        RoboTest.moveTo("Apply");
        RoboTest.sleep(4000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveScrollBar(false);
    }

    private static void typeDummy() {
        RoboTest.press(68);
        RoboTest.sleep(200.0);
        RoboTest.press(85);
        RoboTest.sleep(200.0);
        RoboTest.press(77);
        RoboTest.sleep(200.0);
        RoboTest.press(77);
        RoboTest.sleep(200.0);
        RoboTest.press(89);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
    }

    private static void setTimeouts(boolean migrateTimeouts) {
        RoboTest.sleep(3000.0);
        RoboTest.moveScrollBar(true);
        RoboTest.moveTo("Start / Timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(50);
        RoboTest.sleep(2000.0);
        RoboTest.press(48);
        RoboTest.sleep(2000.0);
        RoboTest.press(48);
        RoboTest.sleep(5000.0);
        RoboTest.moveTo("Stop / Timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(49);
        RoboTest.sleep(200.0);
        RoboTest.press(57);
        RoboTest.sleep(200.0);
        RoboTest.press(50);
        RoboTest.sleep(5000.0);
        RoboTest.moveTo("Monitor / Timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(49);
        RoboTest.sleep(200.0);
        RoboTest.press(53);
        RoboTest.sleep(200.0);
        RoboTest.press(52);
        RoboTest.sleep(5000.0);
        RoboTest.moveTo("Monitor / Interval", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(49);
        RoboTest.sleep(200.0);
        RoboTest.press(50);
        RoboTest.sleep(200.0);
        RoboTest.press(49);
        RoboTest.sleep(5000.0);
        if (migrateTimeouts) {
            RoboTest.moveTo("Reload / Timeout", Widget.MTextField.class);
            RoboTest.leftClick();
            RoboTest.press(8);
            RoboTest.sleep(200.0);
            RoboTest.press(8);
            RoboTest.sleep(5000.0);
            RoboTest.moveTo("Migrate_to / Timeout", Widget.MTextField.class);
            RoboTest.leftClick();
            RoboTest.press(49);
            RoboTest.sleep(200.0);
            RoboTest.press(50);
            RoboTest.sleep(200.0);
            RoboTest.press(51);
            RoboTest.sleep(5000.0);
            RoboTest.moveTo("Migrate_from / T", Widget.MTextField.class);
            RoboTest.leftClick();
            RoboTest.press(49);
            RoboTest.sleep(200.0);
            RoboTest.press(50);
            RoboTest.sleep(200.0);
            RoboTest.press(50);
            RoboTest.sleep(5000.0);
        }
        RoboTest.moveScrollBar(false);
    }

    public static void sleepNoFactor(double x) {
        RoboTest.sleep(x / (double)slowFactor);
    }

    private static void sleep(double x) {
        if (RoboTest.abortWithMouseMovement()) {
            return;
        }
        if (!aborted) {
            double sleepTime = x * (double)slowFactor + x * (double)slowFactor * Math.random();
            double step = 100.0;
            double rest = sleepTime;
            for (double i = 100.0; i < sleepTime; i += 100.0) {
                Tools.sleep(100);
                if (RoboTest.abortWithMouseMovement()) {
                    return;
                }
                rest -= 100.0;
            }
            if (rest > 0.0) {
                Tools.sleep((int)rest);
            }
        }
    }

    private static boolean maybe() {
        return Math.random() < 0.5;
    }

    private static void chooseDummy(int x, int y, boolean clone, boolean apply) {
        RoboTest.moveTo(x, y);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Service");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Filesystem + Linbit:DRBD");
        RoboTest.moveTo("OCF Resource Agents");
        RoboTest.sleep(2000.0);
        RoboTest.typeDummy();
        if (apply) {
            RoboTest.sleep(2000.0);
            RoboTest.setTimeouts(true);
            if (clone) {
                RoboTest.moveTo(893, 202);
                RoboTest.leftClick();
            }
            RoboTest.moveTo("Apply");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
        }
    }

    private static void removeResource(int x, int y, boolean confirm) {
        RoboTest.moveTo(x + 20, y);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove Service");
        RoboTest.leftClick();
        if (confirm) {
            RoboTest.confirmRemove();
        }
    }

    private static void removeGroup(int x, int y) {
        RoboTest.moveTo(x + 20, y);
        RoboTest.rightClick();
        RoboTest.sleep(10000.0);
        RoboTest.moveTo("Remove Service");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
    }

    private static void removePlaceHolder(int x, int y, boolean confirm) {
        RoboTest.moveTo(x + 20, y);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove");
        RoboTest.leftClick();
        if (confirm) {
            RoboTest.confirmRemove();
        }
    }

    private static void confirmRemove() {
        RoboTest.sleep(1000.0);
        RoboTest.dialogColorTest("confirm remove");
        RoboTest.press(9);
        RoboTest.sleep(500.0);
        RoboTest.press(9);
        RoboTest.sleep(500.0);
        RoboTest.press(32);
        RoboTest.sleep(500.0);
    }

    private static void stopResource(int x, int y) {
        RoboTest.moveTo(x + 50, y + 5);
        RoboTest.sleep(2000.0);
        RoboTest.rightClick();
        RoboTest.moveTo("Stop");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void stopGroup() {
        RoboTest.rightClick();
        RoboTest.sleep(3000.0);
        RoboTest.moveTo("Stop");
        RoboTest.sleep(10000.0);
        RoboTest.leftClick();
    }

    private static void resetStartStopResource(int x, int y) {
        RoboTest.moveTo(x + 50, y + 5);
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Target Role", Widget.MComboBox.class);
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(38);
        RoboTest.sleep(500.0);
        RoboTest.press(38);
        RoboTest.sleep(500.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void startResource(int x, int y) {
        RoboTest.moveTo(x + 50, y + 5);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.moveTo("tart");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void migrateResource(int x, int y) {
        RoboTest.moveTo(x + 50, y + 5);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Migrate FROM");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void unmigrateResource(int x, int y) {
        RoboTest.moveTo(x + 50, y + 5);
        RoboTest.sleep(6000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove Migration Constraint");
        RoboTest.sleep(12000.0);
        RoboTest.leftClick();
    }

    private static void unmanageResource(int x, int y) {
        RoboTest.moveTo(x + 50, y + 5);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Do not manage by CRM");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void manageResource(int x, int y) {
        RoboTest.moveTo(x + 50, y + 5);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Manage by CRM");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void addConstraint(int number) {
        RoboTest.rightClick();
        RoboTest.sleep(5000.0);
        RoboTest.moveTo("Start Before");
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        for (int i = 0; i < number; ++i) {
            RoboTest.press(40);
            RoboTest.sleep(500.0);
        }
        RoboTest.press(10);
    }

    private static void addConstraintOrderOnly(int x, int y, int number) {
        RoboTest.moveTo(x + 20, y + 5);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Start Before");
        RoboTest.sleep(500.0);
        RoboTest.leftClick();
        RoboTest.press(9);
        RoboTest.sleep(200.0);
        RoboTest.press(32);
        RoboTest.sleep(200.0);
        RoboTest.press(9);
        RoboTest.sleep(200.0);
        RoboTest.press(9);
        RoboTest.sleep(200.0);
        for (int i = 0; i < number; ++i) {
            RoboTest.press(40);
            RoboTest.sleep(200.0);
        }
        RoboTest.press(10);
    }

    private static void addConstraintColocationOnly(int x, int y, int number) {
        RoboTest.moveTo(x + 20, y + 5);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Start Before");
        RoboTest.sleep(500.0);
        RoboTest.leftClick();
        RoboTest.press(9);
        RoboTest.sleep(200.0);
        RoboTest.press(9);
        RoboTest.sleep(200.0);
        RoboTest.press(32);
        RoboTest.sleep(200.0);
        RoboTest.press(9);
        RoboTest.sleep(200.0);
        for (int i = 0; i < number; ++i) {
            RoboTest.press(40);
            RoboTest.sleep(200.0);
        }
        RoboTest.press(10);
    }

    private static void removeConstraint(int popX, int popY) {
        RoboTest.moveTo(popX, popY);
        RoboTest.sleep(10000.0);
        RoboTest.rightClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Remove Colocation and Order");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void removeOrder(int popX, int popY) {
        RoboTest.moveTo(popX, popY);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove Order");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void addOrder(int popX, int popY) {
        RoboTest.moveTo(popX, popY);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Order");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void removeColocation(int popX, int popY) {
        RoboTest.moveTo(popX, popY);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("emove Colocation");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void addColocation(int popX, int popY) {
        RoboTest.moveTo(popX, popY);
        RoboTest.sleep(1000.0);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("dd Colocation");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
    }

    private static void startTest3(int count) {
        slowFactor = 0.3f;
        aborted = false;
        RoboTest.disableStonith();
        String testName = "test3";
        for (int i = count; i > 0; --i) {
            if (i % 5 == 0) {
                RoboTest.info(testName + " I: " + i);
            }
            RoboTest.checkTest(testName, 1.0);
            RoboTest.moveTo(577, 205);
            RoboTest.rightClick();
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Add Service");
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Filesystem + Linbit:DRBD");
            RoboTest.leftClick();
            RoboTest.moveTo("block device", Widget.MComboBox.class);
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
            RoboTest.press(40);
            RoboTest.sleep(200.0);
            RoboTest.press(40);
            RoboTest.sleep(200.0);
            RoboTest.press(10);
            RoboTest.moveTo("mount point", Widget.MComboBox.class);
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
            RoboTest.press(40);
            RoboTest.sleep(200.0);
            RoboTest.press(40);
            RoboTest.sleep(200.0);
            RoboTest.press(10);
            RoboTest.moveTo("filesystem type", Widget.MComboBox.class);
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
            RoboTest.press(69);
            RoboTest.sleep(200.0);
            RoboTest.press(69);
            RoboTest.sleep(200.0);
            RoboTest.press(10);
            RoboTest.moveTo("Apply");
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
            RoboTest.checkTest(testName, 2.0);
            RoboTest.checkNumberOfVertices(testName, 4);
            RoboTest.stopEverything();
            RoboTest.checkTest(testName, 3.0);
            RoboTest.removeEverything();
            RoboTest.resetTerminalAreas();
        }
        System.gc();
    }

    private static void press(int ke) {
        if (aborted) {
            return;
        }
        robot.keyPress(ke);
        robot.keyRelease(ke);
        RoboTest.sleepNoFactor(200.0);
    }

    private static void leftClick() {
        if (aborted) {
            return;
        }
        robot.mousePress(16);
        Tools.sleep(400);
        robot.mouseRelease(16);
        RoboTest.sleepNoFactor(300.0);
    }

    private static void leftPress() {
        if (aborted) {
            return;
        }
        robot.mousePress(16);
        RoboTest.sleepNoFactor(300.0);
    }

    private static void leftRelease() {
        robot.mouseRelease(16);
        if (aborted) {
            return;
        }
        RoboTest.sleepNoFactor(300.0);
    }

    private static void rightClick() {
        if (aborted) {
            return;
        }
        RoboTest.sleepNoFactor(1000.0);
        robot.mousePress(4);
        RoboTest.sleepNoFactor(500.0);
        robot.mouseRelease(4);
        RoboTest.sleep(6000.0);
    }

    private static boolean isColor(int fromX, int fromY, Color color, boolean expected) {
        if (aborted) {
            return true;
        }
        int xOffset = RoboTest.getOffset();
        Point appP = Tools.getGUIData().getMainFrameContentPane().getLocationOnScreen();
        int appX = (int)((Point2D)appP).getX() + fromX;
        int appY = (int)((Point2D)appP).getY() + fromY;
        for (int i = 0; i < 7; ++i) {
            boolean isColor = false;
            for (int y = -20; y < 20; ++y) {
                if (i > 0) {
                    RoboTest.moveTo(fromX - i, fromY + y);
                }
                if (expected) {
                    if (color.equals(robot.getPixelColor(appX + xOffset - i, appY + y))) {
                        return true;
                    }
                } else if (color.equals(robot.getPixelColor(appX + xOffset - i, appY + y))) {
                    isColor = true;
                }
                if (!aborted) continue;
                return false;
            }
            if (!expected && !isColor) {
                return false;
            }
            Tools.sleep(500 * i);
        }
        return !expected;
    }

    private static void moveToSlowly(int toX, int toY) {
        slowFactor *= 50.0f;
        RoboTest.moveTo(toX, toY);
        slowFactor /= 50.0f;
    }

    private static void moveTo(int toX, int toY) {
        if (aborted) {
            return;
        }
        prevP = null;
        Point origP = MouseInfo.getPointerInfo().getLocation();
        int origX = (int)((Point2D)origP).getX();
        int origY = (int)((Point2D)origP).getY();
        Point endP = Tools.getGUIData().getMainFrameContentPane().getLocationOnScreen();
        int endX = (int)((Point2D)endP).getX() + toX;
        int endY = (int)((Point2D)endP).getY() + toY;
        RoboTest.moveToAbs(endX, endY);
    }

    private static void moveTo(String text) {
        if (aborted) {
            return;
        }
        RoboTest.moveTo(text, null);
    }

    private static void moveScrollBar(boolean down) {
        RoboTest.moveScrollBar(down, 300);
    }

    private static void moveScrollBar(boolean down, int delta) {
        if (aborted) {
            return;
        }
        ArrayList<Component> res = new ArrayList<Component>();
        try {
            RoboTest.findInside((Component)Tools.getGUIData().getMainFrame(), Class.forName("javax.swing.JScrollPane$ScrollBar"), res);
        }
        catch (ClassNotFoundException e) {
            Tools.printStackTrace("can't find the scrollbar");
            return;
        }
        boolean minY = false;
        Component scrollbar = null;
        Container app = Tools.getGUIData().getMainFrameContentPane();
        int mX = (int)app.getLocationOnScreen().getX() + app.getWidth() / 2;
        int mY = (int)app.getLocationOnScreen().getY() + app.getHeight() / 2;
        int scrollbarX = 0;
        int scrollbarY = 0;
        for (Component c : res) {
            Point p = c.getLocationOnScreen();
            int pX = (int)((Point2D)p).getX();
            int pY = (int)((Point2D)p).getY();
            if (pX <= mX || pY >= mY) continue;
            scrollbar = c;
            scrollbarX = pX + c.getWidth() / 2;
            scrollbarY = pY + c.getHeight() / 2;
        }
        if (scrollbar == null) {
            Tools.printStackTrace("can't find the scrollbar");
        } else {
            RoboTest.moveToAbs(scrollbarX, scrollbarY);
            RoboTest.leftPress();
            if (down) {
                RoboTest.moveToAbs(scrollbarX, scrollbarY + delta);
            } else {
                RoboTest.moveToAbs(scrollbarX, scrollbarY - delta);
            }
            RoboTest.leftRelease();
        }
    }

    private static Component getFocusedWindow() {
        for (Window w : Window.getWindows()) {
            Component c = w.getFocusOwner();
            if (c == null) continue;
            while (c.getParent() != null && !(c instanceof JDialog) && !(c instanceof JFrame)) {
                c = c.getParent();
            }
            return c;
        }
        return null;
    }

    private static void moveTo(Class<?> clazz, int number) {
        if (aborted) {
            return;
        }
        Component c = null;
        for (int i = 0; c == null && i < 60 && !aborted; ++i) {
            c = RoboTest.findInside(RoboTest.getFocusedWindow(), clazz, number);
            RoboTest.sleepNoFactor(1000.0);
        }
        if (aborted) {
            return;
        }
        if (c == null) {
            Tools.printStackTrace("can't find: " + clazz);
            return;
        }
        Point endP = c.getLocationOnScreen();
        int endX = (int)((Point2D)endP).getX() + c.getWidth() / 2;
        int endY = (int)((Point2D)endP).getY() + c.getHeight() / 2;
        RoboTest.moveToAbs(endX, endY);
    }

    private static void moveToMenu(String text) {
        if (aborted) {
            return;
        }
        JTree tree = (JTree)RoboTest.findInside((Component)Tools.getGUIData().getMainFrame(), JTree.class, 0);
        if (tree == null) {
            RoboTest.info("can't find the tree");
        }
        for (int i = 0; i < tree.getRowCount(); ++i) {
            String item = tree.getPathForRow(i).getLastPathComponent().toString();
            if (!item.startsWith(text) && !item.endsWith(text)) continue;
            RoboTest.moveToAbs((int)(tree.getLocationOnScreen().getX() + tree.getRowBounds(i).getX()) + 2, (int)(tree.getLocationOnScreen().getY() + tree.getRowBounds(i).getY()) + 2);
            return;
        }
        Tools.info("can't find " + text + " the tree");
    }

    private static void moveToGraph(String text) {
        if (aborted) {
            return;
        }
        DrbdGraph graph = cluster.getBrowser().getDrbdGraph();
        for (Info i : graph.infoToVertexKeySet()) {
            String item = graph.getMainText(graph.getVertex(i), false);
            if (!item.startsWith(text) && !item.endsWith(text)) continue;
            Point2D loc = graph.getLocation(i);
            RoboTest.moveToAbs((int)(graph.getVisualizationViewer().getLocationOnScreen().getX() + loc.getX()), (int)(graph.getVisualizationViewer().getLocationOnScreen().getY() + loc.getY()));
            return;
        }
        Tools.info("can't find " + text + " in the graph");
    }

    private static void moveTo(String text, Class<?> clazz) {
        RoboTest.moveTo(text, 1, clazz);
    }

    private static void moveTo(String text, int number, Class<?> clazz) {
        Component n;
        if (aborted) {
            return;
        }
        Container c = null;
        for (int i = 0; c == null && i < 60 && !aborted; ++i) {
            c = RoboTest.findComponent(text, number);
            RoboTest.sleepNoFactor(1000.0);
        }
        if (aborted) {
            return;
        }
        if (c == null) {
            Tools.printStackTrace("can't find: " + text);
            return;
        }
        if (clazz == null) {
            n = c;
        } else {
            n = RoboTest.findNext(c, clazz);
            if (n == null) {
                Tools.printStackTrace("can't find: " + text + " -> " + clazz);
                return;
            }
        }
        Point endP = n.getLocationOnScreen();
        int endX = (int)((Point2D)endP).getX() + 15;
        int endY = (int)((Point2D)endP).getY() + c.getHeight() / 2;
        RoboTest.moveToAbs(endX, endY);
    }

    private static void moveToAbs(int endX, int endY) {
        Point p;
        if (aborted) {
            return;
        }
        int xOffset = RoboTest.getOffset();
        int destX = endX;
        int destY = endY;
        do {
            if (MouseInfo.getPointerInfo() == null) {
                return;
            }
            p = MouseInfo.getPointerInfo().getLocation();
            int x = (int)((Point2D)p).getX();
            int y = (int)((Point2D)p).getY();
            int directionX = 0;
            int directionY = 0;
            if (x < destX) {
                directionX = 1;
            } else if (x > destX) {
                directionX = -1;
            }
            if (y < destY) {
                directionY = 1;
            } else if (y > destY) {
                directionY = -1;
            }
            if (directionY == 0 && directionX == 0) break;
            int directionX0 = directionX;
            int directionY0 = directionY;
            robot.mouseMove((int)((Point2D)p).getX() + xOffset + directionX0, (int)((Point2D)p).getY() + directionY0);
            RoboTest.sleep(5.0);
        } while (!RoboTest.abortWithMouseMovement());
        p = MouseInfo.getPointerInfo().getLocation();
    }

    public static void registerMovement() {
        Robot rbt = null;
        try {
            rbt = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appWarning("Robot error");
        }
        if (rbt == null) {
            return;
        }
        Robot robot = rbt;
        RoboTest.info("start register movement in 3 seconds");
        RoboTest.sleepNoFactor(3000.0);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Point2D prevP = new Point2D.Double(0.0, 0.0);
                Point2D.Double prevPrevP = new Point2D.Double(0.0, 0.0);
                do {
                    Point2D newPos = RoboTest.getAppPosition();
                    RoboTest.sleepNoFactor(2000.0);
                    if (newPos.equals(prevP) && !prevPrevP.equals(prevP)) {
                        RoboTest.info("moveTo(" + (int)newPos.getX() + ", " + (int)newPos.getY() + ");");
                    }
                    prevPrevP = prevP;
                    prevP = newPos;
                } while (!RoboTest.abortWithMouseMovement());
                RoboTest.info("stopped movement registering");
            }
        });
        thread.start();
    }

    private static int getBlockDevY() {
        RoboTest.info("move to position, start in 3 seconds");
        RoboTest.sleepNoFactor(3000.0);
        Point2D pos = RoboTest.getAppPosition();
        int y = (int)pos.getY();
        if (y > 532) {
            return 267;
        }
        return y;
    }

    private static boolean dialogColorTest(String text) {
        if (aborted) {
            return false;
        }
        RoboTest.sleepNoFactor(2000.0);
        Component dialog = RoboTest.getFocusedWindow();
        for (int i = 0; i < 60 && !(dialog instanceof JDialog) && !aborted; ++i) {
            RoboTest.sleepNoFactor(1000.0);
        }
        if (!(dialog instanceof JDialog) || aborted) {
            RoboTest.info(text + ": color test: no dialog");
            return false;
        }
        RoboTest.moveToAbs((int)dialog.getLocationOnScreen().getX() + 5, (int)dialog.getLocationOnScreen().getY() + 40);
        Point2D p = RoboTest.getAppPosition();
        if (!RoboTest.isColor((int)p.getX(), (int)p.getY(), AppDefaults.BACKGROUND, true)) {
            RoboTest.info(text + ": color test: error");
            return false;
        }
        return true;
    }

    private static void addDrbdResource(int blockDevY) {
        RoboTest.moveTo(334, blockDevY);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Add Mirrored Disk");
        RoboTest.sleep(1000.0);
        RoboTest.moveTo(cluster.getHostsArray()[1].getName());
        RoboTest.sleep(2000.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(10);
        RoboTest.sleep(20000.0);
        RoboTest.dialogColorTest("addDrbdResource");
    }

    private static void drbdNext() {
        RoboTest.press(10);
    }

    private static void newDrbdResource() {
        RoboTest.drbdNext();
        RoboTest.sleep(10000.0);
        RoboTest.dialogColorTest("newDrbdResource");
    }

    private static void chooseDrbdResourceInterface(String hostName, boolean proxy) {
        RoboTest.moveTo("on " + hostName, Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(500.0);
        if (proxy) {
            RoboTest.press(80);
        } else {
            RoboTest.press(69);
        }
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(1000.0);
        RoboTest.dialogColorTest("chooseDrbdResourceInterface");
    }

    private static void chooseDrbdResource() {
        RoboTest.chooseDrbdResourceInterface(cluster.getHostsArray()[0].getName(), !PROXY);
        RoboTest.chooseDrbdResourceInterface(cluster.getHostsArray()[1].getName(), !PROXY);
        RoboTest.drbdNext();
        RoboTest.sleep(10000.0);
        RoboTest.dialogColorTest("chooseDrbdResource");
    }

    private static void addDrbdVolume() {
        RoboTest.drbdNext();
        RoboTest.sleep(10000.0);
        RoboTest.dialogColorTest("addDrbdVolume");
    }

    private static void addBlockDevice() {
        RoboTest.drbdNext();
        RoboTest.sleep(10000.0);
        RoboTest.dialogColorTest("addBlockDevice");
    }

    private static void addMetaData() {
        RoboTest.drbdNext();
        RoboTest.sleep(30000.0);
        RoboTest.dialogColorTest("addMetaData");
    }

    private static void addFileSystem() {
        RoboTest.dialogColorTest("addFileSystem");
    }

    private static void removeDrbdVolume(boolean really) {
        if (aborted) {
            return;
        }
        RoboTest.moveTo(480, 202);
        RoboTest.rightClick();
        RoboTest.moveTo("Remove DRBD Volume");
        RoboTest.leftClick();
        Tools.sleep(10000);
        RoboTest.dialogColorTest("removeDrbdVolume");
        if (really) {
            RoboTest.confirmRemove();
        } else {
            RoboTest.press(10);
        }
    }

    private static void createPV(int blockDevY) {
        RoboTest.moveTo(334, blockDevY);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Create PV");
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo(cluster.getHostsArray()[1].getName());
        RoboTest.leftClick();
        RoboTest.moveTo("Create PV");
        RoboTest.leftClick();
    }

    private static void pvRemove(int blockDevY) {
        RoboTest.moveTo(334, blockDevY);
        RoboTest.rightClick();
        RoboTest.sleep(3000.0);
        RoboTest.moveTo("Remove PV");
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo(cluster.getHostsArray()[1].getName());
        RoboTest.leftClick();
        RoboTest.moveTo("Remove PV");
        RoboTest.leftClick();
    }

    private static void createVG(int blockDevY) {
        RoboTest.moveTo(334, blockDevY);
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Create VG");
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo(cluster.getHostsArray()[1].getName());
        RoboTest.leftClick();
        RoboTest.moveTo("Create VG");
        RoboTest.leftClick();
    }

    private static void createLV() {
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Create LV in VG");
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo(cluster.getHostsArray()[1].getName());
        RoboTest.leftClick();
        RoboTest.moveTo("Create");
        RoboTest.leftClick();
        RoboTest.moveTo("Close");
        RoboTest.leftClick();
    }

    private static void resizeLV() {
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Resize LV");
        RoboTest.leftClick();
        RoboTest.sleep(5000.0);
        RoboTest.press(50);
        RoboTest.press(53);
        RoboTest.press(50);
        RoboTest.moveTo(cluster.getHostsArray()[1].getName());
        RoboTest.leftClick();
        RoboTest.moveTo("Resize");
        RoboTest.leftClick();
        RoboTest.moveTo("Close");
        RoboTest.leftClick();
    }

    private static void vgRemove() {
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove VG");
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo(cluster.getHostsArray()[1].getName());
        RoboTest.leftClick();
        RoboTest.moveTo("Remove VG");
        RoboTest.leftClick();
    }

    private static void lvRemove() {
        RoboTest.rightClick();
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Remove LV");
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Remove");
        RoboTest.leftClick();
    }

    private static void startDRBDTest1(int blockDevY) {
        String drbdTest = "drbd-test1";
        slowFactor = 0.2f;
        aborted = false;
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.addDrbdVolume();
        RoboTest.addBlockDevice();
        RoboTest.sleep(1000.0);
        RoboTest.addBlockDevice();
        RoboTest.sleep(20000.0);
        RoboTest.addMetaData();
        RoboTest.addFileSystem();
        RoboTest.sleep(5000.0);
        RoboTest.moveTo("Finish");
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.checkDRBDTest("drbd-test1", 1.1);
        for (int i = 0; i < 2; ++i) {
            RoboTest.info("i: " + i);
            RoboTest.removeDrbdVolume(false);
        }
        RoboTest.removeDrbdVolume(true);
        RoboTest.checkDRBDTest("drbd-test1", 2.0);
    }

    private static void startDRBDTest2(int blockDevY) {
        int i;
        String drbdTest = "drbd-test1";
        slowFactor = 0.2f;
        aborted = false;
        for (i = 0; i < 2; ++i) {
            RoboTest.info("drbd-test1/1");
            RoboTest.addDrbdResource(blockDevY);
            RoboTest.moveTo("Cancel");
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
        }
        RoboTest.info("drbd-test1/2");
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.moveTo("Cancel");
        RoboTest.leftClick();
        RoboTest.sleep(20000.0);
        RoboTest.info("drbd-test1/3");
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.addDrbdVolume();
        RoboTest.moveTo("Cancel");
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.info("drbd-test1/4");
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.addDrbdVolume();
        RoboTest.addBlockDevice();
        RoboTest.sleep(20000.0);
        RoboTest.moveTo("Cancel");
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.info("drbd-test1/5");
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.addDrbdVolume();
        RoboTest.addBlockDevice();
        RoboTest.addBlockDevice();
        RoboTest.sleep(20000.0);
        RoboTest.checkDRBDTest("drbd-test1", 1.0);
        RoboTest.moveTo("Cancel");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.sleep(60000.0);
        RoboTest.info("drbd-test1/6");
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.addDrbdVolume();
        RoboTest.addBlockDevice();
        RoboTest.addBlockDevice();
        RoboTest.sleep(20000.0);
        RoboTest.addMetaData();
        RoboTest.moveTo("Cancel");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.sleep(20000.0);
        RoboTest.info("drbd-test1/7");
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.addDrbdVolume();
        RoboTest.addBlockDevice();
        RoboTest.addBlockDevice();
        RoboTest.sleep(20000.0);
        RoboTest.addMetaData();
        RoboTest.addFileSystem();
        RoboTest.checkDRBDTest("drbd-test1", 1.1);
        RoboTest.sleep(10000.0);
        RoboTest.moveTo("Cancel");
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(20000.0);
        RoboTest.confirmRemove();
        RoboTest.sleep(20000.0);
        RoboTest.info("drbd-test1/8");
        RoboTest.addDrbdResource(blockDevY);
        RoboTest.chooseDrbdResource();
        RoboTest.addDrbdVolume();
        RoboTest.addBlockDevice();
        RoboTest.addBlockDevice();
        RoboTest.sleep(20000.0);
        RoboTest.addMetaData();
        RoboTest.addFileSystem();
        RoboTest.moveTo("Finish");
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.checkDRBDTest("drbd-test1", 1.1);
        for (i = 0; i < 3; ++i) {
            RoboTest.removeDrbdVolume(false);
        }
        RoboTest.removeDrbdVolume(true);
        RoboTest.checkDRBDTest("drbd-test1", 2.0);
    }

    private static void startDRBDTest3(int blockDevY) {
        String drbdTest = "drbd-test3";
        slowFactor = 0.2f;
        aborted = false;
        int offset = 0;
        for (int i = 0; i < 2; ++i) {
            RoboTest.addDrbdResource(blockDevY + offset);
            if (i == 1 && cluster.getHostsArray()[0].hasVolumes()) {
                RoboTest.newDrbdResource();
            }
            RoboTest.chooseDrbdResource();
            RoboTest.addDrbdVolume();
            RoboTest.addBlockDevice();
            RoboTest.addBlockDevice();
            RoboTest.sleep(20000.0);
            if (offset == 0) {
                RoboTest.checkDRBDTest("drbd-test3", 1.1);
            } else {
                RoboTest.checkDRBDTest("drbd-test3", 1.2);
            }
            RoboTest.sleep(10000.0);
            RoboTest.addMetaData();
            RoboTest.addFileSystem();
            RoboTest.sleep(10000.0);
            RoboTest.moveTo("Finish");
            RoboTest.leftClick();
            RoboTest.sleep(10000.0);
            offset += 40;
        }
        RoboTest.checkDRBDTest("drbd-test3", 2.0);
        RoboTest.moveTo(730, 475);
        RoboTest.leftPress();
        RoboTest.moveTo(225, 115);
        RoboTest.leftRelease();
        RoboTest.moveTo(334, blockDevY);
        RoboTest.rightClick();
        RoboTest.moveToSlowly(400, blockDevY + 160);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(10);
        RoboTest.checkDRBDTest("drbd-test3", 2.01);
        RoboTest.moveTo(400, blockDevY);
        RoboTest.rightClick();
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(10);
        RoboTest.checkDRBDTest("drbd-test3", 2.02);
        RoboTest.moveTo(480, 202);
        RoboTest.leftClick();
        RoboTest.moveTo("Protocol", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Fence peer", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        Tools.getGUIData().expandTerminalSplitPane(1);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(57);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Max buffers", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(53);
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Max buffers", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(40);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveScrollBar(true);
        String v = cluster.getHostsArray()[0].getDrbdVersion();
        try {
            if (v != null && Tools.compareVersions(v, "8.4.0") < 0) {
                RoboTest.moveTo("After", Widget.MComboBox.class);
            } else {
                RoboTest.moveTo("after", Widget.MComboBox.class);
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(40);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(1000.0);
        RoboTest.moveScrollBar(false);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test3", 2.1);
        RoboTest.moveTo(500, 342);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(51);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.checkDRBDTest("drbd-test3", 2.11);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(48);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo(480, 202);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Protocol", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Fence peer", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(53);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Max buffers", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(50);
        RoboTest.sleep(500.0);
        RoboTest.press(48);
        RoboTest.sleep(500.0);
        RoboTest.press(52);
        RoboTest.sleep(500.0);
        RoboTest.press(56);
        RoboTest.sleep(500.0);
        RoboTest.moveTo("Max buffers", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(38);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveScrollBar(true);
        try {
            if (v != null && Tools.compareVersions(v, "8.4.0") < 0) {
                RoboTest.moveTo("After", Widget.MComboBox.class);
            } else {
                RoboTest.moveTo("after", Widget.MComboBox.class);
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(38);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(1000.0);
        RoboTest.moveScrollBar(false);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test3", 2.2);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(48);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test3", 2.3);
        RoboTest.moveTo(480, 202);
        RoboTest.rightClick();
        RoboTest.moveTo("Remove DRBD Volume");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.checkDRBDTest("drbd-test3", 3.0);
        RoboTest.moveTo(480, 202);
        RoboTest.rightClick();
        RoboTest.moveTo("Remove DRBD Volume");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.checkDRBDTest("drbd-test3", 4.0);
    }

    private static void startDRBDTest4(int blockDevY) {
        String drbdTest = "drbd-test4";
        slowFactor = 0.2f;
        aborted = false;
        int offset = 0;
        int protocolY = 552;
        int correctionY = 0;
        if (!cluster.getHostsArray()[0].hasVolumes()) {
            protocolY = 352;
            correctionY = 30;
        }
        for (int i = 0; i < 2; ++i) {
            RoboTest.addDrbdResource(blockDevY + offset);
            if (i == 0) {
                RoboTest.chooseDrbdResource();
            } else {
                RoboTest.moveTo("DRBD Resource", Widget.MComboBox.class);
                RoboTest.leftClick();
                RoboTest.press(40);
                RoboTest.sleep(200.0);
                RoboTest.press(10);
                RoboTest.drbdNext();
                RoboTest.sleep(10000.0);
            }
            RoboTest.addDrbdVolume();
            RoboTest.addBlockDevice();
            RoboTest.addBlockDevice();
            RoboTest.sleep(20000.0);
            if (offset == 0) {
                RoboTest.checkDRBDTest("drbd-test4", 1.1);
            } else {
                RoboTest.checkDRBDTest("drbd-test4", 1.2);
            }
            RoboTest.sleep(10000.0);
            RoboTest.addMetaData();
            RoboTest.addFileSystem();
            RoboTest.sleep(20000.0);
            RoboTest.moveTo("Finish");
            RoboTest.leftClick();
            RoboTest.sleep(10000.0);
            if (offset == 0) {
                RoboTest.checkDRBDTest("drbd-test4", 1.0);
            }
            offset += 40;
        }
        RoboTest.checkDRBDTest("drbd-test4", 2.0);
        RoboTest.moveTo(480, 202);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Protocol", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Fence peer", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(57);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test4", 2.1);
        RoboTest.moveTo(500, 342);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(51);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.checkDRBDTest("drbd-test4", 2.11);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(48);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo(480, 202);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Protocol", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Fence peer", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(53);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test4", 2.2);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(48);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test4", 2.3);
        RoboTest.moveTo(480, 202);
        RoboTest.rightClick();
        RoboTest.moveTo("Remove DRBD Volume");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.checkDRBDTest("drbd-test4", 3.0);
        RoboTest.moveTo(480, 202);
        RoboTest.rightClick();
        RoboTest.moveTo("Remove DRBD Volume");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.checkDRBDTest("drbd-test4", 4.0);
    }

    private static void startDRBDTest5(int blockDevY) {
        slowFactor = 0.6f;
        aborted = false;
        for (int i = 0; i < 2; ++i) {
            RoboTest.createPV(blockDevY);
            RoboTest.createVG(blockDevY);
            RoboTest.sleepNoFactor(60000.0);
            RoboTest.moveToGraph("VG vg0" + i);
            RoboTest.createLV();
            RoboTest.moveToGraph("vg0" + i + "/lvol0");
            RoboTest.resizeLV();
        }
    }

    private static void startDRBDTest6(int blockDevY) {
        slowFactor = 0.6f;
        aborted = false;
        int offset = 0;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                RoboTest.moveToGraph("vg0" + i + "/lvol0");
                RoboTest.lvRemove();
                RoboTest.sleepNoFactor(10000.0);
            }
            RoboTest.moveToGraph("VG vg0" + i);
            RoboTest.vgRemove();
            RoboTest.sleepNoFactor(60000.0);
            RoboTest.pvRemove(blockDevY + offset);
            offset += 40;
        }
    }

    private static void startDRBDTest8(int blockDevY) {
        String drbdTest = "drbd-test8";
        slowFactor = 0.2f;
        aborted = false;
        int offset = 0;
        for (int i = 0; i < 2; ++i) {
            RoboTest.addDrbdResource(blockDevY + offset);
            if (i == 1 && cluster.getHostsArray()[0].hasVolumes()) {
                RoboTest.newDrbdResource();
            }
            RoboTest.chooseDrbdResourceInterface(cluster.getHostsArray()[0].getName(), PROXY);
            RoboTest.chooseDrbdResourceInterface(cluster.getHostsArray()[1].getName(), PROXY);
            RoboTest.moveTo(700, 450);
            RoboTest.leftClick();
            robot.mouseWheel(70);
            RoboTest.moveTo(Tools.getString("DrbdResourceInfo.ProxyOutsideIp"), Widget.MComboBox.class);
            RoboTest.leftClick();
            RoboTest.sleep(500.0);
            RoboTest.press(69);
            RoboTest.sleep(500.0);
            RoboTest.press(10);
            RoboTest.moveTo(Widget.MComboBox.class, 8);
            RoboTest.leftClick();
            RoboTest.sleep(500.0);
            RoboTest.press(69);
            RoboTest.sleep(500.0);
            RoboTest.press(10);
            RoboTest.drbdNext();
            RoboTest.sleep(10000.0);
            RoboTest.dialogColorTest("chooseDrbdResource");
            RoboTest.addDrbdVolume();
            RoboTest.addBlockDevice();
            RoboTest.addBlockDevice();
            RoboTest.sleep(20000.0);
            if (offset == 0) {
                RoboTest.checkDRBDTest("drbd-test8", 1.1);
            } else {
                RoboTest.checkDRBDTest("drbd-test8", 1.2);
            }
            RoboTest.sleep(10000.0);
            RoboTest.addMetaData();
            RoboTest.addFileSystem();
            RoboTest.sleep(10000.0);
            RoboTest.moveTo("Finish");
            RoboTest.leftClick();
            RoboTest.sleep(10000.0);
            offset += 40;
        }
        RoboTest.checkDRBDTest("drbd-test8", 2.0);
        RoboTest.moveTo(730, 475);
        RoboTest.leftPress();
        RoboTest.moveTo(225, 115);
        RoboTest.leftRelease();
        RoboTest.moveTo(334, blockDevY);
        RoboTest.rightClick();
        RoboTest.moveToSlowly(400, blockDevY + 160);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(10);
        RoboTest.checkDRBDTest("drbd-test8", 2.01);
        RoboTest.moveTo(400, blockDevY);
        RoboTest.rightClick();
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(40);
        RoboTest.sleep(500.0);
        RoboTest.press(10);
        RoboTest.checkDRBDTest("drbd-test8", 2.02);
        RoboTest.moveTo(480, 202);
        RoboTest.leftClick();
        RoboTest.moveTo(900, 300);
        robot.mouseWheel(100);
        RoboTest.moveTo("Protocol", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Fence peer", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        Tools.getGUIData().expandTerminalSplitPane(1);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(57);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Max buffers", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(53);
        RoboTest.sleep(1000.0);
        RoboTest.moveTo("Max buffers", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(40);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveScrollBar(true);
        RoboTest.sleep(5000.0);
        String v = cluster.getHostsArray()[0].getDrbdVersion();
        try {
            if (v != null && Tools.compareVersions(v, "8.4.0") < 0) {
                RoboTest.moveTo("After", Widget.MComboBox.class);
            } else {
                RoboTest.moveTo("after", Widget.MComboBox.class);
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(40);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(1000.0);
        RoboTest.moveScrollBar(false);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test8", 2.1);
        RoboTest.moveTo(500, 342);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(51);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.sleep(10000.0);
        RoboTest.checkDRBDTest("drbd-test8", 2.11);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(48);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo(480, 202);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.moveTo(900, 300);
        robot.mouseWheel(100);
        RoboTest.moveTo("Protocol", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Fence peer", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.press(40);
        RoboTest.sleep(200.0);
        RoboTest.press(38);
        RoboTest.sleep(200.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(53);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Max buffers", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(50);
        RoboTest.sleep(500.0);
        RoboTest.press(48);
        RoboTest.sleep(500.0);
        RoboTest.press(52);
        RoboTest.sleep(500.0);
        RoboTest.press(56);
        RoboTest.sleep(500.0);
        RoboTest.moveTo("Max buffers", Widget.MComboBox.class);
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(38);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(2000.0);
        RoboTest.moveScrollBar(true);
        try {
            if (v != null && Tools.compareVersions(v, "8.4.0") < 0) {
                RoboTest.moveTo("After", Widget.MComboBox.class);
            } else {
                RoboTest.moveTo("after", Widget.MComboBox.class);
            }
        }
        catch (Exceptions.IllegalVersionException e) {
            Tools.appWarning(e.getMessage(), e);
        }
        RoboTest.leftClick();
        RoboTest.sleep(1000.0);
        RoboTest.press(38);
        RoboTest.sleep(1000.0);
        RoboTest.press(10);
        RoboTest.sleep(1000.0);
        RoboTest.moveScrollBar(false);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.sleep(2000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test8", 2.2);
        RoboTest.moveTo("Wfc timeout", Widget.MTextField.class);
        RoboTest.leftClick();
        RoboTest.press(8);
        RoboTest.sleep(1000.0);
        RoboTest.press(48);
        RoboTest.sleep(2000.0);
        RoboTest.moveTo("Apply");
        RoboTest.sleep(6000.0);
        RoboTest.leftClick();
        RoboTest.checkDRBDTest("drbd-test8", 2.3);
        RoboTest.moveTo(480, 202);
        RoboTest.rightClick();
        RoboTest.moveTo("Remove DRBD Volume");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.checkDRBDTest("drbd-test8", 3.0);
        RoboTest.moveTo(480, 202);
        RoboTest.rightClick();
        RoboTest.moveTo("Remove DRBD Volume");
        RoboTest.leftClick();
        RoboTest.confirmRemove();
        RoboTest.checkDRBDTest("drbd-test8", 4.0);
    }

    private static void startVMTest(String vmTest, String type, int count) {
        int j;
        slowFactor = 0.6f;
        aborted = false;
        String name = "dmc";
        int count2 = 3;
        for (int j2 = 0; j2 < count; ++j2) {
            RoboTest.checkVMTest(vmTest, 1.0, name);
            name = name + "i";
        }
        name = "dmc";
        ArrayList<String> names = new ArrayList<String>();
        for (j = 0; j < count; ++j) {
            int i;
            int k;
            RoboTest.moveToMenu("VMs (KVM");
            RoboTest.rightClick();
            RoboTest.sleep(2000.0);
            RoboTest.moveTo("Add New Virtual Machine");
            RoboTest.leftClick();
            RoboTest.sleep(10000.0);
            RoboTest.dialogColorTest("new domain");
            RoboTest.moveTo("Domain name", Widget.MTextField.class);
            RoboTest.leftClick();
            RoboTest.press(68);
            RoboTest.sleep(200.0);
            RoboTest.press(77);
            RoboTest.sleep(200.0);
            RoboTest.press(67);
            RoboTest.sleep(200.0);
            for (k = 0; k < j; ++k) {
                RoboTest.press(73);
                RoboTest.sleep(200.0);
            }
            RoboTest.moveTo("Domain Type", Widget.MComboBox.class);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
            if ("lxc".equals(type)) {
                RoboTest.press(40);
                RoboTest.sleep(1000.0);
                RoboTest.press(40);
                RoboTest.sleep(1000.0);
                RoboTest.press(40);
                RoboTest.sleep(1000.0);
                RoboTest.press(10);
                RoboTest.sleep(3000.0);
            }
            RoboTest.moveTo("Next");
            RoboTest.leftClick();
            RoboTest.sleep(2000.0);
            if ("lxc".equals(type)) {
                RoboTest.dialogColorTest("filesystem");
                RoboTest.moveTo("Source Dir", Widget.MComboBox.class);
                RoboTest.sleep(2000.0);
                RoboTest.leftClick();
                RoboTest.sleep(2000.0);
                RoboTest.press(35);
                RoboTest.sleep(200.0);
                RoboTest.press(40);
                RoboTest.sleep(200.0);
                RoboTest.press(40);
                RoboTest.sleep(200.0);
                RoboTest.press(10);
                RoboTest.sleep(200.0);
                RoboTest.press(47);
                RoboTest.sleep(200.0);
                RoboTest.press(68);
                RoboTest.sleep(200.0);
                RoboTest.press(77);
                RoboTest.sleep(200.0);
                RoboTest.press(67);
                RoboTest.sleep(200.0);
                for (k = 0; k < j; ++k) {
                    RoboTest.press(73);
                    RoboTest.sleep(200.0);
                }
                RoboTest.press(47);
                RoboTest.sleep(200.0);
                RoboTest.press(82);
                RoboTest.sleep(200.0);
                RoboTest.press(79);
                RoboTest.sleep(200.0);
                RoboTest.press(79);
                RoboTest.sleep(200.0);
                RoboTest.press(84);
                RoboTest.sleep(200.0);
                RoboTest.press(70);
                RoboTest.sleep(200.0);
                RoboTest.press(83);
                RoboTest.sleep(2000.0);
                RoboTest.moveTo("Next");
                RoboTest.leftClick();
            } else {
                RoboTest.dialogColorTest("source file");
                RoboTest.moveTo("Source File", Widget.MComboBox.class);
                RoboTest.sleep(2000.0);
                RoboTest.leftClick();
                RoboTest.sleep(2000.0);
                RoboTest.press(35);
                RoboTest.sleep(200.0);
                RoboTest.press(84);
                RoboTest.sleep(200.0);
                RoboTest.press(69);
                RoboTest.sleep(200.0);
                RoboTest.press(83);
                RoboTest.sleep(200.0);
                RoboTest.press(84);
                RoboTest.sleep(2000.0);
                for (i = 0; i < 3; ++i) {
                    RoboTest.moveTo("Disk/block device");
                    RoboTest.leftClick();
                    RoboTest.sleep(1000.0);
                    RoboTest.moveTo("Image file");
                    RoboTest.leftClick();
                    RoboTest.sleep(1000.0);
                }
                RoboTest.moveTo("Next");
                RoboTest.leftClick();
                RoboTest.sleep(5000.0);
                RoboTest.dialogColorTest("disk image");
                RoboTest.moveTo("Next");
                RoboTest.leftClick();
            }
            RoboTest.sleep(5000.0);
            RoboTest.dialogColorTest("network");
            for (i = 0; i < 3; ++i) {
                RoboTest.moveTo("bridge");
                RoboTest.leftClick();
                RoboTest.sleep(1000.0);
                RoboTest.moveTo("network");
                RoboTest.leftClick();
                RoboTest.sleep(1000.0);
            }
            RoboTest.moveTo("Next");
            RoboTest.leftClick();
            RoboTest.sleep(10000.0);
            if (!"lxc".equals(type)) {
                RoboTest.dialogColorTest("display");
                for (i = 0; i < 3; ++i) {
                    RoboTest.moveTo("sdl");
                    RoboTest.leftClick();
                    RoboTest.sleep(1000.0);
                    RoboTest.moveTo("vnc");
                    RoboTest.leftClick();
                    RoboTest.sleep(1000.0);
                }
                RoboTest.moveTo("Next");
                RoboTest.leftClick();
                RoboTest.sleep(20000.0);
            }
            RoboTest.dialogColorTest("create config");
            RoboTest.sleep(10000.0);
            RoboTest.moveTo("Create Config");
            RoboTest.sleep(4000.0);
            RoboTest.leftClick();
            RoboTest.checkVMTest(vmTest, 2.0, name);
            RoboTest.sleep(8000.0);
            String firstHost = cluster.getHostsArray()[0].getName();
            String secondHost = cluster.getHostsArray()[1].getName();
            if (cluster.getHosts().size() > 1) {
                for (int i2 = 0; i2 < 3; ++i2) {
                    RoboTest.moveTo(firstHost, JCheckBox.class);
                    RoboTest.leftClick();
                    RoboTest.sleep(10000.0);
                    RoboTest.moveTo("Create Config");
                    RoboTest.sleep(2000.0);
                    RoboTest.leftClick();
                    RoboTest.checkVMTest(cluster.getHostsArray()[0], vmTest, 1.0, name);
                    RoboTest.checkVMTest(cluster.getHostsArray()[1], vmTest, 2.0, name);
                    RoboTest.moveTo(firstHost, JCheckBox.class);
                    RoboTest.sleep(1000.0);
                    RoboTest.leftClick();
                    RoboTest.sleep(1000.0);
                    RoboTest.moveTo(secondHost, JCheckBox.class);
                    RoboTest.sleep(1000.0);
                    RoboTest.leftClick();
                    RoboTest.sleep(10000.0);
                    RoboTest.moveTo("Create Config");
                    RoboTest.sleep(2000.0);
                    RoboTest.leftClick();
                    RoboTest.checkVMTest(cluster.getHostsArray()[0], vmTest, 2.0, name);
                    RoboTest.checkVMTest(cluster.getHostsArray()[1], vmTest, 1.0, name);
                    RoboTest.moveTo(secondHost, JCheckBox.class);
                    RoboTest.leftClick();
                    RoboTest.sleep(10000.0);
                    RoboTest.moveTo("Create Config");
                    RoboTest.sleep(4000.0);
                    RoboTest.leftClick();
                    RoboTest.checkVMTest(vmTest, 2.0, name);
                }
            }
            RoboTest.sleepNoFactor(2000.0);
            RoboTest.moveTo("Finish");
            RoboTest.leftClick();
            RoboTest.sleepNoFactor(5000.0);
            RoboTest.moveTo("Number of CPUs", Widget.MTextField.class);
            RoboTest.sleep(1000.0);
            RoboTest.leftClick();
            RoboTest.sleep(500.0);
            RoboTest.press(8);
            RoboTest.sleep(500.0);
            RoboTest.press(50);
            RoboTest.sleep(500.0);
            RoboTest.moveTo("Apply");
            RoboTest.sleep(1000.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
            RoboTest.checkVMTest(vmTest, 3.0, name);
            if (j == 0 && !"lxc".equals(type)) {
                RoboTest.moveToMenu("dmc");
                RoboTest.rightClick();
                RoboTest.sleep(2000.0);
                RoboTest.moveTo("Add Hardware");
                RoboTest.sleep(1000.0);
                RoboTest.moveTo("New Disk");
                RoboTest.leftClick();
                RoboTest.sleep(2000.0);
                RoboTest.moveTo("Disk/block device");
                RoboTest.leftClick();
                RoboTest.sleep(2000.0);
                RoboTest.moveTo("Source Device", Widget.MComboBox.class);
                RoboTest.leftClick();
                RoboTest.press(47);
                RoboTest.press(68);
                RoboTest.press(69);
                RoboTest.press(86);
                RoboTest.press(47);
                RoboTest.press(83);
                RoboTest.press(68);
                RoboTest.press(65);
                RoboTest.press(49);
                RoboTest.press(10);
                RoboTest.moveTo("Apply");
                RoboTest.leftClick();
                RoboTest.checkVMTest(vmTest, 3.01, name);
                RoboTest.moveToMenu("hdb (IDE");
                RoboTest.rightClick();
                RoboTest.press(40);
                RoboTest.press(10);
                RoboTest.confirmRemove();
                RoboTest.checkVMTest(vmTest, 3.0, name);
            }
            if (!"lxc".equals(type)) {
                RoboTest.moveToMenu("hda (IDE");
                RoboTest.leftClick();
                RoboTest.sleep(1000.0);
                RoboTest.moveTo("Readonly", JCheckBox.class);
                RoboTest.sleep(1000.0);
                RoboTest.leftClick();
                RoboTest.sleep(1000.0);
                RoboTest.moveTo("Apply");
                RoboTest.sleep(1000.0);
                RoboTest.leftClick();
                RoboTest.checkVMTest(vmTest, 3.1, name);
                RoboTest.sleep(1000.0);
                Tools.getGUIData().expandTerminalSplitPane(1);
                RoboTest.moveTo("Readonly", JCheckBox.class);
                RoboTest.sleep(1000.0);
                RoboTest.leftClick();
                RoboTest.sleep(1000.0);
                RoboTest.moveTo("VM Host Overview");
                RoboTest.sleep(1000.0);
                RoboTest.leftClick();
                RoboTest.sleep(1000.0);
                RoboTest.moveTo("Apply");
                RoboTest.leftClick();
                RoboTest.checkVMTest(vmTest, 3.2, name);
            }
            names.add(name);
            for (String n : names) {
                RoboTest.checkVMTest(vmTest, 3.0, n);
            }
            name = name + "i";
        }
        RoboTest.sleepNoFactor(5000.0);
        for (j = 0; j < count; ++j) {
            RoboTest.moveToMenu("dmc");
            RoboTest.rightClick();
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Remove Domain");
            RoboTest.leftClick();
            RoboTest.sleepNoFactor(2000.0);
            RoboTest.dialogColorTest("remove VM");
            RoboTest.confirmRemove();
            RoboTest.leftClick();
            RoboTest.sleepNoFactor(5000.0);
        }
    }

    private static void startVMTest1(String vmTest, int count) {
        RoboTest.startVMTest(vmTest, "kvm", count);
    }

    private static void startVMTest4(String vmTest, int count) {
        slowFactor = 0.1f;
        aborted = false;
        for (int i = count; i > 0; --i) {
            if (i % 10 == 0) {
                RoboTest.info(vmTest + " I: " + i);
            }
            RoboTest.moveTo("Add New Virtual Machine");
            RoboTest.sleep(500.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
            RoboTest.moveTo("Domain name", Widget.MTextField.class);
            Point2D p = RoboTest.getAppPosition();
            if (!RoboTest.isColor((int)p.getX(), (int)p.getY(), new Color(255, 100, 100), true)) {
                RoboTest.info(vmTest + " 1: error");
                break;
            }
            boolean ok = false;
            for (int error = 0; error < 5; ++error) {
                RoboTest.sleep(100.0);
                RoboTest.press(88);
                if (RoboTest.isColor((int)p.getX(), (int)p.getY(), new Color(255, 100, 100), false)) continue;
                RoboTest.sleepNoFactor(1000.0);
                ok = true;
                break;
            }
            if (!ok) {
                RoboTest.info(vmTest + " 2: failed");
                break;
            }
            RoboTest.moveTo("Cancel");
            RoboTest.sleep(500.0);
            RoboTest.leftClick();
            RoboTest.sleep(1000.0);
        }
    }

    private static void startVMTest5(String vmTest, int count) {
        RoboTest.startVMTest(vmTest, "lxc", count);
    }

    private static void saveAndExit() {
        Tools.save(Tools.getConfigData().getSaveFile(), false);
        RoboTest.sleepNoFactor(10000.0);
        System.exit(0);
    }

    private static void resetTerminalAreas() {
        for (Host h : cluster.getHosts()) {
            if (aborted) continue;
            h.getTerminalPanel().resetTerminalArea();
        }
    }

    public static void info(String text) {
        if (cluster != null) {
            for (Host h : cluster.getHosts()) {
                h.getTerminalPanel().addCommandOutput(text + "\n");
            }
        }
        Tools.info(text);
    }

    public static Component findInside(Component component, Class<?> clazz, int position) {
        ArrayList<Component> res = new ArrayList<Component>();
        RoboTest.findInside(component, clazz, res);
        if (res.size() > position) {
            return (Component)res.get(position);
        }
        return null;
    }

    public static void findInside(Component component, Class<?> clazz, List<Component> results) {
        if (component.getClass().equals(clazz) && component.isShowing()) {
            results.add(component);
        }
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                RoboTest.findInside(c, clazz, results);
            }
        }
    }

    public static Component findNext(Component component, Class<?> clazz) {
        boolean next = false;
        for (Component c : component.getParent().getComponents()) {
            if (next) {
                Component f = RoboTest.findInside(c, clazz, 0);
                if (f != null) {
                    return f;
                }
                if (!c.getClass().equals(clazz)) continue;
                return c;
            }
            if (c != component) continue;
            next = true;
        }
        return null;
    }

    private static Container findComponent(String text, Container component, Integer[] number) {
        Integer n;
        Integer n2;
        String t;
        if (component instanceof AbstractButton) {
            if (component.isShowing() && component.isEnabled() && (t = ((AbstractButton)component).getText()) != null && (t.startsWith(text) || t.endsWith(text))) {
                if (number[0] <= 1) {
                    return component;
                }
                n2 = number[0];
                n = number[0] = Integer.valueOf(number[0] - 1);
            }
        } else if (component instanceof JLabel && component.isShowing() && (t = ((JLabel)component).getText()) != null && (t.startsWith(text) || t.endsWith(text))) {
            if (number[0] <= 1) {
                return component;
            }
            n2 = number[0];
            n = number[0] = Integer.valueOf(number[0] - 1);
        }
        if (component == null) {
            Tools.info("can't find " + text);
        }
        for (Component c : component.getComponents()) {
            Container ret;
            if (!(c instanceof Container) || (ret = RoboTest.findComponent(text, (Container)c, number)) == null) continue;
            return ret;
        }
        return null;
    }

    public static Container findComponent(String text) {
        return RoboTest.findComponent(text, 1);
    }

    public static Container findComponent(String text, int number) {
        return RoboTest.findComponent(text, (Container)RoboTest.getFocusedWindow(), new Integer[]{number});
    }

    private static Point2D getAppPosition() {
        Point loc = Tools.getGUIData().getMainFrameContentPane().getLocationOnScreen();
        Point pos = MouseInfo.getPointerInfo().getLocation();
        Point2D.Double newPos = new Point2D.Double(((Point2D)pos).getX() - ((Point2D)loc).getX(), ((Point2D)pos).getY() - ((Point2D)loc).getY());
        return newPos;
    }

    private static void waitForMe() {
        RoboTest.info("waiting...");
        Point iPos = MouseInfo.getPointerInfo().getLocation();
        while (true) {
            Point pos = MouseInfo.getPointerInfo().getLocation();
            if (Math.abs(((Point2D)iPos).getX() - ((Point2D)pos).getX()) > 10.0 || Math.abs(((Point2D)iPos).getY() - ((Point2D)pos).getY()) > 10.0) break;
            Tools.sleep(100);
        }
        prevP = RoboTest.getAppPosition();
        RoboTest.info("continue...");
    }

    private static void checkNumberOfVertices(String name, int should) {
        if (aborted) {
            return;
        }
        CRMGraph graph = cluster.getBrowser().getCRMGraph();
        for (int i = 0; i < 10 && should != graph.getNumberOfVertices(); ++i) {
            Tools.info(name + " number of vertices: " + should + " -> " + graph.getNumberOfVertices());
            Tools.sleep(1000);
        }
    }

    static {
        PROXY = true;
    }
}

