/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class MyListModel<E>
extends AbstractListModel<E> {
    private static final long serialVersionUID = 1L;
    private final List<E> items = new ArrayList();
    private final List<E> filteredItems = new ArrayList();
    private static final String START_TEXT = "type to search...";
    private final FilterField filterField = new FilterField("type to search...");

    public MyListModel() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MyListModel.this.filterField.selectAll();
            }
        });
    }

    public FilterField getFilterField() {
        return this.filterField;
    }

    @Override
    public E getElementAt(int index) {
        if (index < this.filteredItems.size()) {
            return this.filteredItems.get(index);
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.filteredItems.size();
    }

    public void addElement(E o) {
        this.items.add(o);
        this.refilter();
    }

    private void refilter() {
        this.filteredItems.clear();
        String filter = this.filterField.getText();
        if (START_TEXT.equals(filter)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyListModel.this.filterField.selectAll();
                }
            });
            filter = "";
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).toString().toLowerCase(Locale.US).indexOf(filter.toLowerCase(Locale.US)) < 0) continue;
            this.filteredItems.add(this.items.get(i));
        }
        this.fireContentsChanged(this, 0, this.getSize());
    }

    private class FilterField
    extends JTextField
    implements DocumentListener {
        private static final long serialVersionUID = 1L;

        public FilterField(String text) {
            super(text);
            this.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            MyListModel.this.refilter();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            MyListModel.this.refilter();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            MyListModel.this.refilter();
        }
    }
}

