/*
 * Decompiled with CFR 0.152.
 */
package lcmc.utilities;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolTip;
import lcmc.utilities.ComponentWithTest;
import lcmc.utilities.Tools;

public class MyButton
extends JButton
implements ComponentWithTest {
    private static final long serialVersionUID = 1L;
    private static final Color DEFAULT_COLOR = Tools.getDefaultColor("DefaultButton.Background");
    private Color color1 = Color.WHITE;
    private Color color2 = DEFAULT_COLOR;
    private final Robot robot;
    private JToolTip toolTip = null;
    private static final GraphicsDevice SCREEN_DEVICE = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    private Color toolTipBackground = null;

    public MyButton() {
        Robot r = null;
        try {
            r = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appError("Robot error");
        }
        this.robot = r;
        this.setContentAreaFilled(false);
    }

    public MyButton(String text) {
        super(text);
        Robot r = null;
        try {
            r = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appError("Robot error");
        }
        this.robot = r;
        this.setContentAreaFilled(false);
    }

    public MyButton(String text, ImageIcon icon) {
        super(text, icon);
        Robot r = null;
        try {
            r = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appError("Robot error");
        }
        this.robot = r;
        this.setContentAreaFilled(false);
    }

    public MyButton(String text, ImageIcon icon, String toolTipText) {
        this(text, icon);
        super.setToolTipText(toolTipText);
    }

    public MyButton(Color c1, Color c2) {
        Robot r = null;
        try {
            r = new Robot(SCREEN_DEVICE);
        }
        catch (AWTException e) {
            Tools.appError("Robot error");
        }
        this.robot = r;
        this.color1 = c1;
        this.color2 = c2;
        this.setContentAreaFilled(false);
    }

    @Override
    public final JToolTip createToolTip() {
        this.toolTip = super.createToolTip();
        if (this.toolTipBackground != null) {
            this.toolTip.setBackground(this.toolTipBackground);
        }
        return this.toolTip;
    }

    @Override
    public final void setToolTipBackground(Color toolTipBackground) {
        this.toolTipBackground = toolTipBackground;
    }

    @Override
    public final void setToolTipText(String toolTipText) {
        if (this.toolTip != null && this.robot != null && this.toolTip.isShowing()) {
            int x2;
            int x1;
            super.setToolTipText(toolTipText);
            GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            int xOffset = 0;
            if (devices.length == 2 && (x1 = devices[0].getDefaultConfiguration().getBounds().x) > (x2 = devices[1].getDefaultConfiguration().getBounds().x)) {
                xOffset = -x1;
            }
            Point p = MouseInfo.getPointerInfo().getLocation();
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset - 1, (int)((Point2D)p).getY());
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset + 1, (int)((Point2D)p).getY());
            this.robot.mouseMove((int)((Point2D)p).getX() + xOffset, (int)((Point2D)p).getY());
        } else if (toolTipText == null) {
            super.setToolTipText("");
        } else {
            super.setToolTipText(toolTipText);
        }
    }

    final void setColor1(Color c1) {
        this.color1 = c1;
        this.repaint();
    }

    final void setColor2(Color c2) {
        this.color2 = c2;
        this.repaint();
    }

    public final void setBackgroundColor(Color c) {
        this.color2 = c == null ? DEFAULT_COLOR : c;
        super.setBackground(c);
        this.repaint();
    }

    @Override
    public final Color getBackground() {
        if (this.color2 == null) {
            return DEFAULT_COLOR;
        }
        return this.color2;
    }

    @Override
    protected final void paintComponent(Graphics g) {
        if (!this.isEnabled()) {
            super.paintComponent(g);
            return;
        }
        if (this.getModel().isPressed()) {
            this.setContentAreaFilled(true);
            super.paintComponent(g);
            return;
        }
        this.setContentAreaFilled(false);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GradientPaint gp2 = new GradientPaint(1.0f, 0.0f, Tools.brighterColor(this.getBackground(), 1.1), 1.0f, (float)this.getHeight() * 0.3f, Tools.brighterColor(this.getBackground(), 1.2));
        GradientPaint gp1 = new GradientPaint(1.0f, this.getHeight(), Tools.brighterColor(this.getBackground(), 0.85), 1.0f, (float)this.getHeight() * 0.3f, Tools.brighterColor(this.getBackground(), 1.2));
        Rectangle2D.Float rf2 = new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
        Rectangle2D.Float rf1 = new Rectangle2D.Float(3.0f, (float)this.getHeight() * 0.5f, (float)this.getWidth() - 6.0f, (float)((double)this.getHeight() * 0.5 - 3.0));
        g2.setPaint(gp2);
        g2.fill(rf2);
        g2.setPaint(gp1);
        g2.fill(rf1);
        super.paintComponent(g);
    }

    public final void pressButton() {
        this.fireActionPerformed(new ActionEvent(this, 0, "pressed"));
    }

    public final void miniButton() {
        Tools.makeMiniButton(this);
    }
}

