/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.lvm;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.Browser;
import lcmc.gui.SpringUtilities;
import lcmc.gui.dialog.lvm.LV;
import lcmc.gui.resources.BlockDevInfo;
import lcmc.gui.widget.TextfieldWithUnit;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.MyButton;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public final class LVSnapshot
extends LV {
    private static final long serialVersionUID = 1L;
    private static final int SNAPSHOT_TIMEOUT = 5000;
    private final BlockDevInfo blockDevInfo;
    private final MyButton snapshotButton = new MyButton("Create Snapshot");
    private Widget lvNameWi;
    private Widget sizeWi;
    private Widget maxSizeWi;
    private static final String SNAPSHOT_DESCRIPTION = "Create a snapshot of the logical volume.";

    public LVSnapshot(BlockDevInfo blockDevInfo) {
        super(null);
        this.blockDevInfo = blockDevInfo;
    }

    @Override
    protected void finishDialog() {
    }

    @Override
    protected String getDialogTitle() {
        return "LV Snapshot ";
    }

    @Override
    protected String getDescription() {
        return SNAPSHOT_DESCRIPTION;
    }

    @Override
    protected void initDialog() {
        super.initDialog();
        this.enableComponentsLater(new JComponent[0]);
    }

    @Override
    protected void initDialogAfterVisible() {
        this.enableComponents();
        this.makeDefaultAndRequestFocusLater(this.sizeWi);
    }

    protected void checkButtons() {
        SwingUtilities.invokeLater(new EnableSnapshotRunnable(true));
    }

    private void setComboBoxes() {
        String maxBlockSize = this.getMaxBlockSize();
        this.sizeWi.setValue(Tools.convertKilobytes(Long.toString(Long.parseLong(maxBlockSize) / 2L)));
        this.maxSizeWi.setValue(Tools.convertKilobytes(maxBlockSize));
    }

    @Override
    protected JComponent getInputPane() {
        String defaultName;
        this.snapshotButton.setEnabled(false);
        JPanel pane = new JPanel(new SpringLayout());
        JPanel inputPane = new JPanel(new SpringLayout());
        inputPane.setBackground(Browser.BUTTON_PANEL_BACKGROUND);
        String volumeGroup = this.blockDevInfo.getBlockDevice().getVolumeGroup();
        inputPane.add(new JLabel("Group"));
        inputPane.add(new JLabel(volumeGroup));
        inputPane.add(new JLabel());
        Set<String> volumeGroups = this.blockDevInfo.getHost().getLogicalVolumesFromVolumeGroup(volumeGroup);
        int i = 0;
        while (true) {
            defaultName = "lvol" + i;
            if (volumeGroups == null || !volumeGroups.contains(defaultName)) break;
            ++i;
        }
        this.lvNameWi = WidgetFactory.createInstance(Widget.Type.TEXTFIELD, defaultName, Widget.NO_ITEMS, Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        inputPane.add(new JLabel("LV Name"));
        inputPane.add(this.lvNameWi);
        inputPane.add(new JLabel());
        this.lvNameWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                LVSnapshot.this.checkButtons();
            }
        });
        String maxBlockSize = this.getMaxBlockSize();
        String newBlockSize = Long.toString(Long.parseLong(maxBlockSize) / 2L);
        JLabel sizeLabel = new JLabel("New Size");
        this.sizeWi = new TextfieldWithUnit(Tools.convertKilobytes(newBlockSize), LVSnapshot.getUnits(), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        inputPane.add(sizeLabel);
        inputPane.add(this.sizeWi);
        this.snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Tools.invokeAndWait(new EnableSnapshotRunnable(false));
                        LVSnapshot.this.disableComponents();
                        LVSnapshot.this.getProgressBar().start(5000);
                        boolean ret = LVSnapshot.this.lvSnapshot(LVSnapshot.this.lvNameWi.getStringValue(), LVSnapshot.this.sizeWi.getStringValue());
                        Host host = LVSnapshot.this.blockDevInfo.getHost();
                        host.getBrowser().getClusterBrowser().updateHWInfo(host);
                        LVSnapshot.this.setComboBoxes();
                        if (ret) {
                            LVSnapshot.this.progressBarDone();
                            LVSnapshot.this.disposeDialog();
                        } else {
                            LVSnapshot.this.progressBarDoneError();
                        }
                        LVSnapshot.this.enableComponents();
                    }
                });
                thread.start();
            }
        });
        inputPane.add(this.snapshotButton);
        JLabel maxSizeLabel = new JLabel("Max Size");
        maxSizeLabel.setEnabled(false);
        this.maxSizeWi = new TextfieldWithUnit(Tools.convertKilobytes(maxBlockSize), LVSnapshot.getUnits(), Widget.NO_REGEXP, 250, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.OP, false), Widget.NO_BUTTON);
        this.maxSizeWi.setEnabled(false);
        inputPane.add(maxSizeLabel);
        inputPane.add(this.maxSizeWi);
        inputPane.add(new JLabel());
        this.sizeWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                LVSnapshot.this.checkButtons();
            }
        });
        SpringUtilities.makeCompactGrid(inputPane, 4, 3, 1, 1, 1, 1);
        pane.add(inputPane);
        pane.add(this.getProgressBarPane(null));
        pane.add(this.getAnswerPane(""));
        SpringUtilities.makeCompactGrid(pane, 3, 1, 0, 0, 0, 0);
        this.checkButtons();
        return pane;
    }

    private boolean lvSnapshot(String lvName, String size) {
        String volumeGroup = this.blockDevInfo.getBlockDevice().getVolumeGroup();
        boolean ret = this.blockDevInfo.lvSnapshot(lvName, size, false);
        if (ret) {
            this.answerPaneSetText("Logical volume " + lvName + " was successfully created on " + volumeGroup + ".");
        } else {
            this.answerPaneSetTextError("Creating of logical volume " + lvName + " failed.");
        }
        return ret;
    }

    private String getMaxBlockSize() {
        String volumeGroup = this.blockDevInfo.getBlockDevice().getVolumeGroup();
        long free = this.blockDevInfo.getHost().getFreeInVolumeGroup(volumeGroup) / 1024L;
        return Long.toString(free);
    }

    private class EnableSnapshotRunnable
    implements Runnable {
        private final boolean enable;

        public EnableSnapshotRunnable(boolean enable) {
            this.enable = enable;
        }

        @Override
        public void run() {
            boolean e = this.enable;
            if (this.enable) {
                long maxSize;
                long size = Tools.convertToKilobytes(LVSnapshot.this.sizeWi.getStringValue());
                if (size > (maxSize = Tools.convertToKilobytes(LVSnapshot.this.maxSizeWi.getStringValue()))) {
                    e = false;
                } else if (size <= 0L) {
                    e = false;
                } else {
                    Set<String> lvs = LVSnapshot.this.blockDevInfo.getHost().getLogicalVolumesFromVolumeGroup(LVSnapshot.this.blockDevInfo.getBlockDevice().getVolumeGroup());
                    if (lvs != null && lvs.contains(LVSnapshot.this.lvNameWi.getStringValue())) {
                        e = false;
                    }
                }
            }
            LVSnapshot.this.snapshotButton.setEnabled(e);
        }
    }
}

