/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui.dialog.host;

import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import lcmc.data.AccessMode;
import lcmc.data.ConfigData;
import lcmc.data.Host;
import lcmc.gui.dialog.WizardDialog;
import lcmc.gui.widget.Widget;
import lcmc.gui.widget.WidgetFactory;
import lcmc.utilities.CancelCallback;
import lcmc.utilities.MyButton;
import lcmc.utilities.SSH;
import lcmc.utilities.Tools;
import lcmc.utilities.WidgetListener;

public abstract class DialogHost
extends WizardDialog {
    private static final long serialVersionUID = 1L;
    private final Host host;
    private SSH.ExecCommandThread commandThread = null;

    public DialogHost(WizardDialog previousDialog, Host host) {
        super(previousDialog);
        this.host = host;
    }

    protected final Host getHost() {
        return this.host;
    }

    final void setCommandThread(SSH.ExecCommandThread commandThread) {
        this.commandThread = commandThread;
        if (this.getProgressBar() != null) {
            this.getProgressBar().setCancelEnabled(commandThread != null);
        }
    }

    public final JPanel getProgressBarPane(String title) {
        CancelCallback cancelCallback = new CancelCallback(){

            @Override
            public void cancel() {
                if (DialogHost.this.commandThread != null) {
                    DialogHost.this.host.getSSH().cancelSession(DialogHost.this.commandThread);
                }
            }
        };
        return this.getProgressBarPane(title, cancelCallback);
    }

    protected final JPanel getProgressBarPane() {
        CancelCallback cancelCallback = new CancelCallback(){

            @Override
            public void cancel() {
                if (DialogHost.this.commandThread != null) {
                    DialogHost.this.host.getSSH().cancelSession(DialogHost.this.commandThread);
                }
            }
        };
        return this.getProgressBarPane(cancelCallback);
    }

    @Override
    public final void printErrorAndRetry(String text) {
        super.printErrorAndRetry(text);
        this.progressBarDone();
    }

    @Override
    public final void cancelDialog() {
    }

    @Override
    protected final String getDialogTitle() {
        StringBuilder s = new StringBuilder(50);
        s.append(this.getHostDialogTitle());
        if (this.host != null && !this.host.getName().equals("") && !this.host.getName().equals("unknown")) {
            s.append(" (");
            s.append(this.host.getName());
            s.append(')');
        }
        return s.toString();
    }

    protected abstract String getHostDialogTitle();

    protected final Widget getInstallationMethods(final String prefix, boolean staging, String lastInstalledMethod, final String autoOption, final MyButton installButton) {
        ArrayList<InstallMethods> methods = new ArrayList<InstallMethods>();
        int i = 1;
        String defaultValue = null;
        while (true) {
            String index = Integer.toString(i);
            String text = this.getHost().getDistString(prefix + ".install.text." + index);
            if (text == null || text.equals("")) {
                if (i > 9) break;
                ++i;
                continue;
            }
            String stagingMethod = this.getHost().getDistString(prefix + ".install.staging." + index);
            if (stagingMethod != null && "true".equals(stagingMethod) && !staging) {
                ++i;
                continue;
            }
            String method = this.getHost().getDistString(prefix + ".install.method." + index);
            if (method == null) {
                method = "";
            }
            InstallMethods installMethod = new InstallMethods(Tools.getString("Dialog.Host.CheckInstallation.InstallMethod") + text, i, method);
            if (text.equals(lastInstalledMethod)) {
                defaultValue = installMethod.toString();
            }
            methods.add(installMethod);
            ++i;
        }
        final Widget instMethodWi = WidgetFactory.createInstance(Widget.Type.COMBOBOX, defaultValue, methods.toArray(new InstallMethods[methods.size()]), Widget.NO_REGEXP, 0, Widget.NO_ABBRV, new AccessMode(ConfigData.AccessType.RO, false), Widget.NO_BUTTON);
        if (Tools.getConfigData().getAutoOptionHost(autoOption) != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    instMethodWi.setSelectedIndex(Integer.parseInt(Tools.getConfigData().getAutoOptionHost(autoOption)));
                }
            });
        }
        instMethodWi.addListeners(new WidgetListener(){

            @Override
            public void check(Object value) {
                InstallMethods method = (InstallMethods)instMethodWi.getValue();
                final String toolTip = DialogHost.this.getInstToolTip(prefix, method.getIndex());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        instMethodWi.setToolTipText(toolTip);
                        installButton.setToolTipText(toolTip);
                    }
                });
            }
        });
        return instMethodWi;
    }

    protected final String getInstToolTip(String prefix, String index) {
        return Tools.html(this.getHost().getDistString(prefix + ".install." + index)).replaceAll(";", ";<br>&gt; ").replaceAll("&&", "<br>&gt; &&");
    }

    public static final class InstallMethods {
        private final String name;
        private final int index;
        private final String method;

        public InstallMethods(String name, int index) {
            this(name, index, "");
        }

        public InstallMethods(String name, int index, String method) {
            this.name = name;
            this.index = index;
            this.method = method;
        }

        public String toString() {
            return this.name;
        }

        public String getIndex() {
            return Integer.toString(this.index);
        }

        String getMethod() {
            return this.method;
        }

        boolean isSourceMethod() {
            return "source".equals(this.method);
        }

        boolean isLinbitMethod() {
            return "linbit".equals(this.method);
        }
    }
}

