/*
 * Decompiled with CFR 0.152.
 */
package lcmc.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import lcmc.gui.ClusterBrowser;
import lcmc.gui.resources.CategoryInfo;
import lcmc.gui.resources.Info;
import lcmc.utilities.Tools;

public class Browser {
    private DefaultTreeModel treeModel;
    private DefaultMutableTreeNode treeTop;
    private JTree tree;
    private JSplitPane infoPanelSplitPane;
    public static final ImageIcon CATEGORY_ICON = Tools.createImageIcon(Tools.getDefault("Browser.CategoryIcon"));
    public static final ImageIcon APPLY_ICON = Tools.createImageIcon(Tools.getDefault("Browser.ApplyIcon"));
    public static final ImageIcon REVERT_ICON = Tools.createImageIcon(Tools.getDefault("Browser.RevertIcon"));
    public static final ImageIcon MENU_ICON = Tools.createImageIcon(Tools.getDefault("Browser.MenuIcon"));
    public static final Color PANEL_BACKGROUND = Tools.getDefaultColor("ViewPanel.Background");
    public static final Color BUTTON_PANEL_BACKGROUND = Tools.getDefaultColor("ViewPanel.ButtonPanel.Background");
    public static final Color STATUS_BACKGROUND = Tools.getDefaultColor("ViewPanel.Status.Background");
    static final Color EXTRA_PANEL_BACKGROUND = Tools.getDefaultColor("ViewPanel.Status.Background");
    private final Lock mDRBDtestLock = new ReentrantLock();

    protected final void setTreeTop() {
        this.treeTop = new DefaultMutableTreeNode(new CategoryInfo(Tools.getString("Browser.Resources"), this));
        this.treeModel = new DefaultTreeModel(this.treeTop);
    }

    protected final void setTreeTop(Info info) {
        this.treeTop = new DefaultMutableTreeNode(info);
        this.treeModel = new DefaultTreeModel(this.treeTop);
    }

    protected final void setTree(JTree tree) {
        this.tree = tree;
    }

    public final JTree getTree() {
        return this.tree;
    }

    public final void repaintTree() {
        JTree t = this.tree;
        if (t != null) {
            t.repaint();
        }
    }

    final DefaultMutableTreeNode getTreeTop() {
        return this.treeTop;
    }

    public final void reloadAndWait(DefaultMutableTreeNode node, boolean select) {
        JTree t = this.tree;
        DefaultMutableTreeNode oldN = null;
        if (t != null) {
            oldN = (DefaultMutableTreeNode)t.getLastSelectedPathComponent();
        }
        DefaultMutableTreeNode oldNode = oldN;
        if (node != null) {
            this.treeModel.reload(node);
        }
        if (!select && t != null && oldNode != null) {
            this.treeModel.reload(oldNode);
        }
    }

    public final void reload(final DefaultMutableTreeNode node, boolean select) {
        JTree t = this.tree;
        DefaultMutableTreeNode oldN = null;
        if (t != null) {
            oldN = (DefaultMutableTreeNode)t.getLastSelectedPathComponent();
        }
        final DefaultMutableTreeNode oldNode = oldN;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (node != null) {
                    Browser.this.treeModel.reload(node);
                }
            }
        });
        if (!select && t != null && oldNode != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Browser.this.treeModel.reload(oldNode);
                }
            });
        }
    }

    public final void nodeChanged(final DefaultMutableTreeNode node) {
        final String stacktrace = Tools.getStackTrace();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Browser.this.treeModel.nodeChanged(node);
                }
                catch (Exception e) {
                    Tools.appError(node.getUserObject() + " node changed error: ", e);
                    Tools.appWarning("stacktrace: " + stacktrace);
                }
            }
        });
    }

    protected final void topAdd(DefaultMutableTreeNode node) {
        this.treeTop.add(node);
    }

    protected final void repaintSplitPane() {
        if (this.infoPanelSplitPane != null) {
            this.infoPanelSplitPane.repaint();
        }
    }

    public final void setNode(DefaultMutableTreeNode node) {
        ((Info)node.getUserObject()).setNode(node);
    }

    final DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    final JComponent getInfoPanel(Object nodeInfo, boolean disabledDuringLoad) {
        if (nodeInfo == null) {
            return null;
        }
        JPanel gView = ((Info)nodeInfo).getGraphicalView();
        JComponent iPanel = ((Info)nodeInfo).getInfoPanel();
        if (gView == null) {
            return iPanel;
        }
        int maxWidth = ClusterBrowser.SERVICE_LABEL_WIDTH + ClusterBrowser.SERVICE_FIELD_WIDTH + 36;
        Dimension d = iPanel.getPreferredSize();
        iPanel.setMinimumSize(new Dimension(maxWidth, 0));
        iPanel.setMaximumSize(new Dimension(maxWidth, Short.MAX_VALUE));
        if (this.infoPanelSplitPane != null) {
            if (!disabledDuringLoad) {
                int loc = this.infoPanelSplitPane.getDividerLocation();
                this.infoPanelSplitPane.setLeftComponent(gView);
                this.infoPanelSplitPane.setRightComponent(iPanel);
                this.infoPanelSplitPane.setDividerLocation(loc);
            }
            return this.infoPanelSplitPane;
        }
        JSplitPane newSplitPane = new JSplitPane(1, gView, iPanel);
        newSplitPane.setResizeWeight(1.0);
        newSplitPane.setOneTouchExpandable(true);
        this.infoPanelSplitPane = newSplitPane;
        this.infoPanelSplitPane.repaint();
        return this.infoPanelSplitPane;
    }

    final CellRenderer getCellRenderer() {
        return new CellRenderer();
    }

    public final void drbdtestLockAcquire() {
        this.mDRBDtestLock.lock();
    }

    public final void drbdtestLockRelease() {
        this.mDRBDtestLock.unlock();
    }

    protected void selectPath(final Object[] path) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreePath tp = new TreePath(path);
                Browser.this.getTree().expandPath(tp);
                Browser.this.getTree().setSelectionPath(tp);
            }
        });
    }

    public final void addNode(final DefaultMutableTreeNode node, final DefaultMutableTreeNode child) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                node.add(child);
            }
        });
    }

    static class CellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        CellRenderer() {
            this.setBackgroundNonSelectionColor(PANEL_BACKGROUND);
            this.setBackgroundSelectionColor(Tools.getDefaultColor("ViewPanel.Status.Background"));
            this.setTextNonSelectionColor(Tools.getDefaultColor("ViewPanel.Foreground"));
            this.setTextSelectionColor(Tools.getDefaultColor("ViewPanel.Status.Foreground"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Info i = (Info)((DefaultMutableTreeNode)value).getUserObject();
            if (i == null) {
                return this;
            }
            if (leaf) {
                ImageIcon icon = i.getMenuIcon(false);
                if (icon != null) {
                    this.setIcon(icon);
                }
                this.setToolTipText(null);
            } else {
                this.setToolTipText(null);
                ImageIcon icon = i.getCategoryIcon(false);
                if (icon == null) {
                    icon = CATEGORY_ICON;
                }
                this.setIcon(icon);
            }
            return this;
        }
    }
}

