/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref;

import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.ref.AbstractHistogram1D;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.VariableAxis;

public class Histogram1D
extends AbstractHistogram1D
implements IHistogram1D {
    private double[] errors;
    private double[] heights;
    private int[] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double mean;
    private double rms;

    public Histogram1D(String title, double[] edges) {
        this(title, new VariableAxis(edges));
    }

    public Histogram1D(String title, int bins, double min, double max) {
        this(title, new FixedAxis(bins, min, max));
    }

    public Histogram1D(String title, IAxis axis) {
        super(title);
        this.xAxis = axis;
        int bins = axis.bins();
        this.entries = new int[bins + 2];
        this.heights = new double[bins + 2];
        this.errors = new double[bins + 2];
    }

    @Override
    public int allEntries() {
        return this.nEntry;
    }

    @Override
    public int binEntries(int index) {
        return this.entries[this.map(index)];
    }

    @Override
    public double binError(int index) {
        return Math.sqrt(this.errors[this.map(index)]);
    }

    @Override
    public double binHeight(int index) {
        return this.heights[this.map(index)];
    }

    @Override
    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    @Override
    public void fill(double x) {
        int bin;
        int n = bin = this.map(this.xAxis.coordToIndex(x));
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + 1.0;
        int n3 = bin;
        this.errors[n3] = this.errors[n3] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.mean += x;
        this.rms += x * x;
    }

    @Override
    public void fill(double x, double weight) {
        int bin;
        int n = bin = this.map(this.xAxis.coordToIndex(x));
        this.entries[n] = this.entries[n] + 1;
        int n2 = bin;
        this.heights[n2] = this.heights[n2] + weight;
        int n3 = bin;
        this.errors[n3] = this.errors[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.mean += x * weight;
        this.rms += x * weight * weight;
    }

    @Override
    public double mean() {
        return this.mean / this.sumWeight;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = 0;
            this.heights[i] = 0.0;
            this.errors[i] = 0.0;
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.mean = 0.0;
        this.rms = 0.0;
    }

    @Override
    public double rms() {
        return Math.sqrt(this.rms / this.sumWeight - this.mean * this.mean / this.sumWeight / this.sumWeight);
    }

    void setContents(int[] entries, double[] heights, double[] errors) {
        this.entries = entries;
        this.heights = heights;
        this.errors = errors;
        for (int i = 0; i < entries.length; ++i) {
            this.nEntry += entries[i];
            this.sumWeight += heights[i];
        }
        this.sumWeightSquared = Double.NaN;
        this.mean = Double.NaN;
        this.rms = Double.NaN;
    }
}

