/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization3d.control;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickResult;
import edu.uci.ics.jung.visualization3d.control.PickTranslateBehavior;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PickSphereBehavior
extends PickTranslateBehavior {
    Node oldShape;
    PropertyChangeSupport support;
    TransformGroup currGrp;
    double x_factor = 0.005;
    double y_factor = 0.005;
    double dx;
    double dy;
    Vector3d translation = new Vector3d();
    Canvas3D canvas;

    public PickSphereBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(root, canvas, bounds);
        this.setCanvas(canvas);
        this.setSchedulingBounds(bounds);
        root.addChild((Node)this);
        this.pickCanvas.setMode(256);
        this.pickCanvas.setTolerance(0.0f);
    }

    public void setTransformGroup(TransformGroup t) {
        this.currGrp = t;
    }

    public void setCanvas(Canvas3D canvas) {
        this.canvas = canvas;
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        System.err.println("update scene ");
        PickResult pickResult = null;
        Primitive shape = null;
        this.pickCanvas.setShapeLocation(xpos, ypos);
        pickResult = this.pickCanvas.pickClosest();
        if (pickResult != null && (shape = (Primitive)pickResult.getNode(4)) != null) {
            this.firePropertyChange("PeakSelected", this.oldShape, shape);
            this.oldShape = shape;
            this.setTransformGroup((TransformGroup)shape.getParent());
            this.changeTranslation(xpos, ypos);
        }
    }

    private void changeTranslation(int x, int y) {
        Transform3D currXform = new Transform3D();
        Transform3D transformX = new Transform3D();
        Transform3D transformY = new Transform3D();
        this.currGrp.getTransform(currXform);
        Point3d position = new Point3d();
        this.canvas.getPixelLocationInImagePlate(x, y, position);
        Transform3D imagePlateToVworldTransform = new Transform3D();
        this.canvas.getImagePlateToVworld(imagePlateToVworldTransform);
        this.translation.x = position.x;
        this.translation.y = position.y;
        transformX.set(this.translation);
        transformY.mul(imagePlateToVworldTransform, transformX);
        Vector3d trans = new Vector3d();
        transformY.get(trans);
        trans.x = -trans.x;
        trans.y = -trans.y;
        transformX.set(trans);
        currXform.mul(transformX, currXform);
        this.currGrp.setTransform(currXform);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.support == null) {
            this.support = new PropertyChangeSupport((Object)this);
        }
        this.support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.support != null) {
            this.support.removePropertyChangeListener(l);
        }
    }

    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        if (this.support != null) {
            this.support.firePropertyChange(name, oldValue, newValue);
        }
    }
}

