/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.scoring.BetweennessCentrality;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Transformer;

public class EdgeBetweennessClusterer<V, E>
implements Transformer<Graph<V, E>, Set<Set<V>>> {
    private int mNumEdgesToRemove;
    private Map<E, Pair<V>> edges_removed;

    public EdgeBetweennessClusterer(int numEdgesToRemove) {
        this.mNumEdgesToRemove = numEdgesToRemove;
        this.edges_removed = new LinkedHashMap<E, Pair<V>>();
    }

    @Override
    public Set<Set<V>> transform(Graph<V, E> graph) {
        if (this.mNumEdgesToRemove < 0 || this.mNumEdgesToRemove > graph.getEdgeCount()) {
            throw new IllegalArgumentException("Invalid number of edges passed in.");
        }
        this.edges_removed.clear();
        for (int k = 0; k < this.mNumEdgesToRemove; ++k) {
            BetweennessCentrality<V, E> bc = new BetweennessCentrality<V, E>(graph);
            Object to_remove = null;
            double score = 0.0;
            for (Object e : graph.getEdges()) {
                if (!((Double)bc.getEdgeScore(e) > score)) continue;
                to_remove = e;
                score = (Double)bc.getEdgeScore(e);
            }
            this.edges_removed.put(to_remove, graph.getEndpoints(to_remove));
            graph.removeEdge(to_remove);
        }
        WeakComponentClusterer<V, Object> wcSearch = new WeakComponentClusterer<V, Object>();
        Set clusterSet = wcSearch.transform(graph);
        for (Map.Entry<E, Pair<V>> entry : this.edges_removed.entrySet()) {
            Pair<V> endpoints = entry.getValue();
            graph.addEdge(entry.getKey(), endpoints.getFirst(), endpoints.getSecond());
        }
        return clusterSet;
    }

    public List<E> getEdgesRemoved() {
        return new ArrayList<E>(this.edges_removed.keySet());
    }
}

