/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.PersistentObject;
import cern.colt.function.DoubleProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import cern.jet.stat.quantile.DoubleBuffer;
import cern.jet.stat.quantile.DoubleBufferSet;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.Utils;

abstract class DoubleQuantileEstimator
extends PersistentObject
implements DoubleQuantileFinder {
    protected DoubleBufferSet bufferSet;
    protected DoubleBuffer currentBufferToFill;
    protected int totalElementsFilled;

    protected DoubleQuantileEstimator() {
    }

    @Override
    public void add(double value) {
        ++this.totalElementsFilled;
        if (!this.sampleNextElement()) {
            return;
        }
        if (this.currentBufferToFill == null) {
            if (this.bufferSet._getFirstEmptyBuffer() == null) {
                this.collapse();
            }
            this.newBuffer();
        }
        this.currentBufferToFill.add(value);
        if (this.currentBufferToFill.isFull()) {
            this.currentBufferToFill = null;
        }
    }

    @Override
    public void addAllOf(DoubleArrayList values) {
        this.addAllOfFromTo(values, 0, values.size() - 1);
    }

    @Override
    public void addAllOfFromTo(DoubleArrayList values, int from, int to) {
        int k;
        double[] valuesToAdd = values.elements();
        int bufferSize = k = this.bufferSet.k();
        double[] bufferValues = null;
        if (this.currentBufferToFill != null) {
            bufferValues = this.currentBufferToFill.values.elements();
            bufferSize = this.currentBufferToFill.size();
        }
        int i = from - 1;
        while (++i <= to) {
            if (!this.sampleNextElement()) continue;
            if (bufferSize == k) {
                if (this.bufferSet._getFirstEmptyBuffer() == null) {
                    this.collapse();
                }
                this.newBuffer();
                if (!this.currentBufferToFill.isAllocated) {
                    this.currentBufferToFill.allocate();
                }
                this.currentBufferToFill.isSorted = false;
                bufferValues = this.currentBufferToFill.values.elements();
                bufferSize = 0;
            }
            bufferValues[bufferSize++] = valuesToAdd[i];
            if (bufferSize != k) continue;
            this.currentBufferToFill.values.setSize(bufferSize);
            this.currentBufferToFill = null;
        }
        if (this.currentBufferToFill != null) {
            this.currentBufferToFill.values.setSize(bufferSize);
        }
        this.totalElementsFilled += to - from + 1;
    }

    protected DoubleBuffer[] buffersToCollapse() {
        int minLevel = this.bufferSet._getMinLevelOfFullOrPartialBuffers();
        return this.bufferSet._getFullOrPartialBuffersWithLevel(minLevel);
    }

    @Override
    public void clear() {
        this.totalElementsFilled = 0;
        this.currentBufferToFill = null;
        this.bufferSet.clear();
    }

    @Override
    public Object clone() {
        DoubleQuantileEstimator copy = (DoubleQuantileEstimator)super.clone();
        if (this.bufferSet != null) {
            copy.bufferSet = (DoubleBufferSet)copy.bufferSet.clone();
            if (this.currentBufferToFill != null) {
                int index = new ObjectArrayList(this.bufferSet.buffers).indexOf(this.currentBufferToFill, true);
                copy.currentBufferToFill = copy.bufferSet.buffers[index];
            }
        }
        return copy;
    }

    protected void collapse() {
        DoubleBuffer[] toCollapse = this.buffersToCollapse();
        DoubleBuffer outputBuffer = this.bufferSet.collapse(toCollapse);
        int minLevel = toCollapse[0].level();
        outputBuffer.level(minLevel + 1);
        this.postCollapse(toCollapse);
    }

    public boolean contains(double element) {
        return this.bufferSet.contains(element);
    }

    @Override
    public boolean forEach(DoubleProcedure procedure) {
        return this.bufferSet.forEach(procedure);
    }

    @Override
    public long memory() {
        return this.bufferSet.memory();
    }

    protected abstract void newBuffer();

    @Override
    public double phi(double element) {
        return this.bufferSet.phi(element);
    }

    protected abstract void postCollapse(DoubleBuffer[] var1);

    protected DoubleArrayList preProcessPhis(DoubleArrayList phis) {
        return phis;
    }

    @Override
    public DoubleArrayList quantileElements(DoubleArrayList phis) {
        phis = this.preProcessPhis(phis);
        long[] triggerPositions = new long[phis.size()];
        long totalSize = this.bufferSet.totalSize();
        int i = phis.size();
        while (--i >= 0) {
            triggerPositions[i] = Utils.epsilonCeiling(phis.get(i) * (double)totalSize) - 1L;
        }
        DoubleBuffer[] fullBuffers = this.bufferSet._getFullOrPartialBuffers();
        double[] quantileElements = new double[phis.size()];
        return new DoubleArrayList(this.bufferSet.getValuesAtPositions(fullBuffers, triggerPositions));
    }

    protected abstract boolean sampleNextElement();

    protected void setUp(int b, int k) {
        if (b < 2 || k < 1) {
            throw new IllegalArgumentException("Assertion: b>=2 && k>=1");
        }
        this.bufferSet = new DoubleBufferSet(b, k);
        this.clear();
    }

    @Override
    public long size() {
        return this.totalElementsFilled;
    }

    public String toString() {
        String s = this.getClass().getName();
        s = s.substring(s.lastIndexOf(46) + 1);
        int b = this.bufferSet.b();
        int k = this.bufferSet.k();
        return s + "(mem=" + this.memory() + ", b=" + b + ", k=" + k + ", size=" + this.size() + ", totalSize=" + this.bufferSet.totalSize() + ")";
    }

    @Override
    public long totalMemory() {
        return this.bufferSet.b() * this.bufferSet.k();
    }
}

