/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.engine.RandomEngine;

public class Hyperbolic
extends AbstractContinousDistribution {
    protected double alpha;
    protected double beta;
    protected double a_setup = 0.0;
    protected double b_setup = -1.0;
    protected double x;
    protected double u;
    protected double v;
    protected double e;
    protected double hr;
    protected double hl;
    protected double s;
    protected double pm;
    protected double pr;
    protected double samb;
    protected double pmr;
    protected double mpa_1;
    protected double mmb_1;
    protected static Hyperbolic shared = new Hyperbolic(10.0, 10.0, Hyperbolic.makeDefaultGenerator());

    public Hyperbolic(double alpha, double beta, RandomEngine randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(alpha, beta);
    }

    @Override
    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double nextDouble(double alpha, double beta) {
        double a = alpha;
        double b = beta;
        if (this.a_setup != a || this.b_setup != b) {
            double amb = a * a - b * b;
            this.samb = Math.sqrt(amb);
            double mode = b / this.samb;
            double help_1 = a * Math.sqrt(2.0 * this.samb + 1.0);
            double help_2 = b * (this.samb + 1.0);
            double mpa = (help_2 + help_1) / amb;
            double mmb = (help_2 - help_1) / amb;
            double a_ = mpa - mode;
            double b_ = -mmb + mode;
            this.hr = -1.0 / (-a * mpa / Math.sqrt(1.0 + mpa * mpa) + b);
            this.hl = 1.0 / (-a * mmb / Math.sqrt(1.0 + mmb * mmb) + b);
            double a_1 = a_ - this.hr;
            double b_1 = b_ - this.hl;
            this.mmb_1 = mode - b_1;
            this.mpa_1 = mode + a_1;
            this.s = a_ + b_;
            this.pm = (a_1 + b_1) / this.s;
            this.pr = this.hr / this.s;
            this.pmr = this.pm + this.pr;
            this.a_setup = a;
            this.b_setup = b;
        }
        while (true) {
            this.u = this.randomGenerator.raw();
            this.v = this.randomGenerator.raw();
            if (this.u <= this.pm) {
                this.x = this.mmb_1 + this.u * this.s;
                if (!(Math.log(this.v) <= -a * Math.sqrt(1.0 + this.x * this.x) + b * this.x + this.samb)) continue;
                return this.x;
            }
            if (this.u <= this.pmr) {
                this.e = -Math.log((this.u - this.pm) / this.pr);
                this.x = this.mpa_1 + this.hr * this.e;
                if (!(Math.log(this.v) - this.e <= -a * Math.sqrt(1.0 + this.x * this.x) + b * this.x + this.samb)) continue;
                return this.x;
            }
            this.e = Math.log((this.u - this.pmr) / (1.0 - this.pmr));
            this.x = this.mmb_1 + this.hl * this.e;
            if (Math.log(this.v) + this.e <= -a * Math.sqrt(1.0 + this.x * this.x) + b * this.x + this.samb) return this.x;
        }
    }

    public void setState(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double alpha, double beta) {
        Hyperbolic hyperbolic = shared;
        synchronized (hyperbolic) {
            return shared.nextDouble(alpha, beta);
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.alpha + "," + this.beta + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void xstaticSetRandomGenerator(RandomEngine randomGenerator) {
        Hyperbolic hyperbolic = shared;
        synchronized (hyperbolic) {
            shared.setRandomGenerator(randomGenerator);
        }
    }
}

