/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.CharComparator;
import cern.colt.function.CharProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.CharArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractCharList
extends AbstractList {
    protected int size;

    protected AbstractCharList() {
    }

    public void add(char element) {
        this.beforeInsert(this.size, element);
    }

    public void addAllOfFromTo(AbstractCharList other, int from, int to) {
        this.beforeInsertAllOfFromTo(this.size, other, from, to);
    }

    public void beforeInsert(int index, char element) {
        this.beforeInsertDummies(index, 1);
        this.set(index, element);
    }

    public void beforeInsertAllOfFromTo(int index, AbstractCharList other, int from, int to) {
        int length = to - from + 1;
        this.beforeInsertDummies(index, length);
        this.replaceFromToWithFrom(index, index + length - 1, other, from);
    }

    @Override
    protected void beforeInsertDummies(int index, int length) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (length > 0) {
            this.ensureCapacity(this.size + length);
            this.setSizeRaw(this.size + length);
            this.replaceFromToWithFrom(index + length, this.size - 1, this, index);
        }
    }

    public int binarySearch(char key) {
        return this.binarySearchFromTo(key, 0, this.size - 1);
    }

    public int binarySearchFromTo(char key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = (low + high) / 2;
            char midVal = this.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(char elem) {
        return this.indexOfFromTo(elem, 0, this.size - 1) >= 0;
    }

    public void delete(char element) {
        int index = this.indexOfFromTo(element, 0, this.size - 1);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public char[] elements() {
        char[] myElements = new char[this.size];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public AbstractCharList elements(char[] elements) {
        this.clear();
        this.addAllOfFromTo(new CharArrayList(elements), 0, elements.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof AbstractCharList)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        if (otherObj == null) {
            return false;
        }
        AbstractCharList other = (AbstractCharList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = this.size();
        while (--i >= 0) {
            if (this.getQuick(i) == other.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int from, int to, char val) {
        AbstractCharList.checkRangeFromTo(from, to, this.size);
        int i = from;
        while (i <= to) {
            this.setQuick(i++, val);
        }
    }

    public boolean forEach(CharProcedure procedure) {
        int i = 0;
        while (i < this.size) {
            if (procedure.apply(this.get(i++))) continue;
            return false;
        }
        return true;
    }

    public char get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.getQuick(index);
    }

    protected abstract char getQuick(int var1);

    public int indexOf(char element) {
        return this.indexOfFromTo(element, 0, this.size - 1);
    }

    public int indexOfFromTo(char element, int from, int to) {
        AbstractCharList.checkRangeFromTo(from, to, this.size);
        for (int i = from; i <= to; ++i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char element) {
        return this.lastIndexOfFromTo(element, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(char element, int from, int to) {
        AbstractCharList.checkRangeFromTo(from, to, this.size());
        for (int i = to; i >= from; --i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void mergeSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractCharList.checkRangeFromTo(from, to, mySize);
        char[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void mergeSortFromTo(int from, int to, CharComparator c) {
        int mySize = this.size();
        AbstractCharList.checkRangeFromTo(from, to, mySize);
        char[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public AbstractCharList partFromTo(int from, int to) {
        AbstractCharList.checkRangeFromTo(from, to, this.size);
        int length = to - from + 1;
        CharArrayList part = new CharArrayList(length);
        part.addAllOfFromTo(this, from, to);
        return part;
    }

    @Override
    public void quickSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractCharList.checkRangeFromTo(from, to, mySize);
        char[] myElements = this.elements();
        java.util.Arrays.sort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void quickSortFromTo(int from, int to, CharComparator c) {
        int mySize = this.size();
        AbstractCharList.checkRangeFromTo(from, to, mySize);
        char[] myElements = this.elements();
        Sorting.quickSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public boolean removeAll(AbstractCharList other) {
        if (other.size() == 0) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) >= 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void removeFromTo(int from, int to) {
        int width;
        AbstractCharList.checkRangeFromTo(from, to, this.size);
        int numMoved = this.size - to - 1;
        if (numMoved > 0) {
            this.replaceFromToWithFrom(from, from - 1 + numMoved, this, to + 1);
        }
        if ((width = to - from + 1) > 0) {
            this.setSizeRaw(this.size - width);
        }
    }

    public void replaceFromToWithFrom(int from, int to, AbstractCharList other, int otherFrom) {
        block4: {
            int length = to - from + 1;
            if (length <= 0) break block4;
            AbstractCharList.checkRangeFromTo(from, to, this.size());
            AbstractCharList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            if (from <= otherFrom) {
                while (--length >= 0) {
                    this.setQuick(from++, other.getQuick(otherFrom++));
                }
            } else {
                int otherTo = otherFrom + length - 1;
                while (--length >= 0) {
                    this.setQuick(to--, other.getQuick(otherTo--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int from, int to, AbstractCharList other, int otherFrom, int otherTo) {
        int length;
        if (otherFrom > otherTo) {
            throw new IndexOutOfBoundsException("otherFrom: " + otherFrom + ", otherTo: " + otherTo);
        }
        if (this == other && to - from != otherTo - otherFrom) {
            this.replaceFromToWithFromTo(from, to, this.partFromTo(otherFrom, otherTo), 0, otherTo - otherFrom);
            return;
        }
        int diff = length = otherTo - otherFrom + 1;
        int theLast = from - 1;
        if (to >= from) {
            diff -= to - from + 1;
            theLast = to;
        }
        if (diff > 0) {
            this.beforeInsertDummies(theLast + 1, diff);
        } else if (diff < 0) {
            this.removeFromTo(theLast + diff, theLast - 1);
        }
        if (length > 0) {
            this.replaceFromToWithFrom(from, from + length - 1, other, otherFrom);
        }
    }

    @Override
    public void replaceFromWith(int from, Collection other) {
        AbstractCharList.checkRange(from, this.size());
        Iterator e = other.iterator();
        int index = from;
        int limit = Math.min(this.size() - from, other.size());
        for (int i = 0; i < limit; ++i) {
            this.set(index++, ((Character)e.next()).charValue());
        }
    }

    public boolean retainAll(AbstractCharList other) {
        if (other.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) < 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size() / 2;
        int j = this.size() - 1;
        int i = 0;
        while (i < limit) {
            char tmp = this.getQuick(i);
            this.setQuick(i++, this.getQuick(j));
            this.setQuick(j--, tmp);
        }
    }

    public void set(int index, char element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.setQuick(index, element);
    }

    protected abstract void setQuick(int var1, char var2);

    protected void setSizeRaw(int newSize) {
        this.size = newSize;
    }

    @Override
    public void shuffleFromTo(int from, int to) {
        AbstractCharList.checkRangeFromTo(from, to, this.size());
        Uniform gen = new Uniform(new DRand(new Date()));
        for (int i = from; i < to; ++i) {
            int random = gen.nextIntFromTo(i, to);
            char tmpElement = this.getQuick(random);
            this.setQuick(random, this.getQuick(i));
            this.setQuick(i, tmpElement);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractCharList times(int times) {
        CharArrayList newList = new CharArrayList(times * this.size());
        int i = times;
        while (--i >= 0) {
            newList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return newList;
    }

    @Override
    public ArrayList toList() {
        int mySize = this.size();
        ArrayList<Character> list = new ArrayList<Character>(mySize);
        for (int i = 0; i < mySize; ++i) {
            list.add(new Character(this.get(i)));
        }
        return list;
    }

    @Override
    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

