/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.constraint;

import java.lang.reflect.Array;
import org.jmock.core.Constraint;
import org.jmock.core.Formatting;

public class IsEqual
implements Constraint {
    private Object object;

    public IsEqual(Object object) {
        this.object = object;
    }

    @Override
    public boolean eval(Object object) {
        return IsEqual.areEqual(this.object, object);
    }

    @Override
    public StringBuffer describeTo(StringBuffer stringBuffer) {
        return stringBuffer.append("eq(").append(Formatting.toReadableString(this.object)).append(")");
    }

    private static boolean areEqual(Object object, Object object2) {
        if (object == null || object2 == null) {
            return object == null && object2 == null;
        }
        if (IsEqual.isArray(object)) {
            return IsEqual.isArray(object2) && IsEqual.areArraysEqual(object, object2);
        }
        return object.equals(object2);
    }

    private static boolean areArraysEqual(Object object, Object object2) {
        return IsEqual.areArrayLengthsEqual(object, object2) && IsEqual.areArrayElementsEqual(object, object2);
    }

    private static boolean areArrayLengthsEqual(Object object, Object object2) {
        return Array.getLength(object) == Array.getLength(object2);
    }

    private static boolean areArrayElementsEqual(Object object, Object object2) {
        for (int i = 0; i < Array.getLength(object); ++i) {
            if (IsEqual.areEqual(Array.get(object, i), Array.get(object2, i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isArray(Object object) {
        return object.getClass().isArray();
    }
}

