/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.builder;

import java.lang.reflect.Method;
import junit.framework.AssertionFailedError;
import org.jmock.builder.ArgumentsMatchBuilder;
import org.jmock.builder.BuilderNamespace;
import org.jmock.builder.IdentityBuilder;
import org.jmock.builder.MatchBuilder;
import org.jmock.builder.NameMatchBuilder;
import org.jmock.core.Constraint;
import org.jmock.core.InvocationMatcher;
import org.jmock.core.Stub;
import org.jmock.core.StubMatchersCollection;
import org.jmock.core.constraint.IsNull;
import org.jmock.core.matcher.AnyArgumentsMatcher;
import org.jmock.core.matcher.ArgumentsMatcher;
import org.jmock.core.matcher.InvokedAfterMatcher;
import org.jmock.core.matcher.InvokedRecorder;
import org.jmock.core.matcher.MethodNameMatcher;
import org.jmock.core.matcher.NoArgumentsMatcher;
import org.jmock.core.stub.VoidStub;

public class InvocationMockerBuilder
implements NameMatchBuilder {
    private StubMatchersCollection mocker;
    private BuilderNamespace builderNamespace;
    private Class mockedType;

    public InvocationMockerBuilder(StubMatchersCollection stubMatchersCollection, BuilderNamespace builderNamespace, Class clazz) {
        this.mocker = stubMatchersCollection;
        this.builderNamespace = builderNamespace;
        this.mockedType = clazz;
    }

    @Override
    public ArgumentsMatchBuilder method(Constraint constraint) {
        return this.addMatcher(new MethodNameMatcher(constraint));
    }

    @Override
    public ArgumentsMatchBuilder method(String string) {
        this.checkLegalMethodName(string);
        this.checkExistingMethodName(string);
        this.addMatcher(new MethodNameMatcher(string));
        this.builderNamespace.registerMethodName(string, this);
        return this;
    }

    private void checkLegalMethodName(String string) {
        if (!this.isLegalMethodName(string)) {
            throw new IllegalArgumentException("illegal method name: " + string + " is not a legal Java identifier");
        }
    }

    private boolean isLegalMethodName(String string) {
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void checkExistingMethodName(String string) {
        if (!this.typeDefinesMethodNamed(this.mockedType, string) && !this.typeDefinesMethodNamed(Object.class, string)) {
            throw new AssertionFailedError("no method named " + string + " is defined in type " + this.mockedType);
        }
    }

    private boolean typeDefinesMethodNamed(Class clazz, String string) {
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MatchBuilder match(InvocationMatcher invocationMatcher) {
        return this.addMatcher(invocationMatcher);
    }

    @Override
    public MatchBuilder with(Constraint constraint) {
        return this.with(new Constraint[]{constraint});
    }

    @Override
    public MatchBuilder with(Constraint constraint, Constraint constraint2) {
        return this.with(new Constraint[]{constraint, constraint2});
    }

    @Override
    public MatchBuilder with(Constraint constraint, Constraint constraint2, Constraint constraint3) {
        return this.with(new Constraint[]{constraint, constraint2, constraint3});
    }

    @Override
    public MatchBuilder with(Constraint constraint, Constraint constraint2, Constraint constraint3, Constraint constraint4) {
        return this.with(new Constraint[]{constraint, constraint2, constraint3, constraint4});
    }

    @Override
    public MatchBuilder with(Constraint[] constraintArray) {
        for (int i = 0; i < constraintArray.length; ++i) {
            if (constraintArray[i] != null) continue;
            constraintArray[i] = new IsNull();
        }
        return this.addMatcher(new ArgumentsMatcher(constraintArray));
    }

    @Override
    public MatchBuilder withNoArguments() {
        return this.addMatcher(NoArgumentsMatcher.INSTANCE);
    }

    @Override
    public MatchBuilder withAnyArguments() {
        return this.addMatcher(AnyArgumentsMatcher.INSTANCE);
    }

    @Override
    public IdentityBuilder will(Stub stub) {
        this.setStub(stub);
        return this;
    }

    @Override
    public IdentityBuilder isVoid() {
        this.setStub(VoidStub.INSTANCE);
        return this;
    }

    private void setStub(Stub stub) {
        this.mocker.setStub(stub);
    }

    public IdentityBuilder expect(InvocationMatcher invocationMatcher) {
        return this.addMatcher(invocationMatcher);
    }

    @Override
    public void id(String string) {
        this.mocker.setName(string);
        this.builderNamespace.registerUniqueID(string, this);
    }

    @Override
    public MatchBuilder after(String string) {
        this.setupOrderingMatchers(this.builderNamespace, string, string);
        return this;
    }

    @Override
    public MatchBuilder after(BuilderNamespace builderNamespace, String string) {
        this.setupOrderingMatchers(builderNamespace, string, string + " on " + builderNamespace);
        return this;
    }

    private void setupOrderingMatchers(BuilderNamespace builderNamespace, String string, String string2) {
        MatchBuilder matchBuilder = builderNamespace.lookupID(string);
        if (matchBuilder == this) {
            throw new AssertionFailedError("confusing identifier of prior invocation \"" + string + "\"; " + "give it an explicit call identifier");
        }
        InvokedRecorder invokedRecorder = new InvokedRecorder();
        matchBuilder.match(invokedRecorder);
        this.mocker.addMatcher(new InvokedAfterMatcher(invokedRecorder, string2));
    }

    private InvocationMockerBuilder addMatcher(InvocationMatcher invocationMatcher) {
        this.mocker.addMatcher(invocationMatcher);
        return this;
    }
}

