/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.constants.DNSConstants;

class SocketListener
extends Thread {
    static Logger logger = Logger.getLogger(SocketListener.class.getName());
    private final JmDNSImpl _jmDNSImpl;

    SocketListener(JmDNSImpl jmDNSImpl) {
        super("SocketListener(" + (jmDNSImpl != null ? jmDNSImpl.getName() : "") + ")");
        this.setDaemon(true);
        this._jmDNSImpl = jmDNSImpl;
    }

    @Override
    public void run() {
        block10: {
            try {
                byte[] byArray = new byte[8972];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                while (!this._jmDNSImpl.isCanceling() && !this._jmDNSImpl.isCanceled()) {
                    datagramPacket.setLength(byArray.length);
                    this._jmDNSImpl.getSocket().receive(datagramPacket);
                    if (!(this._jmDNSImpl.isCanceling() || this._jmDNSImpl.isCanceled() || this._jmDNSImpl.isClosing() || this._jmDNSImpl.isClosed())) {
                        try {
                            if (this._jmDNSImpl.getLocalHost().shouldIgnorePacket(datagramPacket)) continue;
                            DNSIncoming dNSIncoming = new DNSIncoming(datagramPacket);
                            if (logger.isLoggable(Level.FINEST)) {
                                logger.finest(this.getName() + ".run() JmDNS in:" + dNSIncoming.print(true));
                            }
                            if (dNSIncoming.isQuery()) {
                                if (datagramPacket.getPort() != DNSConstants.MDNS_PORT) {
                                    this._jmDNSImpl.handleQuery(dNSIncoming, datagramPacket.getAddress(), datagramPacket.getPort());
                                }
                                this._jmDNSImpl.handleQuery(dNSIncoming, this._jmDNSImpl.getGroup(), DNSConstants.MDNS_PORT);
                                continue;
                            }
                            this._jmDNSImpl.handleResponse(dNSIncoming);
                        }
                        catch (IOException iOException) {
                            logger.log(Level.WARNING, this.getName() + ".run() exception ", iOException);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                if (this._jmDNSImpl.isCanceling() || this._jmDNSImpl.isCanceled() || this._jmDNSImpl.isClosing() || this._jmDNSImpl.isClosed()) break block10;
                logger.log(Level.WARNING, this.getName() + ".run() exception ", iOException);
                this._jmDNSImpl.recover();
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest(this.getName() + ".run() exiting.");
        }
    }

    public JmDNSImpl getDns() {
        return this._jmDNSImpl;
    }
}

